/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.terracotta.shaded.lucene.index.DocumentsWriter;
import org.terracotta.shaded.lucene.index.RawPostingList;
import org.terracotta.shaded.lucene.index.SegmentWriteState;
import org.terracotta.shaded.lucene.index.TermVectorsTermsWriterPerField;
import org.terracotta.shaded.lucene.index.TermVectorsTermsWriterPerThread;
import org.terracotta.shaded.lucene.index.TermVectorsWriter;
import org.terracotta.shaded.lucene.index.TermsHashConsumer;
import org.terracotta.shaded.lucene.index.TermsHashConsumerPerField;
import org.terracotta.shaded.lucene.index.TermsHashConsumerPerThread;
import org.terracotta.shaded.lucene.index.TermsHashPerThread;
import org.terracotta.shaded.lucene.store.IndexOutput;
import org.terracotta.shaded.lucene.store.RAMOutputStream;
import org.terracotta.shaded.lucene.util.ArrayUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TermVectorsTermsWriter
extends TermsHashConsumer {
    final DocumentsWriter docWriter;
    TermVectorsWriter termVectorsWriter;
    PerDoc[] docFreeList = new PerDoc[1];
    int freeCount;
    IndexOutput tvx;
    IndexOutput tvd;
    IndexOutput tvf;
    int lastDocID;
    int allocCount;

    public TermVectorsTermsWriter(DocumentsWriter docWriter) {
        this.docWriter = docWriter;
    }

    @Override
    public TermsHashConsumerPerThread addThread(TermsHashPerThread termsHashPerThread) {
        return new TermVectorsTermsWriterPerThread(termsHashPerThread, this);
    }

    @Override
    void createPostings(RawPostingList[] postings, int start, int count) {
        int end = start + count;
        for (int i = start; i < end; ++i) {
            postings[i] = new PostingList();
        }
    }

    @Override
    synchronized void flush(Map<TermsHashConsumerPerThread, Collection<TermsHashConsumerPerField>> threadsAndFields, SegmentWriteState state) throws IOException {
        if (this.tvx != null) {
            if (state.numDocsInStore > 0) {
                this.fill(state.numDocsInStore - this.docWriter.getDocStoreOffset());
            }
            this.tvx.flush();
            this.tvd.flush();
            this.tvf.flush();
        }
        for (Map.Entry<TermsHashConsumerPerThread, Collection<TermsHashConsumerPerField>> entry : threadsAndFields.entrySet()) {
            for (TermsHashConsumerPerField field : entry.getValue()) {
                TermVectorsTermsWriterPerField perField = (TermVectorsTermsWriterPerField)field;
                perField.termsHashPerField.reset();
                perField.shrinkHash();
            }
            TermVectorsTermsWriterPerThread perThread = (TermVectorsTermsWriterPerThread)entry.getKey();
            perThread.termsHashPerThread.reset(true);
        }
    }

    @Override
    synchronized void closeDocStore(SegmentWriteState state) throws IOException {
        if (this.tvx != null) {
            this.fill(state.numDocsInStore - this.docWriter.getDocStoreOffset());
            this.tvx.close();
            this.tvf.close();
            this.tvd.close();
            this.tvx = null;
            assert (state.docStoreSegmentName != null);
            String fileName = state.docStoreSegmentName + "." + "tvx";
            if (4L + (long)state.numDocsInStore * 16L != state.directory.fileLength(fileName)) {
                throw new RuntimeException("after flush: tvx size mismatch: " + state.numDocsInStore + " docs vs " + state.directory.fileLength(fileName) + " length in bytes of " + fileName + " file exists?=" + state.directory.fileExists(fileName));
            }
            state.flushedFiles.add(state.docStoreSegmentName + "." + "tvx");
            state.flushedFiles.add(state.docStoreSegmentName + "." + "tvf");
            state.flushedFiles.add(state.docStoreSegmentName + "." + "tvd");
            this.docWriter.removeOpenFile(state.docStoreSegmentName + "." + "tvx");
            this.docWriter.removeOpenFile(state.docStoreSegmentName + "." + "tvf");
            this.docWriter.removeOpenFile(state.docStoreSegmentName + "." + "tvd");
            this.lastDocID = 0;
        }
    }

    synchronized PerDoc getPerDoc() {
        if (this.freeCount == 0) {
            ++this.allocCount;
            if (this.allocCount > this.docFreeList.length) {
                assert (this.allocCount == 1 + this.docFreeList.length);
                this.docFreeList = new PerDoc[ArrayUtil.getNextSize(this.allocCount)];
            }
            return new PerDoc();
        }
        return this.docFreeList[--this.freeCount];
    }

    void fill(int docID) throws IOException {
        int docStoreOffset = this.docWriter.getDocStoreOffset();
        int end = docID + docStoreOffset;
        if (this.lastDocID < end) {
            long tvfPosition = this.tvf.getFilePointer();
            while (this.lastDocID < end) {
                this.tvx.writeLong(this.tvd.getFilePointer());
                this.tvd.writeVInt(0);
                this.tvx.writeLong(tvfPosition);
                ++this.lastDocID;
            }
        }
    }

    synchronized void initTermVectorsWriter() throws IOException {
        if (this.tvx == null) {
            String docStoreSegment = this.docWriter.getDocStoreSegment();
            if (docStoreSegment == null) {
                return;
            }
            assert (docStoreSegment != null);
            this.tvx = this.docWriter.directory.createOutput(docStoreSegment + "." + "tvx");
            this.tvd = this.docWriter.directory.createOutput(docStoreSegment + "." + "tvd");
            this.tvf = this.docWriter.directory.createOutput(docStoreSegment + "." + "tvf");
            this.tvx.writeInt(4);
            this.tvd.writeInt(4);
            this.tvf.writeInt(4);
            this.docWriter.addOpenFile(docStoreSegment + "." + "tvx");
            this.docWriter.addOpenFile(docStoreSegment + "." + "tvf");
            this.docWriter.addOpenFile(docStoreSegment + "." + "tvd");
            this.lastDocID = 0;
        }
    }

    synchronized void finishDocument(PerDoc perDoc) throws IOException {
        assert (this.docWriter.writer.testPoint("TermVectorsTermsWriter.finishDocument start"));
        this.initTermVectorsWriter();
        this.fill(perDoc.docID);
        this.tvx.writeLong(this.tvd.getFilePointer());
        this.tvx.writeLong(this.tvf.getFilePointer());
        this.tvd.writeVInt(perDoc.numVectorFields);
        if (perDoc.numVectorFields > 0) {
            for (int i = 0; i < perDoc.numVectorFields; ++i) {
                this.tvd.writeVInt(perDoc.fieldNumbers[i]);
            }
            assert (0L == perDoc.fieldPointers[0]);
            long lastPos = perDoc.fieldPointers[0];
            for (int i = 1; i < perDoc.numVectorFields; ++i) {
                long pos = perDoc.fieldPointers[i];
                this.tvd.writeVLong(pos - lastPos);
                lastPos = pos;
            }
            perDoc.perDocTvf.writeTo(this.tvf);
            perDoc.numVectorFields = 0;
        }
        assert (this.lastDocID == perDoc.docID + this.docWriter.getDocStoreOffset());
        ++this.lastDocID;
        perDoc.reset();
        this.free(perDoc);
        assert (this.docWriter.writer.testPoint("TermVectorsTermsWriter.finishDocument end"));
    }

    public boolean freeRAM() {
        return false;
    }

    @Override
    public void abort() {
        if (this.tvx != null) {
            try {
                this.tvx.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.tvx = null;
        }
        if (this.tvd != null) {
            try {
                this.tvd.close();
            }
            catch (Throwable t) {
                // empty catch block
            }
            this.tvd = null;
        }
        if (this.tvf != null) {
            try {
                this.tvf.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.tvf = null;
        }
        this.lastDocID = 0;
    }

    synchronized void free(PerDoc doc) {
        assert (this.freeCount < this.docFreeList.length);
        this.docFreeList[this.freeCount++] = doc;
    }

    @Override
    int bytesPerPosting() {
        return 32;
    }

    static final class PostingList
    extends RawPostingList {
        int freq;
        int lastOffset;
        int lastPosition;

        PostingList() {
        }
    }

    class PerDoc
    extends DocumentsWriter.DocWriter {
        final DocumentsWriter.PerDocBuffer buffer;
        RAMOutputStream perDocTvf;
        int numVectorFields;
        int[] fieldNumbers;
        long[] fieldPointers;

        PerDoc() {
            this.buffer = TermVectorsTermsWriter.this.docWriter.newPerDocBuffer();
            this.perDocTvf = new RAMOutputStream(this.buffer);
            this.fieldNumbers = new int[1];
            this.fieldPointers = new long[1];
        }

        void reset() {
            this.perDocTvf.reset();
            this.buffer.recycle();
            this.numVectorFields = 0;
        }

        void abort() {
            this.reset();
            TermVectorsTermsWriter.this.free(this);
        }

        void addField(int fieldNumber) {
            if (this.numVectorFields == this.fieldNumbers.length) {
                this.fieldNumbers = ArrayUtil.grow(this.fieldNumbers);
                this.fieldPointers = ArrayUtil.grow(this.fieldPointers);
            }
            this.fieldNumbers[this.numVectorFields] = fieldNumber;
            this.fieldPointers[this.numVectorFields] = this.perDocTvf.getFilePointer();
            ++this.numVectorFields;
        }

        public long sizeInBytes() {
            return this.buffer.getSizeInBytes();
        }

        public void finish() throws IOException {
            TermVectorsTermsWriter.this.finishDocument(this);
        }
    }
}

