/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.index;

import java.io.IOException;
import org.terracotta.shaded.lucene.index.CorruptIndexException;
import org.terracotta.shaded.lucene.index.FieldInfos;
import org.terracotta.shaded.lucene.index.Term;
import org.terracotta.shaded.lucene.index.TermBuffer;
import org.terracotta.shaded.lucene.index.TermEnum;
import org.terracotta.shaded.lucene.index.TermInfo;
import org.terracotta.shaded.lucene.store.IndexInput;

final class SegmentTermEnum
extends TermEnum
implements Cloneable {
    private IndexInput input;
    FieldInfos fieldInfos;
    long size;
    long position = -1L;
    private TermBuffer termBuffer = new TermBuffer();
    private TermBuffer prevBuffer = new TermBuffer();
    private TermBuffer scanBuffer = new TermBuffer();
    private TermInfo termInfo = new TermInfo();
    private int format;
    private boolean isIndex = false;
    long indexPointer = 0L;
    int indexInterval;
    int skipInterval;
    int maxSkipLevels;
    private int formatM1SkipInterval;

    SegmentTermEnum(IndexInput i, FieldInfos fis, boolean isi) throws CorruptIndexException, IOException {
        this.input = i;
        this.fieldInfos = fis;
        this.isIndex = isi;
        this.maxSkipLevels = 1;
        int firstInt = this.input.readInt();
        if (firstInt >= 0) {
            this.format = 0;
            this.size = firstInt;
            this.indexInterval = 128;
            this.skipInterval = Integer.MAX_VALUE;
        } else {
            this.format = firstInt;
            if (this.format < -4) {
                throw new CorruptIndexException("Unknown format version:" + this.format + " expected " + -4 + " or higher");
            }
            this.size = this.input.readLong();
            if (this.format == -1) {
                if (!this.isIndex) {
                    this.indexInterval = this.input.readInt();
                    this.formatM1SkipInterval = this.input.readInt();
                }
                this.skipInterval = Integer.MAX_VALUE;
            } else {
                this.indexInterval = this.input.readInt();
                this.skipInterval = this.input.readInt();
                if (this.format <= -3) {
                    this.maxSkipLevels = this.input.readInt();
                }
            }
            assert (this.indexInterval > 0) : "indexInterval=" + this.indexInterval + " is negative; must be > 0";
            assert (this.skipInterval > 0) : "skipInterval=" + this.skipInterval + " is negative; must be > 0";
        }
        if (this.format > -4) {
            this.termBuffer.setPreUTF8Strings();
            this.scanBuffer.setPreUTF8Strings();
            this.prevBuffer.setPreUTF8Strings();
        }
    }

    protected Object clone() {
        SegmentTermEnum clone = null;
        try {
            clone = (SegmentTermEnum)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        clone.input = (IndexInput)this.input.clone();
        clone.termInfo = new TermInfo(this.termInfo);
        clone.termBuffer = (TermBuffer)this.termBuffer.clone();
        clone.prevBuffer = (TermBuffer)this.prevBuffer.clone();
        clone.scanBuffer = new TermBuffer();
        return clone;
    }

    final void seek(long pointer, long p, Term t, TermInfo ti) throws IOException {
        this.input.seek(pointer);
        this.position = p;
        this.termBuffer.set(t);
        this.prevBuffer.reset();
        this.termInfo.set(ti);
    }

    public final boolean next() throws IOException {
        if (this.position++ >= this.size - 1L) {
            this.prevBuffer.set(this.termBuffer);
            this.termBuffer.reset();
            return false;
        }
        this.prevBuffer.set(this.termBuffer);
        this.termBuffer.read(this.input, this.fieldInfos);
        this.termInfo.docFreq = this.input.readVInt();
        this.termInfo.freqPointer += this.input.readVLong();
        this.termInfo.proxPointer += this.input.readVLong();
        if (this.format == -1) {
            if (!this.isIndex && this.termInfo.docFreq > this.formatM1SkipInterval) {
                this.termInfo.skipOffset = this.input.readVInt();
            }
        } else if (this.termInfo.docFreq >= this.skipInterval) {
            this.termInfo.skipOffset = this.input.readVInt();
        }
        if (this.isIndex) {
            this.indexPointer += this.input.readVLong();
        }
        return true;
    }

    final int scanTo(Term term) throws IOException {
        this.scanBuffer.set(term);
        int count = 0;
        while (this.scanBuffer.compareTo(this.termBuffer) > 0 && this.next()) {
            ++count;
        }
        return count;
    }

    public final Term term() {
        return this.termBuffer.toTerm();
    }

    final Term prev() {
        return this.prevBuffer.toTerm();
    }

    final TermInfo termInfo() {
        return new TermInfo(this.termInfo);
    }

    final void termInfo(TermInfo ti) {
        ti.set(this.termInfo);
    }

    public final int docFreq() {
        return this.termInfo.docFreq;
    }

    final long freqPointer() {
        return this.termInfo.freqPointer;
    }

    final long proxPointer() {
        return this.termInfo.proxPointer;
    }

    public final void close() throws IOException {
        this.input.close();
    }
}

