/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.index;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.terracotta.shaded.lucene.index.CorruptIndexException;
import org.terracotta.shaded.lucene.index.IndexWriter;
import org.terracotta.shaded.lucene.index.SegmentInfo;
import org.terracotta.shaded.lucene.index.SegmentInfos;
import org.terracotta.shaded.lucene.index.SegmentReader;
import org.terracotta.shaded.lucene.store.Directory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MergePolicy
implements Closeable {
    protected final IndexWriter writer;

    public MergePolicy(IndexWriter writer) {
        this.writer = writer;
    }

    public abstract MergeSpecification findMerges(SegmentInfos var1) throws CorruptIndexException, IOException;

    public abstract MergeSpecification findMergesForOptimize(SegmentInfos var1, int var2, Set<SegmentInfo> var3) throws CorruptIndexException, IOException;

    public abstract MergeSpecification findMergesToExpungeDeletes(SegmentInfos var1) throws CorruptIndexException, IOException;

    @Override
    public abstract void close();

    public abstract boolean useCompoundFile(SegmentInfos var1, SegmentInfo var2);

    public abstract boolean useCompoundDocStore(SegmentInfos var1);

    public static class MergeAbortedException
    extends IOException {
        public MergeAbortedException() {
            super("merge is aborted");
        }

        public MergeAbortedException(String message) {
            super(message);
        }
    }

    public static class MergeException
    extends RuntimeException {
        private Directory dir;

        public MergeException(String message, Directory dir) {
            super(message);
            this.dir = dir;
        }

        public MergeException(Throwable exc, Directory dir) {
            super(exc);
            this.dir = dir;
        }

        public Directory getDirectory() {
            return this.dir;
        }
    }

    public static class MergeSpecification {
        public List<OneMerge> merges = new ArrayList<OneMerge>();

        public void add(OneMerge merge) {
            this.merges.add(merge);
        }

        public String segString(Directory dir) {
            StringBuilder b = new StringBuilder();
            b.append("MergeSpec:\n");
            int count = this.merges.size();
            for (int i = 0; i < count; ++i) {
                b.append("  ").append(1 + i).append(": ").append(this.merges.get(i).segString(dir));
            }
            return b.toString();
        }
    }

    public static class OneMerge {
        SegmentInfo info;
        boolean mergeDocStores;
        boolean optimize;
        boolean registerDone;
        long mergeGen;
        boolean isExternal;
        int maxNumSegmentsOptimize;
        SegmentReader[] readers;
        SegmentReader[] readersClone;
        final SegmentInfos segments;
        final boolean useCompoundFile;
        boolean aborted;
        Throwable error;

        public OneMerge(SegmentInfos segments, boolean useCompoundFile) {
            if (0 == segments.size()) {
                throw new RuntimeException("segments must include at least one segment");
            }
            this.segments = segments;
            this.useCompoundFile = useCompoundFile;
        }

        synchronized void setException(Throwable error) {
            this.error = error;
        }

        synchronized Throwable getException() {
            return this.error;
        }

        synchronized void abort() {
            this.aborted = true;
        }

        synchronized boolean isAborted() {
            return this.aborted;
        }

        synchronized void checkAborted(Directory dir) throws MergeAbortedException {
            if (this.aborted) {
                throw new MergeAbortedException("merge is aborted: " + this.segString(dir));
            }
        }

        String segString(Directory dir) {
            StringBuilder b = new StringBuilder();
            int numSegments = this.segments.size();
            for (int i = 0; i < numSegments; ++i) {
                if (i > 0) {
                    b.append(' ');
                }
                b.append(this.segments.info(i).segString(dir));
            }
            if (this.info != null) {
                b.append(" into ").append(this.info.name);
            }
            if (this.optimize) {
                b.append(" [optimize]");
            }
            if (this.mergeDocStores) {
                b.append(" [mergeDocStores]");
            }
            return b.toString();
        }
    }
}

