/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.index;

import java.io.IOException;
import org.terracotta.shaded.lucene.analysis.tokenattributes.PayloadAttribute;
import org.terracotta.shaded.lucene.document.Fieldable;
import org.terracotta.shaded.lucene.index.DocumentsWriter;
import org.terracotta.shaded.lucene.index.FieldInfo;
import org.terracotta.shaded.lucene.index.FieldInvertState;
import org.terracotta.shaded.lucene.index.FreqProxTermsWriter;
import org.terracotta.shaded.lucene.index.FreqProxTermsWriterPerThread;
import org.terracotta.shaded.lucene.index.Payload;
import org.terracotta.shaded.lucene.index.RawPostingList;
import org.terracotta.shaded.lucene.index.TermsHashConsumerPerField;
import org.terracotta.shaded.lucene.index.TermsHashPerField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FreqProxTermsWriterPerField
extends TermsHashConsumerPerField
implements Comparable<FreqProxTermsWriterPerField> {
    final FreqProxTermsWriterPerThread perThread;
    final TermsHashPerField termsHashPerField;
    final FieldInfo fieldInfo;
    final DocumentsWriter.DocState docState;
    final FieldInvertState fieldState;
    boolean omitTermFreqAndPositions;
    PayloadAttribute payloadAttribute;
    boolean hasPayloads;

    public FreqProxTermsWriterPerField(TermsHashPerField termsHashPerField, FreqProxTermsWriterPerThread perThread, FieldInfo fieldInfo) {
        this.termsHashPerField = termsHashPerField;
        this.perThread = perThread;
        this.fieldInfo = fieldInfo;
        this.docState = termsHashPerField.docState;
        this.fieldState = termsHashPerField.fieldState;
        this.omitTermFreqAndPositions = fieldInfo.omitTermFreqAndPositions;
    }

    @Override
    int getStreamCount() {
        if (this.fieldInfo.omitTermFreqAndPositions) {
            return 1;
        }
        return 2;
    }

    @Override
    void finish() {
    }

    @Override
    void skippingLongTerm() throws IOException {
    }

    @Override
    public int compareTo(FreqProxTermsWriterPerField other) {
        return this.fieldInfo.name.compareTo(other.fieldInfo.name);
    }

    void reset() {
        this.omitTermFreqAndPositions = this.fieldInfo.omitTermFreqAndPositions;
        this.payloadAttribute = null;
    }

    @Override
    boolean start(Fieldable[] fields, int count) {
        for (int i = 0; i < count; ++i) {
            if (!fields[i].isIndexed()) continue;
            return true;
        }
        return false;
    }

    @Override
    void start(Fieldable f) {
        this.payloadAttribute = this.fieldState.attributeSource.hasAttribute(PayloadAttribute.class) ? this.fieldState.attributeSource.getAttribute(PayloadAttribute.class) : null;
    }

    final void writeProx(FreqProxTermsWriter.PostingList p, int proxCode) {
        Payload payload = this.payloadAttribute == null ? null : this.payloadAttribute.getPayload();
        if (payload != null && payload.length > 0) {
            this.termsHashPerField.writeVInt(1, proxCode << 1 | 1);
            this.termsHashPerField.writeVInt(1, payload.length);
            this.termsHashPerField.writeBytes(1, payload.data, payload.offset, payload.length);
            this.hasPayloads = true;
        } else {
            this.termsHashPerField.writeVInt(1, proxCode << 1);
        }
        p.lastPosition = this.fieldState.position;
    }

    @Override
    final void newTerm(RawPostingList p0) {
        assert (this.docState.testPoint("FreqProxTermsWriterPerField.newTerm start"));
        FreqProxTermsWriter.PostingList p = (FreqProxTermsWriter.PostingList)p0;
        p.lastDocID = this.docState.docID;
        if (this.omitTermFreqAndPositions) {
            p.lastDocCode = this.docState.docID;
        } else {
            p.lastDocCode = this.docState.docID << 1;
            p.docFreq = 1;
            this.writeProx(p, this.fieldState.position);
        }
    }

    @Override
    final void addTerm(RawPostingList p0) {
        assert (this.docState.testPoint("FreqProxTermsWriterPerField.addTerm start"));
        FreqProxTermsWriter.PostingList p = (FreqProxTermsWriter.PostingList)p0;
        assert (this.omitTermFreqAndPositions || p.docFreq > 0);
        if (this.omitTermFreqAndPositions) {
            if (this.docState.docID != p.lastDocID) {
                assert (this.docState.docID > p.lastDocID);
                this.termsHashPerField.writeVInt(0, p.lastDocCode);
                p.lastDocCode = this.docState.docID - p.lastDocID;
                p.lastDocID = this.docState.docID;
            }
        } else if (this.docState.docID != p.lastDocID) {
            assert (this.docState.docID > p.lastDocID);
            if (1 == p.docFreq) {
                this.termsHashPerField.writeVInt(0, p.lastDocCode | 1);
            } else {
                this.termsHashPerField.writeVInt(0, p.lastDocCode);
                this.termsHashPerField.writeVInt(0, p.docFreq);
            }
            p.docFreq = 1;
            p.lastDocCode = this.docState.docID - p.lastDocID << 1;
            p.lastDocID = this.docState.docID;
            this.writeProx(p, this.fieldState.position);
        } else {
            ++p.docFreq;
            this.writeProx(p, this.fieldState.position - p.lastPosition);
        }
    }

    public void abort() {
    }
}

