/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.index;

import java.io.IOException;
import org.terracotta.shaded.lucene.index.FieldInfo;
import org.terracotta.shaded.lucene.index.FormatPostingsDocsWriter;
import org.terracotta.shaded.lucene.index.FormatPostingsPositionsConsumer;
import org.terracotta.shaded.lucene.index.IndexFileNames;
import org.terracotta.shaded.lucene.index.SegmentWriteState;
import org.terracotta.shaded.lucene.store.IndexOutput;

final class FormatPostingsPositionsWriter
extends FormatPostingsPositionsConsumer {
    final FormatPostingsDocsWriter parent;
    final IndexOutput out;
    boolean omitTermFreqAndPositions;
    boolean storePayloads;
    int lastPayloadLength = -1;
    int lastPosition;

    FormatPostingsPositionsWriter(SegmentWriteState state, FormatPostingsDocsWriter parent) throws IOException {
        this.parent = parent;
        this.omitTermFreqAndPositions = parent.omitTermFreqAndPositions;
        if (parent.parent.parent.fieldInfos.hasProx()) {
            String fileName = IndexFileNames.segmentFileName(parent.parent.parent.segment, "prx");
            state.flushedFiles.add(fileName);
            this.out = parent.parent.parent.dir.createOutput(fileName);
            parent.skipListWriter.setProxOutput(this.out);
        } else {
            this.out = null;
        }
    }

    void addPosition(int position, byte[] payload, int payloadOffset, int payloadLength) throws IOException {
        assert (!this.omitTermFreqAndPositions) : "omitTermFreqAndPositions is true";
        assert (this.out != null);
        int delta = position - this.lastPosition;
        this.lastPosition = position;
        if (this.storePayloads) {
            if (payloadLength != this.lastPayloadLength) {
                this.lastPayloadLength = payloadLength;
                this.out.writeVInt(delta << 1 | 1);
                this.out.writeVInt(payloadLength);
            } else {
                this.out.writeVInt(delta << 1);
            }
            if (payloadLength > 0) {
                this.out.writeBytes(payload, payloadLength);
            }
        } else {
            this.out.writeVInt(delta);
        }
    }

    void setField(FieldInfo fieldInfo) {
        this.omitTermFreqAndPositions = fieldInfo.omitTermFreqAndPositions;
        this.storePayloads = this.omitTermFreqAndPositions ? false : fieldInfo.storePayloads;
    }

    void finish() {
        this.lastPosition = 0;
        this.lastPayloadLength = -1;
    }

    void close() throws IOException {
        if (this.out != null) {
            this.out.close();
        }
    }
}

