/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.index;

import java.io.IOException;
import org.terracotta.shaded.lucene.index.CorruptIndexException;
import org.terracotta.shaded.lucene.index.DefaultSkipListWriter;
import org.terracotta.shaded.lucene.index.FieldInfo;
import org.terracotta.shaded.lucene.index.FormatPostingsDocsConsumer;
import org.terracotta.shaded.lucene.index.FormatPostingsPositionsConsumer;
import org.terracotta.shaded.lucene.index.FormatPostingsPositionsWriter;
import org.terracotta.shaded.lucene.index.FormatPostingsTermsWriter;
import org.terracotta.shaded.lucene.index.IndexFileNames;
import org.terracotta.shaded.lucene.index.SegmentWriteState;
import org.terracotta.shaded.lucene.index.TermInfo;
import org.terracotta.shaded.lucene.store.IndexOutput;
import org.terracotta.shaded.lucene.util.UnicodeUtil;

final class FormatPostingsDocsWriter
extends FormatPostingsDocsConsumer {
    final IndexOutput out;
    final FormatPostingsTermsWriter parent;
    final FormatPostingsPositionsWriter posWriter;
    final DefaultSkipListWriter skipListWriter;
    final int skipInterval;
    final int totalNumDocs;
    boolean omitTermFreqAndPositions;
    boolean storePayloads;
    long freqStart;
    FieldInfo fieldInfo;
    int lastDocID;
    int df;
    private final TermInfo termInfo = new TermInfo();
    final UnicodeUtil.UTF8Result utf8 = new UnicodeUtil.UTF8Result();

    FormatPostingsDocsWriter(SegmentWriteState state, FormatPostingsTermsWriter parent) throws IOException {
        this.parent = parent;
        String fileName = IndexFileNames.segmentFileName(parent.parent.segment, "frq");
        state.flushedFiles.add(fileName);
        this.out = parent.parent.dir.createOutput(fileName);
        this.totalNumDocs = parent.parent.totalNumDocs;
        this.skipInterval = parent.parent.termsOut.skipInterval;
        this.skipListWriter = parent.parent.skipListWriter;
        this.skipListWriter.setFreqOutput(this.out);
        this.posWriter = new FormatPostingsPositionsWriter(state, this);
    }

    void setField(FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.omitTermFreqAndPositions = fieldInfo.omitTermFreqAndPositions;
        this.storePayloads = fieldInfo.storePayloads;
        this.posWriter.setField(fieldInfo);
    }

    FormatPostingsPositionsConsumer addDoc(int docID, int termDocFreq) throws IOException {
        int delta = docID - this.lastDocID;
        if (docID < 0 || this.df > 0 && delta <= 0) {
            throw new CorruptIndexException("docs out of order (" + docID + " <= " + this.lastDocID + " )");
        }
        if (++this.df % this.skipInterval == 0) {
            this.skipListWriter.setSkipData(this.lastDocID, this.storePayloads, this.posWriter.lastPayloadLength);
            this.skipListWriter.bufferSkip(this.df);
        }
        assert (docID < this.totalNumDocs) : "docID=" + docID + " totalNumDocs=" + this.totalNumDocs;
        this.lastDocID = docID;
        if (this.omitTermFreqAndPositions) {
            this.out.writeVInt(delta);
        } else if (1 == termDocFreq) {
            this.out.writeVInt(delta << 1 | 1);
        } else {
            this.out.writeVInt(delta << 1);
            this.out.writeVInt(termDocFreq);
        }
        return this.posWriter;
    }

    void finish() throws IOException {
        long skipPointer = this.skipListWriter.writeSkip(this.out);
        this.termInfo.set(this.df, this.parent.freqStart, this.parent.proxStart, (int)(skipPointer - this.parent.freqStart));
        UnicodeUtil.UTF16toUTF8(this.parent.currentTerm, this.parent.currentTermStart, this.utf8);
        if (this.df > 0) {
            this.parent.termsOut.add(this.fieldInfo.number, this.utf8.result, this.utf8.length, this.termInfo);
        }
        this.lastDocID = 0;
        this.df = 0;
    }

    void close() throws IOException {
        this.out.close();
        this.posWriter.close();
    }
}

