/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.index;

import java.io.IOException;
import org.terracotta.shaded.lucene.analysis.tokenattributes.OffsetAttribute;
import org.terracotta.shaded.lucene.analysis.tokenattributes.TermAttribute;
import org.terracotta.shaded.lucene.index.DocFieldConsumerPerField;
import org.terracotta.shaded.lucene.index.DocFieldConsumerPerThread;
import org.terracotta.shaded.lucene.index.DocFieldProcessorPerThread;
import org.terracotta.shaded.lucene.index.DocInverter;
import org.terracotta.shaded.lucene.index.DocInverterPerField;
import org.terracotta.shaded.lucene.index.DocumentsWriter;
import org.terracotta.shaded.lucene.index.FieldInfo;
import org.terracotta.shaded.lucene.index.FieldInvertState;
import org.terracotta.shaded.lucene.index.InvertedDocConsumerPerThread;
import org.terracotta.shaded.lucene.index.InvertedDocEndConsumerPerThread;
import org.terracotta.shaded.lucene.index.ReusableStringReader;
import org.terracotta.shaded.lucene.util.AttributeSource;

final class DocInverterPerThread
extends DocFieldConsumerPerThread {
    final DocInverter docInverter;
    final InvertedDocConsumerPerThread consumer;
    final InvertedDocEndConsumerPerThread endConsumer;
    final SingleTokenAttributeSource singleToken = new SingleTokenAttributeSource();
    final DocumentsWriter.DocState docState;
    final FieldInvertState fieldState = new FieldInvertState();
    final ReusableStringReader stringReader = new ReusableStringReader();

    public DocInverterPerThread(DocFieldProcessorPerThread docFieldProcessorPerThread, DocInverter docInverter) {
        this.docInverter = docInverter;
        this.docState = docFieldProcessorPerThread.docState;
        this.consumer = docInverter.consumer.addThread(this);
        this.endConsumer = docInverter.endConsumer.addThread(this);
    }

    public void startDocument() throws IOException {
        this.consumer.startDocument();
        this.endConsumer.startDocument();
    }

    public DocumentsWriter.DocWriter finishDocument() throws IOException {
        this.endConsumer.finishDocument();
        return this.consumer.finishDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void abort() {
        try {
            this.consumer.abort();
            Object var2_1 = null;
            this.endConsumer.abort();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.endConsumer.abort();
            throw throwable;
        }
    }

    public DocFieldConsumerPerField addField(FieldInfo fi) {
        return new DocInverterPerField(this, fi);
    }

    static class SingleTokenAttributeSource
    extends AttributeSource {
        final TermAttribute termAttribute = this.addAttribute(TermAttribute.class);
        final OffsetAttribute offsetAttribute = this.addAttribute(OffsetAttribute.class);

        private SingleTokenAttributeSource() {
        }

        public void reinit(String stringValue, int startOffset, int endOffset) {
            this.termAttribute.setTermBuffer(stringValue);
            this.offsetAttribute.setOffset(startOffset, endOffset);
        }
    }
}

