/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.terracotta.shaded.lucene.index.DocFieldConsumer;
import org.terracotta.shaded.lucene.index.DocFieldConsumerPerField;
import org.terracotta.shaded.lucene.index.DocFieldConsumerPerThread;
import org.terracotta.shaded.lucene.index.DocFieldProcessorPerThread;
import org.terracotta.shaded.lucene.index.DocInverterPerField;
import org.terracotta.shaded.lucene.index.DocInverterPerThread;
import org.terracotta.shaded.lucene.index.FieldInfos;
import org.terracotta.shaded.lucene.index.InvertedDocConsumer;
import org.terracotta.shaded.lucene.index.InvertedDocConsumerPerField;
import org.terracotta.shaded.lucene.index.InvertedDocConsumerPerThread;
import org.terracotta.shaded.lucene.index.InvertedDocEndConsumer;
import org.terracotta.shaded.lucene.index.InvertedDocEndConsumerPerField;
import org.terracotta.shaded.lucene.index.InvertedDocEndConsumerPerThread;
import org.terracotta.shaded.lucene.index.SegmentWriteState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DocInverter
extends DocFieldConsumer {
    final InvertedDocConsumer consumer;
    final InvertedDocEndConsumer endConsumer;

    public DocInverter(InvertedDocConsumer consumer, InvertedDocEndConsumer endConsumer) {
        this.consumer = consumer;
        this.endConsumer = endConsumer;
    }

    @Override
    void setFieldInfos(FieldInfos fieldInfos) {
        super.setFieldInfos(fieldInfos);
        this.consumer.setFieldInfos(fieldInfos);
        this.endConsumer.setFieldInfos(fieldInfos);
    }

    @Override
    void flush(Map<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>> threadsAndFields, SegmentWriteState state) throws IOException {
        HashMap<InvertedDocConsumerPerThread, Collection<InvertedDocConsumerPerField>> childThreadsAndFields = new HashMap<InvertedDocConsumerPerThread, Collection<InvertedDocConsumerPerField>>();
        HashMap<InvertedDocEndConsumerPerThread, Collection<InvertedDocEndConsumerPerField>> endChildThreadsAndFields = new HashMap<InvertedDocEndConsumerPerThread, Collection<InvertedDocEndConsumerPerField>>();
        for (Map.Entry<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>> entry : threadsAndFields.entrySet()) {
            DocInverterPerThread perThread = (DocInverterPerThread)entry.getKey();
            HashSet<InvertedDocConsumerPerField> childFields = new HashSet<InvertedDocConsumerPerField>();
            HashSet<InvertedDocEndConsumerPerField> endChildFields = new HashSet<InvertedDocEndConsumerPerField>();
            for (DocFieldConsumerPerField field : entry.getValue()) {
                DocInverterPerField perField = (DocInverterPerField)field;
                childFields.add(perField.consumer);
                endChildFields.add(perField.endConsumer);
            }
            childThreadsAndFields.put(perThread.consumer, childFields);
            endChildThreadsAndFields.put(perThread.endConsumer, endChildFields);
        }
        this.consumer.flush(childThreadsAndFields, state);
        this.endConsumer.flush(endChildThreadsAndFields, state);
    }

    @Override
    public void closeDocStore(SegmentWriteState state) throws IOException {
        this.consumer.closeDocStore(state);
        this.endConsumer.closeDocStore(state);
    }

    @Override
    void abort() {
        this.consumer.abort();
        this.endConsumer.abort();
    }

    @Override
    public boolean freeRAM() {
        return this.consumer.freeRAM();
    }

    @Override
    public DocFieldConsumerPerThread addThread(DocFieldProcessorPerThread docFieldProcessorPerThread) {
        return new DocInverterPerThread(docFieldProcessorPerThread, this);
    }
}

