/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.index;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.terracotta.shaded.lucene.index.DocConsumer;
import org.terracotta.shaded.lucene.index.DocConsumerPerThread;
import org.terracotta.shaded.lucene.index.DocFieldConsumer;
import org.terracotta.shaded.lucene.index.DocFieldConsumerPerField;
import org.terracotta.shaded.lucene.index.DocFieldConsumerPerThread;
import org.terracotta.shaded.lucene.index.DocFieldProcessorPerThread;
import org.terracotta.shaded.lucene.index.DocumentsWriter;
import org.terracotta.shaded.lucene.index.DocumentsWriterThreadState;
import org.terracotta.shaded.lucene.index.FieldInfos;
import org.terracotta.shaded.lucene.index.SegmentWriteState;
import org.terracotta.shaded.lucene.index.StoredFieldsWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DocFieldProcessor
extends DocConsumer {
    final DocumentsWriter docWriter;
    final FieldInfos fieldInfos = new FieldInfos();
    final DocFieldConsumer consumer;
    final StoredFieldsWriter fieldsWriter;

    public DocFieldProcessor(DocumentsWriter docWriter, DocFieldConsumer consumer) {
        this.docWriter = docWriter;
        this.consumer = consumer;
        consumer.setFieldInfos(this.fieldInfos);
        this.fieldsWriter = new StoredFieldsWriter(docWriter, this.fieldInfos);
    }

    @Override
    public void closeDocStore(SegmentWriteState state) throws IOException {
        this.consumer.closeDocStore(state);
        this.fieldsWriter.closeDocStore(state);
    }

    @Override
    public void flush(Collection<DocConsumerPerThread> threads, SegmentWriteState state) throws IOException {
        HashMap<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>> childThreadsAndFields = new HashMap<DocFieldConsumerPerThread, Collection<DocFieldConsumerPerField>>();
        for (DocConsumerPerThread thread : threads) {
            DocFieldProcessorPerThread perThread = (DocFieldProcessorPerThread)thread;
            childThreadsAndFields.put(perThread.consumer, perThread.fields());
            perThread.trimFields(state);
        }
        this.fieldsWriter.flush(state);
        this.consumer.flush(childThreadsAndFields, state);
        String fileName = state.segmentFileName("fnm");
        this.fieldInfos.write(state.directory, fileName);
        state.flushedFiles.add(fileName);
    }

    @Override
    public void abort() {
        this.fieldsWriter.abort();
        this.consumer.abort();
    }

    @Override
    public boolean freeRAM() {
        return this.consumer.freeRAM();
    }

    @Override
    public DocConsumerPerThread addThread(DocumentsWriterThreadState threadState) throws IOException {
        return new DocFieldProcessorPerThread(threadState, this);
    }
}

