/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.analysis.standard;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Set;
import org.terracotta.shaded.lucene.analysis.Analyzer;
import org.terracotta.shaded.lucene.analysis.LowerCaseFilter;
import org.terracotta.shaded.lucene.analysis.StopAnalyzer;
import org.terracotta.shaded.lucene.analysis.StopFilter;
import org.terracotta.shaded.lucene.analysis.TokenFilter;
import org.terracotta.shaded.lucene.analysis.TokenStream;
import org.terracotta.shaded.lucene.analysis.WordlistLoader;
import org.terracotta.shaded.lucene.analysis.standard.StandardFilter;
import org.terracotta.shaded.lucene.analysis.standard.StandardTokenizer;
import org.terracotta.shaded.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardAnalyzer
extends Analyzer {
    private Set<?> stopSet;
    private final boolean replaceInvalidAcronym;
    private final boolean enableStopPositionIncrements;
    public static final Set<?> STOP_WORDS_SET = StopAnalyzer.ENGLISH_STOP_WORDS_SET;
    private final Version matchVersion;
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;
    private int maxTokenLength = 255;

    public StandardAnalyzer(Version matchVersion) {
        this(matchVersion, STOP_WORDS_SET);
    }

    public StandardAnalyzer(Version matchVersion, Set<?> stopWords) {
        this.stopSet = stopWords;
        this.setOverridesTokenStreamMethod(StandardAnalyzer.class);
        this.enableStopPositionIncrements = StopFilter.getEnablePositionIncrementsVersionDefault(matchVersion);
        this.replaceInvalidAcronym = matchVersion.onOrAfter(Version.LUCENE_24);
        this.matchVersion = matchVersion;
    }

    public StandardAnalyzer(Version matchVersion, File stopwords) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet(stopwords));
    }

    public StandardAnalyzer(Version matchVersion, Reader stopwords) throws IOException {
        this(matchVersion, WordlistLoader.getWordSet(stopwords));
    }

    @Override
    public TokenStream tokenStream(String fieldName, Reader reader) {
        StandardTokenizer tokenStream = new StandardTokenizer(this.matchVersion, reader);
        tokenStream.setMaxTokenLength(this.maxTokenLength);
        TokenFilter result = new StandardFilter(tokenStream);
        result = new LowerCaseFilter(result);
        result = new StopFilter(this.enableStopPositionIncrements, result, this.stopSet);
        return result;
    }

    public void setMaxTokenLength(int length) {
        this.maxTokenLength = length;
    }

    public int getMaxTokenLength() {
        return this.maxTokenLength;
    }

    @Override
    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        if (this.overridesTokenStreamMethod) {
            return this.tokenStream(fieldName, reader);
        }
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            this.setPreviousTokenStream(streams);
            streams.tokenStream = new StandardTokenizer(this.matchVersion, reader);
            streams.filteredTokenStream = new StandardFilter(streams.tokenStream);
            streams.filteredTokenStream = new LowerCaseFilter(streams.filteredTokenStream);
            streams.filteredTokenStream = new StopFilter(this.enableStopPositionIncrements, streams.filteredTokenStream, this.stopSet);
        } else {
            streams.tokenStream.reset(reader);
        }
        streams.tokenStream.setMaxTokenLength(this.maxTokenLength);
        streams.tokenStream.setReplaceInvalidAcronym(this.replaceInvalidAcronym);
        return streams.filteredTokenStream;
    }

    private static final class SavedStreams {
        StandardTokenizer tokenStream;
        TokenStream filteredTokenStream;

        private SavedStreams() {
        }
    }
}

