/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.terracotta.shaded.lucene.analysis.CharReader;
import org.terracotta.shaded.lucene.analysis.CharStream;
import org.terracotta.shaded.lucene.analysis.TokenStream;
import org.terracotta.shaded.lucene.util.AttributeSource;

public abstract class Tokenizer
extends TokenStream {
    protected Reader input;

    protected Tokenizer() {
    }

    protected Tokenizer(Reader input) {
        this.input = CharReader.get(input);
    }

    protected Tokenizer(AttributeSource.AttributeFactory factory) {
        super(factory);
    }

    protected Tokenizer(AttributeSource.AttributeFactory factory, Reader input) {
        super(factory);
        this.input = CharReader.get(input);
    }

    protected Tokenizer(AttributeSource source) {
        super(source);
    }

    protected Tokenizer(AttributeSource source, Reader input) {
        super(source);
        this.input = CharReader.get(input);
    }

    public void close() throws IOException {
        if (this.input != null) {
            this.input.close();
            this.input = null;
        }
    }

    protected final int correctOffset(int currentOff) {
        return this.input instanceof CharStream ? ((CharStream)this.input).correctOffset(currentOff) : currentOff;
    }

    public void reset(Reader input) throws IOException {
        this.input = input;
    }
}

