/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.analysis;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.terracotta.shaded.lucene.analysis.Analyzer;
import org.terracotta.shaded.lucene.analysis.CharArraySet;
import org.terracotta.shaded.lucene.analysis.LowerCaseTokenizer;
import org.terracotta.shaded.lucene.analysis.StopFilter;
import org.terracotta.shaded.lucene.analysis.TokenStream;
import org.terracotta.shaded.lucene.analysis.Tokenizer;
import org.terracotta.shaded.lucene.analysis.WordlistLoader;
import org.terracotta.shaded.lucene.util.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StopAnalyzer
extends Analyzer {
    private final Set<?> stopWords;
    private final boolean enablePositionIncrements;
    public static final Set<?> ENGLISH_STOP_WORDS_SET;

    public StopAnalyzer(Version matchVersion) {
        this.stopWords = ENGLISH_STOP_WORDS_SET;
        this.enablePositionIncrements = StopFilter.getEnablePositionIncrementsVersionDefault(matchVersion);
    }

    public StopAnalyzer(Version matchVersion, Set<?> stopWords) {
        this.stopWords = stopWords;
        this.enablePositionIncrements = StopFilter.getEnablePositionIncrementsVersionDefault(matchVersion);
    }

    public StopAnalyzer(Version matchVersion, File stopwordsFile) throws IOException {
        this.stopWords = WordlistLoader.getWordSet(stopwordsFile);
        this.enablePositionIncrements = StopFilter.getEnablePositionIncrementsVersionDefault(matchVersion);
    }

    public StopAnalyzer(Version matchVersion, Reader stopwords) throws IOException {
        this.stopWords = WordlistLoader.getWordSet(stopwords);
        this.enablePositionIncrements = StopFilter.getEnablePositionIncrementsVersionDefault(matchVersion);
    }

    @Override
    public TokenStream tokenStream(String fieldName, Reader reader) {
        return new StopFilter(this.enablePositionIncrements, new LowerCaseTokenizer(reader), this.stopWords);
    }

    @Override
    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        SavedStreams streams = (SavedStreams)this.getPreviousTokenStream();
        if (streams == null) {
            streams = new SavedStreams();
            streams.source = new LowerCaseTokenizer(reader);
            streams.result = new StopFilter(this.enablePositionIncrements, streams.source, this.stopWords);
            this.setPreviousTokenStream(streams);
        } else {
            streams.source.reset(reader);
        }
        return streams.result;
    }

    static {
        List<String> stopWords = Arrays.asList("a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with");
        CharArraySet stopSet = new CharArraySet(stopWords.size(), false);
        stopSet.addAll(stopWords);
        ENGLISH_STOP_WORDS_SET = CharArraySet.unmodifiableSet(stopSet);
    }

    private class SavedStreams {
        Tokenizer source;
        TokenStream result;

        private SavedStreams() {
        }
    }
}

