/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.analysis;

import java.io.IOException;
import org.terracotta.shaded.lucene.analysis.TokenFilter;
import org.terracotta.shaded.lucene.analysis.TokenStream;
import org.terracotta.shaded.lucene.analysis.tokenattributes.TermAttribute;

public final class LengthFilter
extends TokenFilter {
    final int min;
    final int max;
    private TermAttribute termAtt;

    public LengthFilter(TokenStream in, int min, int max) {
        super(in);
        this.min = min;
        this.max = max;
        this.termAtt = this.addAttribute(TermAttribute.class);
    }

    public final boolean incrementToken() throws IOException {
        while (this.input.incrementToken()) {
            int len = this.termAtt.termLength();
            if (len < this.min || len > this.max) continue;
            return true;
        }
        return false;
    }
}

