/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.terracotta.shaded.lucene.analysis.Tokenizer;
import org.terracotta.shaded.lucene.analysis.tokenattributes.OffsetAttribute;
import org.terracotta.shaded.lucene.analysis.tokenattributes.TermAttribute;
import org.terracotta.shaded.lucene.util.AttributeSource;

public final class KeywordTokenizer
extends Tokenizer {
    private static final int DEFAULT_BUFFER_SIZE = 256;
    private boolean done;
    private int finalOffset;
    private TermAttribute termAtt;
    private OffsetAttribute offsetAtt;

    public KeywordTokenizer(Reader input) {
        this(input, 256);
    }

    public KeywordTokenizer(Reader input, int bufferSize) {
        super(input);
        this.init(bufferSize);
    }

    public KeywordTokenizer(AttributeSource source, Reader input, int bufferSize) {
        super(source, input);
        this.init(bufferSize);
    }

    public KeywordTokenizer(AttributeSource.AttributeFactory factory, Reader input, int bufferSize) {
        super(factory, input);
        this.init(bufferSize);
    }

    private void init(int bufferSize) {
        this.done = false;
        this.termAtt = this.addAttribute(TermAttribute.class);
        this.offsetAtt = this.addAttribute(OffsetAttribute.class);
        this.termAtt.resizeTermBuffer(bufferSize);
    }

    public final boolean incrementToken() throws IOException {
        if (!this.done) {
            int length;
            this.clearAttributes();
            this.done = true;
            int upto = 0;
            char[] buffer = this.termAtt.termBuffer();
            while ((length = this.input.read(buffer, upto, buffer.length - upto)) != -1) {
                if ((upto += length) != buffer.length) continue;
                buffer = this.termAtt.resizeTermBuffer(1 + buffer.length);
            }
            this.termAtt.setTermLength(upto);
            this.finalOffset = this.correctOffset(upto);
            this.offsetAtt.setOffset(this.correctOffset(0), this.finalOffset);
            return true;
        }
        return false;
    }

    public final void end() {
        this.offsetAtt.setOffset(this.finalOffset, this.finalOffset);
    }

    public void reset(Reader input) throws IOException {
        super.reset(input);
        this.done = false;
    }
}

