/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.analysis;

import java.io.IOException;
import java.io.Reader;
import org.terracotta.shaded.lucene.analysis.Analyzer;
import org.terracotta.shaded.lucene.analysis.KeywordTokenizer;
import org.terracotta.shaded.lucene.analysis.TokenStream;
import org.terracotta.shaded.lucene.analysis.Tokenizer;

public class KeywordAnalyzer
extends Analyzer {
    public KeywordAnalyzer() {
        this.setOverridesTokenStreamMethod(KeywordAnalyzer.class);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        return new KeywordTokenizer(reader);
    }

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        if (this.overridesTokenStreamMethod) {
            return this.tokenStream(fieldName, reader);
        }
        Tokenizer tokenizer = (Tokenizer)this.getPreviousTokenStream();
        if (tokenizer == null) {
            tokenizer = new KeywordTokenizer(reader);
            this.setPreviousTokenStream(tokenizer);
        } else {
            tokenizer.reset(reader);
        }
        return tokenizer;
    }
}

