/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.shaded.lucene.analysis;

import java.io.Closeable;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Method;
import org.terracotta.shaded.lucene.analysis.TokenStream;
import org.terracotta.shaded.lucene.document.Fieldable;
import org.terracotta.shaded.lucene.store.AlreadyClosedException;
import org.terracotta.shaded.lucene.util.CloseableThreadLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Analyzer
implements Closeable {
    private CloseableThreadLocal<Object> tokenStreams = new CloseableThreadLocal();
    protected boolean overridesTokenStreamMethod = false;

    public abstract TokenStream tokenStream(String var1, Reader var2);

    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        return this.tokenStream(fieldName, reader);
    }

    protected Object getPreviousTokenStream() {
        try {
            return this.tokenStreams.get();
        }
        catch (NullPointerException npe) {
            if (this.tokenStreams == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            throw npe;
        }
    }

    protected void setPreviousTokenStream(Object obj) {
        try {
            this.tokenStreams.set(obj);
        }
        catch (NullPointerException npe) {
            if (this.tokenStreams == null) {
                throw new AlreadyClosedException("this Analyzer is closed");
            }
            throw npe;
        }
    }

    protected void setOverridesTokenStreamMethod(Class<? extends Analyzer> baseClass) {
        try {
            Method m = this.getClass().getMethod("tokenStream", String.class, Reader.class);
            this.overridesTokenStreamMethod = m.getDeclaringClass() != baseClass;
        }
        catch (NoSuchMethodException nsme) {
            this.overridesTokenStreamMethod = false;
        }
    }

    public int getPositionIncrementGap(String fieldName) {
        return 0;
    }

    public int getOffsetGap(Fieldable field) {
        if (field.isTokenized()) {
            return 1;
        }
        return 0;
    }

    @Override
    public void close() {
        this.tokenStreams.close();
        this.tokenStreams = null;
    }
}

