/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search.store;

import com.terracottatech.offheapstore.filesystem.FileSystem;
import com.terracottatech.search.store.ConcurrentLockFactory;
import com.terracottatech.search.store.OffHeapIndexInputStream;
import com.terracottatech.search.store.OffHeapIndexOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Set;
import org.terracotta.shaded.lucene.store.Directory;
import org.terracotta.shaded.lucene.store.IndexInput;
import org.terracotta.shaded.lucene.store.IndexOutput;
import org.terracotta.shaded.lucene.util.ThreadInterruptedException;

public class OffHeapDirectory
extends Directory
implements Serializable {
    private final com.terracottatech.offheapstore.filesystem.Directory directory;

    public OffHeapDirectory(FileSystem fileSystem, String name) throws IOException {
        if (fileSystem.directoryExists(name)) {
            fileSystem.deleteDirectory(name);
        }
        this.directory = fileSystem.getOrCreateDirectory(name);
        this.setLockFactory(new ConcurrentLockFactory());
    }

    @Override
    public synchronized String[] listAll() throws IOException {
        Set<String> filesSet = this.directory.listFiles();
        ArrayList<String> names = new ArrayList<String>(filesSet.size());
        for (String fname : filesSet) {
            names.add(fname);
        }
        return names.toArray(new String[names.size()]);
    }

    @Override
    public boolean fileExists(String name) {
        return this.directory.fileExists(name);
    }

    @Override
    public long fileModified(String name) throws IOException {
        return this.directory.getOrCreateFile(name).lastModifiedTime();
    }

    @Override
    @Deprecated
    public void touchFile(String name) throws IOException {
        long ts2;
        if (!this.fileExists(name)) {
            throw new FileNotFoundException(name);
        }
        long ts1 = System.currentTimeMillis();
        do {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException ie) {
                throw new ThreadInterruptedException(ie);
            }
        } while (ts1 == (ts2 = System.currentTimeMillis()));
        this.directory.getOrCreateFile(name).setLastModifiedTime(ts2);
    }

    @Override
    public void deleteFile(String name) throws IOException {
        if (!this.fileExists(name)) {
            throw new FileNotFoundException(name);
        }
        this.directory.deleteFile(name);
    }

    @Override
    public long fileLength(String name) throws IOException {
        return this.directory.getOrCreateFile(name).length();
    }

    @Override
    public IndexOutput createOutput(String name) throws IOException {
        return new OffHeapIndexOutputStream(this.directory.getOrCreateFile(name));
    }

    @Override
    public IndexInput openInput(String name) throws IOException {
        return new OffHeapIndexInputStream(this.directory.getOrCreateFile(name));
    }

    @Override
    public synchronized void close() throws IOException {
        this.directory.deleteAllFiles();
        this.isOpen = false;
    }
}

