/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import com.terracottatech.search.AbstractNVPair;
import com.terracottatech.search.Configuration;
import com.terracottatech.search.GroupedIndexQueryResultImpl;
import com.terracottatech.search.IndexException;
import com.terracottatech.search.IndexFile;
import com.terracottatech.search.IndexFileImpl;
import com.terracottatech.search.Logger;
import com.terracottatech.search.LoggerFactory;
import com.terracottatech.search.LowerCaseKeywordAnalyzer;
import com.terracottatech.search.LuceneIndexManager;
import com.terracottatech.search.LuceneQueryBuilder;
import com.terracottatech.search.MultipleSnapshotDeletionPolicy;
import com.terracottatech.search.NVPair;
import com.terracottatech.search.NonGroupedIndexQueryResultImpl;
import com.terracottatech.search.ProcessingContext;
import com.terracottatech.search.SearchResult;
import com.terracottatech.search.SortOperations;
import com.terracottatech.search.TotalHitCountCollector;
import com.terracottatech.search.Util;
import com.terracottatech.search.ValueID;
import com.terracottatech.search.ValueType;
import com.terracottatech.search.aggregator.Aggregator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.terracotta.shaded.lucene.analysis.Analyzer;
import org.terracotta.shaded.lucene.document.Document;
import org.terracotta.shaded.lucene.document.Field;
import org.terracotta.shaded.lucene.document.FieldSelector;
import org.terracotta.shaded.lucene.document.Fieldable;
import org.terracotta.shaded.lucene.document.NumericField;
import org.terracotta.shaded.lucene.document.SetBasedFieldSelector;
import org.terracotta.shaded.lucene.index.CorruptIndexException;
import org.terracotta.shaded.lucene.index.IndexCommit;
import org.terracotta.shaded.lucene.index.IndexReader;
import org.terracotta.shaded.lucene.index.IndexWriter;
import org.terracotta.shaded.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.terracotta.shaded.lucene.index.Term;
import org.terracotta.shaded.lucene.search.BooleanClause;
import org.terracotta.shaded.lucene.search.BooleanQuery;
import org.terracotta.shaded.lucene.search.Collector;
import org.terracotta.shaded.lucene.search.IndexSearcher;
import org.terracotta.shaded.lucene.search.NumericRangeQuery;
import org.terracotta.shaded.lucene.search.Query;
import org.terracotta.shaded.lucene.search.ScoreDoc;
import org.terracotta.shaded.lucene.search.Scorer;
import org.terracotta.shaded.lucene.search.Sort;
import org.terracotta.shaded.lucene.search.SortField;
import org.terracotta.shaded.lucene.search.TermQuery;
import org.terracotta.shaded.lucene.search.TopDocs;
import org.terracotta.shaded.lucene.search.TopFieldDocs;
import org.terracotta.shaded.lucene.store.Directory;
import org.terracotta.shaded.lucene.store.IndexInput;
import org.terracotta.shaded.lucene.util.NumericUtils;

public class LuceneIndex {
    private static final ExecutorService s_commitThreadPool = Executors.newFixedThreadPool(1);
    static final String TERRACOTTA_INIT_FILE = "__terracotta_init.txt";
    public static final String KEY_BYTES_FIELD_NAME = "__TC_KEY_BYTES";
    public static final String SEGMENT_ID_FIELD_NAME = "__TC_SEGMENT_ID";
    static final String KEY_FIELD_NAME = "__TC_KEY_FIELD";
    static final String VALUE_FIELD_NAME = "__TC_VALUE_FIELD";
    private static final FieldSelector VALUE_ONLY_SELECTOR = LuceneIndex.valueOnlySelector();
    private final Analyzer analyzer = new LowerCaseKeywordAnalyzer();
    private final Directory luceneDirectory;
    private final MultipleSnapshotDeletionPolicy snapshotter;
    private final IndexWriter writer;
    private final File path;
    private final String name;
    private final AtomicReference<Future<?>> committer = new AtomicReference();
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private final Logger logger;
    private final boolean useCommitThread;
    private List<ProcessingContext> pending = this.newPendingList();
    private final LuceneIndexManager.IndexGroup idxGroup;
    private final AtomicReference<Thread> accessor = new AtomicReference();
    private final boolean doAccessCheck;

    LuceneIndex(Directory directory, String name, File path, boolean useCommitThread, LuceneIndexManager.IndexGroup parent, Configuration cfg, LoggerFactory loggerFactory) throws IndexException {
        this.doAccessCheck = cfg.doAccessChecks();
        this.logger = loggerFactory.getLogger(this.getClass().getName() + "-" + path.getName());
        this.snapshotter = new MultipleSnapshotDeletionPolicy(new KeepOnlyLastCommitDeletionPolicy());
        this.path = path;
        this.name = name;
        this.luceneDirectory = directory;
        this.useCommitThread = useCommitThread;
        this.idxGroup = parent;
        try {
            Util.ensureDirectory(path);
            double ramBufferSize = cfg.getMaxRamBufferSize();
            int mergeFactor = cfg.getMergeFactor();
            int maxBufferedDocs = cfg.getMaxBufferedDocs();
            int maxMergeDocs = cfg.getMaxMergeDocs();
            this.writer = new IndexWriter(this.luceneDirectory, this.analyzer, this.snapshotter, IndexWriter.MaxFieldLength.UNLIMITED);
            this.writer.setRAMBufferSizeMB(ramBufferSize);
            this.writer.setMaxMergeDocs(maxMergeDocs);
            this.writer.setMaxBufferedDocs(maxBufferedDocs);
            this.writer.setMergeFactor(mergeFactor);
            this.logger.info("Directory type: " + this.luceneDirectory.getClass().getName() + " with max buffer size " + ramBufferSize + " and merge factor " + mergeFactor + " ram buffer " + this.writer.getRAMBufferSizeMB() + " maxBufferedDocs: " + this.writer.getMaxBufferedDocs() + " maxMergeDocs: " + maxMergeDocs);
        }
        catch (IOException e) {
            throw new IndexException(e);
        }
        try {
            this.createInitFile();
        }
        catch (IOException ioe) {
            try {
                this.writer.close();
            }
            catch (IOException ioe2) {
                this.logger.error(ioe2);
            }
            throw new IndexException(ioe);
        }
    }

    private static FieldSelector valueOnlySelector() {
        return new SetBasedFieldSelector(Collections.singleton(VALUE_FIELD_NAME), Collections.EMPTY_SET);
    }

    String getName() {
        return this.name;
    }

    InputStream getIndexFile(String fileName) throws IOException {
        File file = new File(this.path, fileName);
        if (file.isFile()) {
            return new BufferedInputStream(new FileInputStream(file));
        }
        return new IndexInputAdapter(this.luceneDirectory.openInput(fileName));
    }

    void optimize() throws CorruptIndexException, IOException {
        this.writer.optimize();
    }

    protected void createInitFile() throws IOException {
        new File(this.path, TERRACOTTA_INIT_FILE).createNewFile();
    }

    static boolean hasInitFile(File path) {
        return new File(path, TERRACOTTA_INIT_FILE).isFile();
    }

    private List<ProcessingContext> newPendingList() {
        return new ArrayList<ProcessingContext>(256);
    }

    synchronized List<IndexFile> getSnapshot(String syncId) throws IndexException {
        try {
            this.writer.commit();
        }
        catch (IOException ioe) {
            this.logger.error(ioe);
            throw new IndexException(ioe);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Taking snapshot for index: " + this.name);
        }
        try {
            ArrayList<IndexFile> files = new ArrayList<IndexFile>();
            files.add(new IndexFileImpl(TERRACOTTA_INIT_FILE, TERRACOTTA_INIT_FILE, this.path.getName(), true, new File(this.path, TERRACOTTA_INIT_FILE).length()));
            IndexCommit ic = this.snapshotter.snapshot(syncId);
            Collection<String> fileNames = ic.getFileNames();
            for (String fileName : fileNames) {
                if (fileName.endsWith(".lock")) continue;
                files.add(new IndexFileImpl(fileName, fileName, this.path.getName(), false, this.luceneDirectory.fileLength(fileName)));
            }
            return files;
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    synchronized void release(String syncId) {
        if (!this.snapshotter.isSnapshotted(syncId)) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.info("Releasing snapshot for index");
        }
        this.snapshotter.release(syncId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingContext(ProcessingContext context) {
        if (this.useCommitThread) {
            LuceneIndex luceneIndex = this;
            synchronized (luceneIndex) {
                this.pending.add(context);
            }
            this.committer.compareAndSet(null, s_commitThreadPool.submit(new CommitTask()));
        } else {
            context.processed();
        }
    }

    SearchResult search(List queryStack, boolean includeKeys, boolean includeValues, Set<String> attributeSet, Set<String> groupByAttributes, List<NVPair> sortAttributes, int maxResults, boolean incCount) throws IndexException {
        IndexReader indexReader = null;
        try {
            Collector collector;
            Object docIds;
            boolean isGroupBy;
            Query luceneQuery = new LuceneQueryBuilder(queryStack, this.idxGroup.getSchema()).buildQuery();
            indexReader = this.getNewReader();
            IndexSearcher searcher = new IndexSearcher(indexReader);
            boolean bl = isGroupBy = !groupByAttributes.isEmpty();
            if (isGroupBy) {
                maxResults = -1;
            }
            if (maxResults >= 0 && sortAttributes.size() > 0) {
                if (maxResults == 0) {
                    docIds = new EmptyDocIdList();
                } else {
                    int nDocs;
                    collector = new TotalHitCountCollector();
                    searcher.search(luceneQuery, collector);
                    int n = nDocs = maxResults > 0 ? Math.min(maxResults, ((TotalHitCountCollector)collector).getTotalHits()) : ((TotalHitCountCollector)collector).getTotalHits();
                    if (nDocs > 0) {
                        Sort sort = this.getSort(sortAttributes);
                        TopFieldDocs topDocs = searcher.search(luceneQuery, null, nDocs, sort);
                        docIds = new TopDocsIds(topDocs);
                    } else {
                        docIds = new EmptyDocIdList();
                    }
                }
            } else {
                collector = new SimpleCollector(maxResults);
                searcher.search(luceneQuery, collector);
                docIds = collector;
            }
            ArrayList<GroupedIndexQueryResultImpl> results = new ArrayList<GroupedIndexQueryResultImpl>();
            int n = docIds.size();
            for (int i = 0; i < n; ++i) {
                Object attrValue;
                ValueType type;
                Document doc = indexReader.document(docIds.get(i));
                String key = includeKeys ? doc.get(KEY_FIELD_NAME) : null;
                ValueID value = includeValues ? new ValueID(Long.parseLong(doc.get(VALUE_FIELD_NAME))) : ValueID.NULL_ID;
                List attributes = attributeSet.isEmpty() ? Collections.EMPTY_LIST : new ArrayList(attributeSet.size());
                Set groupByAttrs = isGroupBy ? new HashSet(groupByAttributes.size()) : Collections.EMPTY_SET;
                List sortAttributesList = sortAttributes.isEmpty() ? Collections.EMPTY_LIST : new ArrayList(sortAttributes.size());
                for (String attrKey : attributeSet) {
                    type = this.getTypeForAttribute(attrKey);
                    attrValue = this.getFieldValue(doc, attrKey, type);
                    attributes.add(AbstractNVPair.createNVPair(attrKey, attrValue, type));
                }
                for (String attrKey : groupByAttributes) {
                    type = this.getTypeForAttribute(attrKey);
                    attrValue = this.getFieldValue(doc, attrKey, type);
                    groupByAttrs.add(AbstractNVPair.createNVPair(attrKey, attrValue, type));
                }
                if (!includeKeys && !includeValues && !incCount && attributes.isEmpty()) continue;
                for (NVPair pair : sortAttributes) {
                    String sortAttrKey = pair.getName();
                    ValueType type2 = this.getTypeForAttribute(sortAttrKey);
                    Object attrValue2 = this.getFieldValue(doc, sortAttrKey, type2);
                    NVPair attributePair = AbstractNVPair.createNVPair(sortAttrKey, attrValue2, type2);
                    sortAttributesList.add(attributePair);
                }
                results.add((GroupedIndexQueryResultImpl)(isGroupBy ? new GroupedIndexQueryResultImpl(attributes, sortAttributesList, groupByAttrs, new ArrayList<Aggregator>()) : new NonGroupedIndexQueryResultImpl(key, value, attributes, sortAttributesList)));
            }
            SearchResult searchResult = new SearchResult(results, Collections.EMPTY_LIST, docIds.size() > 0);
            return searchResult;
        }
        catch (Exception e) {
            if (e instanceof IndexException) {
                throw (IndexException)e;
            }
            throw new IndexException(e);
        }
        finally {
            if (indexReader != null) {
                try {
                    indexReader.close();
                }
                catch (IOException e) {
                    this.logger.error(e);
                }
            }
        }
    }

    private ValueType getTypeForAttribute(String attrName) {
        LuceneIndexManager.AttributeProperties attrProps = this.idxGroup.getSchema().get(attrName);
        return attrProps == null ? null : attrProps.getType();
    }

    private Object getFieldValue(Document doc, String attrKey, ValueType type) {
        if (type == ValueType.BYTE_ARRAY) {
            return doc.getBinaryValue(attrKey);
        }
        String attrValue = doc.get(attrKey);
        if (attrValue == null) {
            return null;
        }
        switch (type) {
            case BOOLEAN: {
                int value = Integer.valueOf(attrValue);
                if (value == 0) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            case BYTE: {
                return Byte.valueOf(attrValue);
            }
            case BYTE_ARRAY: {
                throw new AssertionError((Object)type);
            }
            case CHAR: {
                return new Character((char)Integer.valueOf(attrValue).intValue());
            }
            case DATE: {
                return new Date(Long.valueOf(attrValue));
            }
            case SQL_DATE: {
                return new java.sql.Date(Long.valueOf(attrValue));
            }
            case DOUBLE: {
                return Double.valueOf(attrValue);
            }
            case ENUM: {
                return attrValue;
            }
            case FLOAT: {
                return Float.valueOf(attrValue);
            }
            case INT: {
                return Integer.valueOf(attrValue);
            }
            case LONG: {
                return Long.valueOf(attrValue);
            }
            case SHORT: {
                return Short.valueOf(attrValue);
            }
            case STRING: {
                return attrValue;
            }
            case NULL: {
                throw new AssertionError();
            }
            case VALUE_ID: {
                return new ValueID(Long.valueOf(attrValue));
            }
        }
        throw new AssertionError((Object)type);
    }

    void remove(String key, ProcessingContext context) throws IndexException {
        this.checkAccessor();
        try {
            this.writer.deleteDocuments(new Term(KEY_FIELD_NAME, key));
        }
        catch (Exception e) {
            context.processed();
            throw new IndexException(e);
        }
        this.addPendingContext(context);
    }

    void removeIfValueEqual(Map<String, ValueID> toRemove, ProcessingContext context) throws IndexException {
        IndexReader reader = null;
        try {
            reader = this.getNewReader();
            IndexSearcher searcher = new IndexSearcher(reader);
            for (Map.Entry<String, ValueID> e : toRemove.entrySet()) {
                String stringKey = e.getKey();
                ValueID oidValue = e.getValue();
                this.removeIfValueEqual(stringKey, oidValue, reader, searcher);
            }
            this.addPendingContext(context);
        }
        catch (Exception e) {
            context.processed();
            throw new IndexException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    this.logger.error(ioe);
                }
            }
        }
    }

    private void removeIfValueEqual(String key, ValueID value, IndexReader reader, IndexSearcher searcher) throws IOException {
        this.checkAccessor();
        BooleanQuery query = new BooleanQuery();
        query.add(new BooleanClause(new TermQuery(new Term(KEY_FIELD_NAME, key)), BooleanClause.Occur.MUST));
        query.add(new BooleanClause(new TermQuery(new Term(VALUE_FIELD_NAME, NumericUtils.longToPrefixCoded(value.toLong()))), BooleanClause.Occur.MUST));
        this.writer.deleteDocuments((Query)query);
    }

    void clear(long segmentOid, ProcessingContext context) throws IndexException {
        try {
            this.writer.deleteDocuments((Query)NumericRangeQuery.newLongRange(SEGMENT_ID_FIELD_NAME, segmentOid, segmentOid, true, true));
        }
        catch (Exception e) {
            context.processed();
            throw new IndexException(e);
        }
        this.addPendingContext(context);
    }

    void replaceIfPresent(String key, ValueID value, Object oldValue, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentOid, ProcessingContext context) throws IndexException {
        try {
            ValueID existingValue = this.valueForKey(key);
            if (existingValue == null || !existingValue.equals(oldValue)) {
                context.processed();
                return;
            }
            this.upsertInternal(key, value, attributes, storeOnlyAttributes, segmentOid, false);
            this.addPendingContext(context);
        }
        catch (IndexException ie) {
            context.processed();
            throw ie;
        }
    }

    public void update(String key, ValueID value, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentOid, ProcessingContext context) throws IndexException {
        try {
            this.upsertInternal(key, value, attributes, storeOnlyAttributes, segmentOid, false);
            this.addPendingContext(context);
        }
        catch (IndexException ie) {
            context.processed();
            throw ie;
        }
    }

    public void insert(String key, ValueID value, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentOid, ProcessingContext context) throws IndexException {
        try {
            this.upsertInternal(key, value, attributes, storeOnlyAttributes, segmentOid, true);
            this.addPendingContext(context);
        }
        catch (IndexException ie) {
            context.processed();
            throw ie;
        }
    }

    public void updateKey(String existingKey, String newKey, int segmentId, ProcessingContext context) throws IndexException {
        try {
            this.updateKeyInternal(existingKey, newKey);
            this.addPendingContext(context);
        }
        catch (IndexException ie) {
            context.processed();
            throw ie;
        }
    }

    private void updateKeyInternal(String existingKey, String newKey) throws IndexException {
        IndexReader indexReader = null;
        try {
            indexReader = this.getNewReader();
            IndexSearcher searcher = new IndexSearcher(indexReader);
            TermQuery query = new TermQuery(new Term(KEY_FIELD_NAME, existingKey));
            TopDocs docs = searcher.search((Query)query, 2);
            if (docs.scoreDocs.length > 1) {
                throw new AssertionError((Object)("more than one result for key: " + existingKey));
            }
            if (docs.scoreDocs.length == 0) {
                throw new IndexException("No such document for key: " + existingKey);
            }
            int docId = docs.scoreDocs[0].doc;
            Document oldDoc = indexReader.document(docId);
            Document newDoc = new Document();
            LuceneIndex.addKeyField(newDoc, newKey);
            for (Fieldable f : oldDoc.getFields()) {
                String fieldName = f.name();
                if (fieldName.equals(KEY_FIELD_NAME)) continue;
                LuceneIndexManager.AttributeProperties attrProps = this.idxGroup.getSchema().get(fieldName);
                if (attrProps == null) {
                    throw new AssertionError((Object)("missing data for field " + fieldName));
                }
                ValueType fieldType = attrProps.getType();
                boolean indexed = attrProps.isIndexed();
                Object value = this.getFieldValue(oldDoc, fieldName, fieldType);
                this.addField(newDoc, fieldName, value, fieldType, indexed);
            }
            this.writer.updateDocument(new Term(KEY_FIELD_NAME, existingKey), newDoc);
        }
        catch (IOException e) {
            throw new IndexException(e);
        }
        finally {
            if (indexReader != null) {
                try {
                    indexReader.close();
                }
                catch (IOException e) {
                    this.logger.error(e);
                }
            }
        }
    }

    private void addField(Document doc, String fieldName, Object value, ValueType fieldType, boolean indexed) throws IndexException {
        switch (fieldType) {
            case BOOLEAN: {
                LuceneIndex.addBooleanField(doc, fieldName, (Boolean)value, indexed);
                return;
            }
            case BYTE: {
                LuceneIndex.addByteField(doc, fieldName, (Byte)value, indexed);
                return;
            }
            case BYTE_ARRAY: {
                LuceneIndex.addByteArrayField(doc, fieldName, (byte[])value, indexed);
                return;
            }
            case CHAR: {
                LuceneIndex.addCharField(doc, fieldName, ((Character)value).charValue(), indexed);
                return;
            }
            case DATE: {
                LuceneIndex.addDateField(doc, fieldName, (Date)value, indexed);
                return;
            }
            case SQL_DATE: {
                LuceneIndex.addSqlDateField(doc, fieldName, (java.sql.Date)value, indexed);
                return;
            }
            case DOUBLE: {
                LuceneIndex.addDoubleField(doc, fieldName, (Double)value, indexed);
                return;
            }
            case ENUM: {
                LuceneIndex.addEnumField(doc, fieldName, (String)value, indexed);
                return;
            }
            case FLOAT: {
                LuceneIndex.addFloatField(doc, fieldName, ((Float)value).floatValue(), indexed);
                return;
            }
            case INT: {
                LuceneIndex.addIntField(doc, fieldName, (Integer)value, indexed);
                return;
            }
            case LONG: {
                LuceneIndex.addLongField(doc, fieldName, (Long)value, indexed);
                return;
            }
            case NULL: {
                throw new AssertionError();
            }
            case SHORT: {
                LuceneIndex.addShortField(doc, fieldName, (Short)value, indexed);
                return;
            }
            case STRING: {
                LuceneIndex.addStringField(doc, fieldName, (String)value, indexed);
                return;
            }
            case VALUE_ID: {
                LuceneIndex.addValueIdField(doc, fieldName, (ValueID)value, indexed);
                return;
            }
        }
        throw new AssertionError((Object)fieldType);
    }

    private void upsertInternal(String key, ValueID value, List<NVPair> attributes, List<NVPair> storeOnlyAttributes, long segmentOid, boolean isInsert) throws IndexException {
        this.checkAccessor();
        this.idxGroup.checkSchema(attributes, true);
        this.idxGroup.checkSchema(storeOnlyAttributes, false);
        Document doc = new Document();
        LuceneIndex.addKeyField(doc, key);
        doc.add(LuceneIndex.createNumericField(VALUE_FIELD_NAME, true).setLongValue(value.toLong()));
        doc.add(LuceneIndex.createNumericField(SEGMENT_ID_FIELD_NAME, true).setLongValue(segmentOid));
        this.addFields(doc, attributes, true);
        this.addFields(doc, storeOnlyAttributes, false);
        try {
            if (isInsert) {
                this.writer.addDocument(doc);
            } else {
                this.writer.updateDocument(new Term(KEY_FIELD_NAME, key), doc);
            }
        }
        catch (Exception e) {
            throw new IndexException(e);
        }
    }

    private void checkAccessor() {
        Thread orig;
        Thread current;
        if (this.doAccessCheck && !this.accessor.compareAndSet(null, current = Thread.currentThread()) && (orig = this.accessor.get()) != current) {
            throw new AssertionError((Object)("Index is being accessed by a different thread. Original=[" + orig.getName() + "]"));
        }
    }

    private static void addKeyField(Document doc, String key) {
        doc.add(new Field(KEY_FIELD_NAME, key, Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS));
    }

    private void addFields(Document doc, List<NVPair> attributes, boolean indexed) throws IndexException {
        block17: for (NVPair nvpair : attributes) {
            String attrName = nvpair.getName();
            ValueType type = nvpair.getType();
            switch (type) {
                case BOOLEAN: {
                    AbstractNVPair.BooleanNVPair booleanPair = (AbstractNVPair.BooleanNVPair)nvpair;
                    LuceneIndex.addBooleanField(doc, attrName, booleanPair.getValue(), indexed);
                    continue block17;
                }
                case BYTE: {
                    AbstractNVPair.ByteNVPair bytePair = (AbstractNVPair.ByteNVPair)nvpair;
                    LuceneIndex.addByteField(doc, attrName, bytePair.getValue(), indexed);
                    continue block17;
                }
                case BYTE_ARRAY: {
                    AbstractNVPair.ByteArrayNVPair byteArrayPair = (AbstractNVPair.ByteArrayNVPair)nvpair;
                    LuceneIndex.addByteArrayField(doc, attrName, byteArrayPair.getValue(), indexed);
                    continue block17;
                }
                case CHAR: {
                    AbstractNVPair.CharNVPair charPair = (AbstractNVPair.CharNVPair)nvpair;
                    LuceneIndex.addCharField(doc, attrName, charPair.getValue(), indexed);
                    continue block17;
                }
                case DATE: {
                    AbstractNVPair.DateNVPair datePair = (AbstractNVPair.DateNVPair)nvpair;
                    LuceneIndex.addDateField(doc, attrName, datePair.getValue(), indexed);
                    continue block17;
                }
                case SQL_DATE: {
                    AbstractNVPair.SqlDateNVPair sqlDatePair = (AbstractNVPair.SqlDateNVPair)nvpair;
                    LuceneIndex.addSqlDateField(doc, attrName, sqlDatePair.getValue(), indexed);
                    continue block17;
                }
                case DOUBLE: {
                    AbstractNVPair.DoubleNVPair doubleNVPair = (AbstractNVPair.DoubleNVPair)nvpair;
                    LuceneIndex.addDoubleField(doc, attrName, doubleNVPair.getValue(), indexed);
                    continue block17;
                }
                case ENUM: {
                    AbstractNVPair.EnumNVPair enumPair = (AbstractNVPair.EnumNVPair)nvpair;
                    LuceneIndex.addEnumField(doc, attrName, AbstractNVPair.enumStorageString(enumPair), indexed);
                    continue block17;
                }
                case FLOAT: {
                    AbstractNVPair.FloatNVPair floatNVPair = (AbstractNVPair.FloatNVPair)nvpair;
                    LuceneIndex.addFloatField(doc, attrName, floatNVPair.getValue(), indexed);
                    continue block17;
                }
                case INT: {
                    AbstractNVPair.IntNVPair intNVPair = (AbstractNVPair.IntNVPair)nvpair;
                    LuceneIndex.addIntField(doc, attrName, intNVPair.getValue(), indexed);
                    continue block17;
                }
                case LONG: {
                    AbstractNVPair.LongNVPair longNVPair = (AbstractNVPair.LongNVPair)nvpair;
                    LuceneIndex.addLongField(doc, attrName, longNVPair.getValue(), indexed);
                    continue block17;
                }
                case SHORT: {
                    AbstractNVPair.ShortNVPair shortNVPair = (AbstractNVPair.ShortNVPair)nvpair;
                    LuceneIndex.addShortField(doc, attrName, shortNVPair.getValue(), indexed);
                    continue block17;
                }
                case STRING: {
                    AbstractNVPair.StringNVPair stringNVPair = (AbstractNVPair.StringNVPair)nvpair;
                    LuceneIndex.addStringField(doc, attrName, stringNVPair.getValue(), indexed);
                    continue block17;
                }
                case NULL: {
                    throw new AssertionError();
                }
                case VALUE_ID: {
                    AbstractNVPair.ValueIdNVPair oidNVPair = (AbstractNVPair.ValueIdNVPair)nvpair;
                    LuceneIndex.addValueIdField(doc, attrName, oidNVPair.getValue(), indexed);
                    continue block17;
                }
            }
            throw new AssertionError((Object)type.name());
        }
    }

    private static void addValueIdField(Document doc, String fieldName, ValueID value, boolean indexed) {
        doc.add(LuceneIndex.createNumericField(fieldName, indexed).setLongValue(value.toLong()));
    }

    private static void addStringField(Document doc, String fieldName, String value, boolean indexed) {
        doc.add(LuceneIndex.createField(fieldName, value, indexed ? Field.Index.ANALYZED_NO_NORMS : Field.Index.NO));
    }

    private static void addShortField(Document doc, String fieldName, short value, boolean indexed) {
        doc.add(LuceneIndex.createNumericField(fieldName, indexed).setIntValue(value));
    }

    private static void addLongField(Document doc, String fieldName, long value, boolean indexed) {
        doc.add(LuceneIndex.createNumericField(fieldName, indexed).setLongValue(value));
    }

    private static void addIntField(Document doc, String attrName, int value, boolean indexed) {
        doc.add(LuceneIndex.createNumericField(attrName, indexed).setIntValue(value));
    }

    private static void addFloatField(Document doc, String attrName, float value, boolean indexed) {
        doc.add(LuceneIndex.createNumericField(attrName, indexed).setFloatValue(value));
    }

    private static void addEnumField(Document doc, String attrName, String enumStorageString, boolean indexed) {
        doc.add(LuceneIndex.createField(attrName, enumStorageString, indexed ? Field.Index.NOT_ANALYZED_NO_NORMS : Field.Index.NO));
    }

    private static void addDoubleField(Document doc, String attrName, double value, boolean indexed) {
        doc.add(LuceneIndex.createNumericField(attrName, indexed).setDoubleValue(value));
    }

    private static void addSqlDateField(Document doc, String attrName, java.sql.Date value, boolean indexed) {
        doc.add(LuceneIndex.createNumericField(attrName, indexed).setLongValue(value.getTime()));
    }

    private static void addDateField(Document doc, String attrName, Date value, boolean indexed) {
        doc.add(LuceneIndex.createNumericField(attrName, indexed).setLongValue(value.getTime()));
    }

    private static void addCharField(Document doc, String attrName, char value, boolean indexed) {
        doc.add(LuceneIndex.createNumericField(attrName, indexed).setIntValue(value));
    }

    private static void addByteArrayField(Document doc, String attrName, byte[] value, boolean indexed) throws IndexException {
        if (indexed) {
            throw new IndexException("byte array attributes can only be stored (not indexed)");
        }
        doc.add(new Field(attrName, value, Field.Store.YES));
    }

    private static void addByteField(Document doc, String attrName, byte value, boolean indexed) {
        doc.add(LuceneIndex.createNumericField(attrName, indexed).setIntValue(value));
    }

    private static void addBooleanField(Document doc, String attrName, boolean value, boolean indexed) {
        if (value) {
            doc.add(LuceneIndex.createNumericField(attrName, indexed).setIntValue(1));
        } else {
            doc.add(LuceneIndex.createNumericField(attrName, indexed).setIntValue(0));
        }
    }

    private ValueID valueForKey(String key) throws IndexException {
        IndexReader indexReader = null;
        try {
            indexReader = this.getNewReader();
            IndexSearcher searcher = new IndexSearcher(indexReader);
            TermQuery query = new TermQuery(new Term(KEY_FIELD_NAME, key));
            TopDocs docs = searcher.search((Query)query, 2);
            if (docs.scoreDocs.length > 1) {
                throw new AssertionError((Object)("more than one result for key: " + key));
            }
            if (docs.scoreDocs.length == 0) {
                ValueID valueID = null;
                return valueID;
            }
            int docId = docs.scoreDocs[0].doc;
            Document doc = indexReader.document(docId, VALUE_ONLY_SELECTOR);
            long oid = (Long)this.getFieldValue(doc, VALUE_FIELD_NAME, ValueType.LONG);
            ValueID valueID = new ValueID(oid);
            return valueID;
        }
        catch (IOException e) {
            throw new IndexException(e);
        }
        finally {
            if (indexReader != null) {
                try {
                    indexReader.close();
                }
                catch (IOException e) {
                    this.logger.error(e);
                }
            }
        }
    }

    private IndexReader getNewReader() throws CorruptIndexException, IOException {
        return this.writer.getReader();
    }

    private Sort getSort(List<NVPair> sortAttributes) throws IndexException {
        ArrayList<SortField> sortFields = new ArrayList<SortField>(sortAttributes.size() * 2);
        for (NVPair sortAttributePair : sortAttributes) {
            String attributeName = sortAttributePair.getName();
            Boolean descending = SortOperations.DESCENDING.equals(sortAttributePair.getObjectValue());
            Integer sortFieldType = this.getSortFieldType(attributeName);
            if (sortFieldType == null) continue;
            sortFields.add(new SortField(attributeName, sortFieldType, (boolean)descending));
        }
        Sort sort = new Sort(sortFields.toArray(new SortField[sortFields.size()]));
        return sort;
    }

    private static Field createField(String attrName, String value, Field.Index index) {
        return new Field(attrName, value, Field.Store.YES, index);
    }

    private static NumericField createNumericField(String attrName, boolean indexed) {
        return new NumericField(attrName, Field.Store.YES, indexed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        if (this.shutdown.compareAndSet(false, true)) {
            LuceneIndex luceneIndex = this;
            synchronized (luceneIndex) {
                this.notify();
            }
            if (this.useCommitThread) {
                try {
                    Future<?> commitResult = this.committer.get();
                    if (commitResult != null) {
                        commitResult.get();
                    }
                }
                catch (InterruptedException e1) {
                }
                catch (ExecutionException ex) {
                    this.logger.warn(ex);
                }
            }
            try {
                this.writer.close();
            }
            catch (Exception e) {
                this.logger.error(e);
            }
            try {
                this.luceneDirectory.close();
            }
            catch (IOException e) {
                this.logger.error(e);
            }
        }
    }

    private Integer getSortFieldType(String attributeName) throws IndexException {
        ValueType valueType = this.getTypeForAttribute(attributeName);
        if (valueType == null) {
            return null;
        }
        switch (valueType) {
            case BOOLEAN: {
                return 4;
            }
            case BYTE: {
                return 4;
            }
            case BYTE_ARRAY: {
                throw new IndexException("Unexpected sort type (" + valueType.name() + "] for attribute " + attributeName);
            }
            case CHAR: {
                return 4;
            }
            case DATE: {
                return 6;
            }
            case SQL_DATE: {
                return 6;
            }
            case DOUBLE: {
                return 7;
            }
            case ENUM: {
                return 3;
            }
            case FLOAT: {
                return 5;
            }
            case INT: {
                return 4;
            }
            case LONG: {
                return 6;
            }
            case SHORT: {
                return 4;
            }
            case STRING: {
                return 3;
            }
            case NULL: {
                throw new AssertionError();
            }
            case VALUE_ID: {
                return 6;
            }
        }
        throw new AssertionError((Object)("unexpected sort type: " + (Object)((Object)valueType)));
    }

    private static class IntList {
        private int size = 0;
        private int[] data;

        IntList() {
            this(16);
        }

        IntList(int cap) {
            this.data = new int[cap];
        }

        int size() {
            return this.size;
        }

        void add(int toAdd) {
            if (this.size == this.data.length) {
                int[] temp = new int[this.data.length * 2];
                System.arraycopy(this.data, 0, temp, 0, this.data.length);
                this.data = temp;
            }
            this.data[this.size++] = toAdd;
        }

        int get(int index) {
            return this.data[index];
        }
    }

    private static class IndexInputAdapter
    extends InputStream {
        private final IndexInput input;

        private IndexInputAdapter(IndexInput input) {
            this.input = input;
        }

        @Override
        public int read() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = Math.min(this.available(), len);
            this.input.readBytes(b, off, len, false);
            return read;
        }

        @Override
        public int available() {
            long available = this.input.length() - this.input.getFilePointer();
            if (available >= Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            return (int)available;
        }

        @Override
        public void close() throws IOException {
            this.input.close();
        }

        @Override
        public long skip(long n) {
            throw new UnsupportedOperationException();
        }
    }

    private static class SimpleCollector
    extends Collector
    implements DocIdList {
        private final int maxResults;
        private final IntList ids = new IntList();
        private final boolean unbounded;
        private int base = 0;

        private SimpleCollector(int maxResults) {
            this.maxResults = maxResults;
            this.unbounded = maxResults < 0;
        }

        @Override
        public void setScorer(Scorer scorer) {
        }

        @Override
        public void collect(int doc) {
            if (this.unbounded || this.ids.size() < this.maxResults) {
                this.ids.add(this.base + doc);
            }
        }

        @Override
        public void setNextReader(IndexReader reader, int docBase) {
            this.base = docBase;
        }

        @Override
        public boolean acceptsDocsOutOfOrder() {
            return true;
        }

        @Override
        public int size() {
            return this.ids.size();
        }

        @Override
        public int get(int index) {
            return this.ids.get(index);
        }
    }

    private static class TopDocsIds
    implements DocIdList {
        private final ScoreDoc[] scoreDocs;

        TopDocsIds(TopDocs topDocs) {
            this.scoreDocs = topDocs.scoreDocs;
        }

        @Override
        public int size() {
            return this.scoreDocs.length;
        }

        @Override
        public int get(int index) {
            return this.scoreDocs[index].doc;
        }
    }

    private static class EmptyDocIdList
    implements DocIdList {
        private EmptyDocIdList() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public int get(int index) {
            throw new NoSuchElementException("index: " + index);
        }
    }

    private static interface DocIdList {
        public int size();

        public int get(int var1);
    }

    private class CommitTask
    implements Runnable {
        private CommitTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                block10: while (true) {
                    List committed;
                    LuceneIndex luceneIndex = LuceneIndex.this;
                    synchronized (luceneIndex) {
                        block12: {
                            if (!LuceneIndex.this.pending.isEmpty() && !LuceneIndex.this.shutdown.get()) break block12;
                            return;
                        }
                        committed = LuceneIndex.this.pending;
                        LuceneIndex.this.pending = LuceneIndex.this.newPendingList();
                    }
                    try {
                        LuceneIndex.this.writer.commit();
                    }
                    catch (Exception e) {
                        LuceneIndex.this.logger.error(e);
                    }
                    Iterator i$ = committed.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block10;
                        ProcessingContext context = (ProcessingContext)i$.next();
                        context.processed();
                    }
                    break;
                }
            }
            finally {
                LuceneIndex.this.committer.set(null);
            }
        }
    }
}

