/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.search;

import java.io.IOException;
import java.io.Reader;
import org.terracotta.shaded.lucene.analysis.KeywordAnalyzer;
import org.terracotta.shaded.lucene.analysis.TokenFilter;
import org.terracotta.shaded.lucene.analysis.TokenStream;
import org.terracotta.shaded.lucene.analysis.tokenattributes.TermAttribute;

public final class LowerCaseKeywordAnalyzer
extends KeywordAnalyzer {
    @Override
    public LowerCaseFilter tokenStream(String fieldName, Reader reader) {
        return new LowerCaseFilter(super.tokenStream(fieldName, reader));
    }

    @Override
    public TokenStream reusableTokenStream(String fieldName, Reader reader) throws IOException {
        TokenStream stream = super.reusableTokenStream(fieldName, reader);
        if (!(stream instanceof LowerCaseFilter)) {
            stream = new LowerCaseFilter(stream);
        }
        return stream;
    }

    private static class LowerCaseFilter
    extends TokenFilter {
        private final TermAttribute termAtt = this.addAttribute(TermAttribute.class);

        public LowerCaseFilter(TokenStream in) {
            super(in);
        }

        @Override
        public final boolean incrementToken() throws IOException {
            if (this.input.incrementToken()) {
                int origLength;
                char[] buffer = this.termAtt.termBuffer();
                String lower = new String(buffer, 0, origLength = this.termAtt.termLength()).toLowerCase();
                int newLength = lower.length();
                if (newLength != origLength) {
                    this.termAtt.resizeTermBuffer(newLength);
                    this.termAtt.setTermLength(newLength);
                }
                for (int i = 0; i < newLength; ++i) {
                    buffer[i] = lower.charAt(i);
                }
                return true;
            }
            return false;
        }
    }
}

