/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage.restartable.portability;

import com.terracottatech.frs.RestartStore;
import com.terracottatech.frs.TransactionException;
import com.terracottatech.frs.object.ObjectManagerEntry;
import com.terracottatech.frs.object.ObjectManagerSegment;
import com.terracottatech.frs.object.ObjectManagerStripe;
import com.terracottatech.frs.object.SimpleObjectManagerEntry;
import com.terracottatech.frs.object.heap.HeapValueSortedMap;
import com.terracottatech.offheapstore.storage.portability.SerializablePortability;
import com.terracottatech.offheapstore.util.ByteBufferInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentMap;

public class RestartableSerializablePortability<I>
extends SerializablePortability
implements ObjectManagerStripe<I, ByteBuffer, ByteBuffer>,
ObjectManagerSegment<I, ByteBuffer, ByteBuffer> {
    private final I identifier;
    private final RestartStore<I, ByteBuffer, ByteBuffer> restartability;
    private final HeapValueSortedMap<Integer, Long> lsnMap = new HeapValueSortedMap();
    private final Collection<ObjectManagerSegment<I, ByteBuffer, ByteBuffer>> segments;
    private final boolean synchronous;
    private ObjectManagerEntry<I, ByteBuffer, ByteBuffer> compactingEntry;
    private long sizeInBytes = 0L;

    public RestartableSerializablePortability(I identifier, RestartStore<I, ByteBuffer, ByteBuffer> restartability, boolean synchronous) {
        this.identifier = identifier;
        this.restartability = restartability;
        this.segments = Collections.singleton(this);
        this.synchronous = synchronous;
    }

    @Override
    protected void addedMapping(Integer rep, ObjectStreamClass disconnected) {
        try {
            this.restartability.beginTransaction(this.synchronous).put(this.identifier, RestartableSerializablePortability.encodeInteger(rep), RestartableSerializablePortability.encodeObjectStreamClass(disconnected)).commit();
        }
        catch (TransactionException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getLowestLsn() {
        ConcurrentMap concurrentMap = this.lookup;
        synchronized (concurrentMap) {
            return this.lsnMap.firstValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getLsn(ByteBuffer key) {
        ConcurrentMap concurrentMap = this.lookup;
        synchronized (concurrentMap) {
            return this.lsnMap.get(RestartableSerializablePortability.decodeInteger(key));
        }
    }

    @Override
    public Long getLsn(int hash, ByteBuffer key) {
        return this.getLsn(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(ByteBuffer key, ByteBuffer value, long lsn) {
        int representation = RestartableSerializablePortability.decodeInteger(key);
        if (this.lookup.containsKey(representation)) {
            ConcurrentMap concurrentMap = this.lookup;
            synchronized (concurrentMap) {
                this.sizeInBytes += (long)(key.remaining() + value.remaining());
                this.lsnMap.put(representation, lsn);
            }
        } else {
            throw new AssertionError();
        }
    }

    @Override
    public void put(int hash, ByteBuffer key, ByteBuffer value, long lsn) {
        this.put(key, value, lsn);
    }

    @Override
    public void remove(ByteBuffer key) {
        throw new AssertionError();
    }

    @Override
    public void remove(int hash, ByteBuffer key) {
        this.remove(key);
    }

    @Override
    public void delete() {
        throw new AssertionError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void replayPut(ByteBuffer binaryKey, ByteBuffer binaryValue, long lsn) {
        try {
            int representation = RestartableSerializablePortability.decodeInteger(binaryKey);
            ObjectStreamClass osc = RestartableSerializablePortability.decodeObjectStreamClass(binaryValue);
            SerializablePortability.SerializableDataKey key = new SerializablePortability.SerializableDataKey(osc);
            ConcurrentMap concurrentMap = this.lookup;
            synchronized (concurrentMap) {
                this.sizeInBytes += (long)(binaryKey.remaining() + binaryValue.remaining());
                ObjectStreamClass oldOsc = this.lookup.putIfAbsent(representation, osc);
                Integer oldRep = this.lookup.putIfAbsent(key, representation);
                this.lsnMap.put(representation, lsn);
                if (oldRep != null && !oldRep.equals(representation)) {
                    throw new IOException("Existing colliding class mapping detected");
                }
                if (oldOsc != null && !oldOsc.getName().equals(osc.getName())) {
                    throw new IOException("Existing colliding class mapping detected");
                }
                this.nextStreamIndex = Math.max(this.nextStreamIndex, representation + 1);
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public void replayPut(int hash, ByteBuffer key, ByteBuffer value, long lsn) {
        this.replayPut(key, value, lsn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectManagerEntry<I, ByteBuffer, ByteBuffer> acquireCompactionEntry(long ceilingLsn) {
        ConcurrentMap concurrentMap = this.lookup;
        synchronized (concurrentMap) {
            Integer key = this.lsnMap.firstKey();
            if (key == null) {
                return null;
            }
            long lsn = this.lsnMap.get(key);
            if (lsn >= ceilingLsn) {
                return null;
            }
            ByteBuffer value = RestartableSerializablePortability.encodeObjectStreamClass((ObjectStreamClass)this.lookup.get(key));
            this.compactingEntry = new SimpleObjectManagerEntry<I, ByteBuffer, ByteBuffer>(this.identifier, RestartableSerializablePortability.encodeInteger(key), value, lsn);
            return this.compactingEntry;
        }
    }

    @Override
    public void updateLsn(int pojoHash, ObjectManagerEntry<I, ByteBuffer, ByteBuffer> entry, long newLsn) {
        this.updateLsn(entry, newLsn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateLsn(ObjectManagerEntry<I, ByteBuffer, ByteBuffer> entry, long newLsn) {
        ConcurrentMap concurrentMap = this.lookup;
        synchronized (concurrentMap) {
            if (entry != this.compactingEntry) {
                throw new IllegalArgumentException("Tried to update the LSN on an entry that was not first acquired.");
            }
            int i = RestartableSerializablePortability.decodeInteger(entry.getKey());
            Long previous = this.lsnMap.get(i);
            assert (previous != null && previous.longValue() == entry.getLsn());
            this.lsnMap.put(i, newLsn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseCompactionEntry(ObjectManagerEntry<I, ByteBuffer, ByteBuffer> entry) {
        ConcurrentMap concurrentMap = this.lookup;
        synchronized (concurrentMap) {
            if (entry == null) {
                throw new NullPointerException("Tried to release a null entry.");
            }
            if (entry != this.compactingEntry) {
                throw new AssertionError((Object)"Released entry was not previously acquired.");
            }
            this.compactingEntry = null;
        }
    }

    @Override
    public Collection<ObjectManagerSegment<I, ByteBuffer, ByteBuffer>> getSegments() {
        return this.segments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() {
        ConcurrentMap concurrentMap = this.lookup;
        synchronized (concurrentMap) {
            return this.lsnMap.size();
        }
    }

    private static ByteBuffer encodeInteger(int integer) {
        ByteBuffer buffer = ByteBuffer.allocate(4);
        buffer.putInt(integer);
        return (ByteBuffer)buffer.flip();
    }

    private static int decodeInteger(ByteBuffer data) {
        return data.getInt(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ByteBuffer encodeObjectStreamClass(ObjectStreamClass osc) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            try {
                oout.writeObject(osc);
            }
            finally {
                oout.close();
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return ByteBuffer.wrap(bout.toByteArray());
    }

    private static ObjectStreamClass decodeObjectStreamClass(ByteBuffer data) {
        ByteBufferInputStream bin = new ByteBufferInputStream(data.duplicate());
        try {
            ObjectInputStream oin = new ObjectInputStream(bin);
            return (ObjectStreamClass)oin.readObject();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public long sizeInBytes() {
        return this.sizeInBytes;
    }
}

