/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage.restartable;

import com.terracottatech.frs.RestartStore;
import com.terracottatech.offheapstore.pinning.PinnableStorageEngine;
import com.terracottatech.offheapstore.storage.StorageEngine;
import com.terracottatech.offheapstore.storage.restartable.LinkedNode;
import com.terracottatech.offheapstore.storage.restartable.RestartableDelegateStorageEngine;
import com.terracottatech.offheapstore.storage.restartable.RestartablePinnableDelegateStorageEngine;
import com.terracottatech.offheapstore.storage.restartable.RestartableStorageEngine;
import com.terracottatech.offheapstore.util.Factory;
import java.nio.ByteBuffer;

public class RestartablePinnableStorageEngine<U extends StorageEngine<K, LinkedNode<Boolean>> & RestartableDelegateStorageEngine, T extends PinnableStorageEngine<K, LinkedNode<V>> & RestartablePinnableDelegateStorageEngine<U, K>, I, K, V>
extends RestartableStorageEngine<T, I, K, V>
implements PinnableStorageEngine<K, V> {
    private final RestartableStorageEngine<?, ?, K, Boolean> restartablePinnedKeyEngine;

    public static <U extends StorageEngine<K, LinkedNode<Boolean>> & RestartableDelegateStorageEngine, T extends PinnableStorageEngine<K, LinkedNode<V>> & RestartablePinnableDelegateStorageEngine<U, K>, I, K, V> Factory<RestartablePinnableStorageEngine<U, T, I, K, V>> createFactory(final I identifier, final I pinnedIdentifier, final RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, final Factory<T> delegateFactory, final boolean synchronous) {
        return new Factory<RestartablePinnableStorageEngine<U, T, I, K, V>>(){

            @Override
            public RestartablePinnableStorageEngine<U, T, I, K, V> newInstance() {
                return new RestartablePinnableStorageEngine(identifier, pinnedIdentifier, transactionSource, (PinnableStorageEngine)delegateFactory.newInstance(), synchronous);
            }
        };
    }

    public RestartablePinnableStorageEngine(I identifier, I pinnedIdentifier, RestartStore<I, ByteBuffer, ByteBuffer> transactionSource, T storageEngine, boolean synchronous) {
        super(identifier, transactionSource, storageEngine, synchronous);
        ((RestartablePinnableDelegateStorageEngine)((Object)((PinnableStorageEngine)this.delegateStorageEngine))).getRestartablePinnedKeyEngine();
        Object pinnedEngine = ((RestartablePinnableDelegateStorageEngine)((Object)((PinnableStorageEngine)this.delegateStorageEngine))).getRestartablePinnedKeyEngine();
        this.restartablePinnedKeyEngine = new RestartableStorageEngine(pinnedIdentifier, transactionSource, pinnedEngine, synchronous);
    }

    @Override
    public Long copyMapping(int hash, long encoding, int metadata) {
        Long result = ((PinnableStorageEngine)this.delegateStorageEngine).copyMapping(hash, encoding, metadata);
        if (result != null) {
            if (result != encoding) {
                LinkedNode copy = (LinkedNode)((PinnableStorageEngine)this.delegateStorageEngine).readValue(result);
                copy.setNext(Long.MIN_VALUE);
                copy.setPrevious(Long.MIN_VALUE);
                copy.setLsn(-1L);
                copy.flush();
            }
            this.fireCopied(hash, encoding, result, metadata);
        }
        return result;
    }

    protected int deriveMetadata(long encoding, int metadata) {
        return ((RestartablePinnableDelegateStorageEngine)((Object)((PinnableStorageEngine)this.delegateStorageEngine))).deriveMetadata(encoding);
    }

    public RestartableStorageEngine<?, ?, K, Boolean> getPinnedKeyEngine() {
        return this.restartablePinnedKeyEngine;
    }
}

