/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage.restartable;

import com.terracottatech.offheapstore.disk.persistent.PersistentPortability;
import com.terracottatech.offheapstore.storage.portability.Portability;
import com.terracottatech.offheapstore.storage.restartable.AttachedLinkedNode;
import com.terracottatech.offheapstore.storage.restartable.LinkedNode;
import com.terracottatech.offheapstore.storage.restartable.WriteBackPortability;
import com.terracottatech.offheapstore.storage.restartable.WriteContext;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;

public class LinkedNodePortability<T>
implements WriteBackPortability<LinkedNode<T>>,
PersistentPortability<LinkedNode<T>> {
    public static final int LSN_OFFSET = 0;
    public static final int PREVIOUS_OFFSET = 8;
    public static final int NEXT_OFFSET = 16;
    public static final int VALUE_OFFSET = 24;
    private static final ByteBuffer EMPTY_HEADER;
    private final Portability<? super T> valuePortability;

    public LinkedNodePortability(Portability<? super T> valuePortability) {
        this.valuePortability = valuePortability;
    }

    @Override
    public ByteBuffer encode(LinkedNode<T> object) {
        ByteBuffer encodedValue = this.valuePortability.encode(object.getValue());
        ByteBuffer encodedNode = ByteBuffer.allocate(encodedValue.remaining() + 24);
        encodedNode.putLong(0, object.getLsn());
        encodedNode.putLong(8, object.getPrevious());
        encodedNode.putLong(16, object.getNext());
        encodedNode.position(24);
        encodedNode.put(encodedValue);
        encodedNode.flip();
        return encodedNode;
    }

    @Override
    public LinkedNode<T> decode(ByteBuffer buffer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object object, ByteBuffer buffer) {
        return this.valuePortability.equals(object, (ByteBuffer)buffer.position(buffer.position() + 24));
    }

    @Override
    public LinkedNode<T> decode(ByteBuffer buffer, WriteContext context) {
        return new AttachedLinkedNode<T>(buffer, this.valuePortability, context);
    }

    @Override
    public void flush() throws IOException {
        throw new AssertionError();
    }

    @Override
    public void close() throws IOException {
        throw new AssertionError();
    }

    @Override
    public void persist(ObjectOutput output) throws IOException {
        throw new AssertionError();
    }

    @Override
    public void bootstrap(ObjectInput input) throws IOException {
        throw new AssertionError();
    }

    public static ByteBuffer emptyHeader() {
        return EMPTY_HEADER.duplicate();
    }

    static {
        ByteBuffer emptyHeader = ByteBuffer.allocateDirect(24);
        emptyHeader.putLong(0, -1L);
        emptyHeader.putLong(8, Long.MIN_VALUE);
        emptyHeader.putLong(16, Long.MIN_VALUE);
        EMPTY_HEADER = emptyHeader;
    }
}

