/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage.allocator;

import com.terracottatech.offheapstore.paging.OffHeapStorageArea;

public class BestFitAllocator {
    private static final boolean DEBUG = Boolean.getBoolean(BestFitAllocator.class.getName() + ".DEBUG");
    private static final int MALLOC_ALIGNMENT = 8;
    private static final int SIZE_T_SIZE = 4;
    private static final int SIZE_T_BITSIZE = 32;
    private static final int CHUNK_ALIGN_MASK = 7;
    private static final int MCHUNK_SIZE = 16;
    private static final int CHUNK_OVERHEAD = 8;
    private static final int MIN_CHUNK_SIZE = 16;
    private static final int MAX_REQUEST = 2147483584;
    private static final int MIN_REQUEST = 7;
    private static final int TOP_FOOT_SIZE = BestFitAllocator.alignOffset(BestFitAllocator.chunkToMem(0)) + BestFitAllocator.padRequest(16);
    public static final int MINIMAL_SIZE = Integer.highestOneBit(TOP_FOOT_SIZE) << 1;
    public static final int TOP_FOOT_OFFSET = BestFitAllocator.memToChunk(0) + TOP_FOOT_SIZE;
    private static final int PINUSE_BIT = 1;
    private static final int CINUSE_BIT = 2;
    private static final int FLAG4_BIT = 4;
    private static final int INUSE_BITS = 3;
    private static final int FLAG_BITS = 7;
    private static final int NSMALLBINS = 32;
    private static final int NTREEBINS = 32;
    private static final int SMALLBIN_SHIFT = 3;
    private static final int TREEBIN_SHIFT = 8;
    private static final int MIN_LARGE_SIZE = 256;
    private static final int MAX_SMALL_SIZE = 255;
    private static final int MAX_SMALL_REQUEST = 240;
    private final OffHeapStorageArea storage;
    private int smallMap;
    private int treeMap;
    private final int[] smallBins = new int[32];
    private final int[] treeBins = new int[32];
    private int designatedVictimSize = 0;
    private int designatedVictim = -1;
    private int topSize = 0;
    private int top = 0;
    private int occupied;

    public BestFitAllocator(OffHeapStorageArea storage) {
        this.storage = storage;
        this.clear();
    }

    public void clear() {
        int i;
        this.top = 0;
        this.topSize = -TOP_FOOT_SIZE;
        this.designatedVictim = -1;
        this.designatedVictimSize = 0;
        for (i = 0; i < this.treeBins.length; ++i) {
            this.treeBins[i] = -1;
            this.clearTreeMap(i);
        }
        for (i = 0; i < this.smallBins.length; ++i) {
            this.smallBins[i] = -1;
            this.clearSmallMap(i);
        }
        this.occupied = 0;
    }

    public void expand(int increase) {
        this.topSize += increase;
        this.head(this.top, this.topSize | 1);
        assert (this.topSize < 0 || this.checkTopChunk(this.top));
    }

    public int allocate(int size) {
        return this.dlmalloc(size);
    }

    public void free(int address) {
        this.dlfree(address);
    }

    public int occupied() {
        return this.occupied;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (DEBUG) {
            sb.append("\nChunks:").append(this.dump());
        }
        return sb.toString();
    }

    private String dump() {
        StringBuilder sb = new StringBuilder();
        int q = 0;
        while (q != this.top) {
            if (this.isInUse(q)) {
                sb.append(" InUseChunk:&").append(q).append(':').append(this.chunkSize(q)).append('b');
            } else {
                sb.append(" FreeChunk:&").append(q).append(':').append(this.chunkSize(q)).append('b');
            }
            q = this.nextChunk(q);
        }
        sb.append(" TopChunk:&").append(this.top).append(':').append(this.topSize + TOP_FOOT_SIZE).append('b');
        return sb.toString();
    }

    private int dlmalloc(int bytes) {
        int nb;
        int n = nb = bytes < 7 ? 16 : BestFitAllocator.padRequest(bytes);
        if (bytes <= 240) {
            int index = BestFitAllocator.smallBinIndex(nb);
            int smallBits = this.smallMap >>> index;
            if ((smallBits & 3) != 0) {
                return this.allocateFromSmallBin(index += ~smallBits & 1, nb);
            }
            if (nb > this.designatedVictimSize) {
                if (smallBits != 0) {
                    return this.splitFromSmallBin(Integer.numberOfTrailingZeros(smallBits << index), nb);
                }
                if (this.treeMap != 0) {
                    return this.splitSmallFromTree(nb);
                }
            }
        } else {
            int mem;
            if (bytes > 2147483584) {
                return -1;
            }
            if (this.treeMap != 0 && BestFitAllocator.okAddress(mem = this.splitFromTree(nb))) {
                return mem;
            }
        }
        if (nb <= this.designatedVictimSize) {
            return this.splitFromDesignatedVictim(nb);
        }
        if (nb < this.topSize) {
            return this.splitFromTop(nb);
        }
        return -1;
    }

    private int allocateFromSmallBin(int index, int nb) {
        int h = this.smallBins[index];
        assert (this.chunkSize(h) == BestFitAllocator.smallBinIndexToSize(index));
        int f = this.forward(h);
        int b = this.backward(h);
        if (f == h) {
            assert (b == h);
            this.clearSmallMap(index);
            this.smallBins[index] = -1;
        } else {
            this.smallBins[index] = f;
            this.backward(f, b);
            this.forward(b, f);
        }
        this.setInUseAndPreviousInUse(h, BestFitAllocator.smallBinIndexToSize(index));
        int mem = BestFitAllocator.chunkToMem(h);
        assert (this.checkMallocedChunk(mem, nb));
        return mem;
    }

    private int splitFromSmallBin(int index, int nb) {
        int h = this.smallBins[index];
        assert (this.chunkSize(h) == BestFitAllocator.smallBinIndexToSize(index));
        int f = this.forward(h);
        int b = this.backward(h);
        if (f == h) {
            assert (b == h);
            this.clearSmallMap(index);
            this.smallBins[index] = -1;
        } else {
            this.smallBins[index] = f;
            this.backward(f, b);
            this.forward(b, f);
        }
        int rsize = BestFitAllocator.smallBinIndexToSize(index) - nb;
        if (rsize < 16) {
            this.setInUseAndPreviousInUse(h, BestFitAllocator.smallBinIndexToSize(index));
        } else {
            this.setSizeAndPreviousInUseOfInUseChunk(h, nb);
            int r = h + nb;
            this.setSizeAndPreviousInUseOfFreeChunk(r, rsize);
            this.replaceDesignatedVictim(r, rsize);
        }
        int mem = BestFitAllocator.chunkToMem(h);
        assert (this.checkMallocedChunk(mem, nb));
        return mem;
    }

    private void replaceDesignatedVictim(int p, int s) {
        int dvs = this.designatedVictimSize;
        if (dvs != 0) {
            int dv = this.designatedVictim;
            assert (BestFitAllocator.isSmall(dvs));
            this.insertSmallChunk(dv, dvs);
        }
        this.designatedVictimSize = s;
        this.designatedVictim = p;
    }

    private int splitSmallFromTree(int nb) {
        int t;
        int index = Integer.numberOfTrailingZeros(this.treeMap);
        int v = t = this.treeBins[index];
        int rsize = this.chunkSize(t) - nb;
        while ((t = this.leftmostChild(t)) != -1) {
            int trem = this.chunkSize(t) - nb;
            if (trem < 0 || trem >= rsize) continue;
            rsize = trem;
            v = t;
        }
        if (BestFitAllocator.okAddress(v)) {
            int r = v + nb;
            assert (this.chunkSize(v) == rsize + nb);
            if (BestFitAllocator.okNext(v, r)) {
                this.unlinkLargeChunk(v);
                if (rsize < 16) {
                    this.setInUseAndPreviousInUse(v, rsize + nb);
                } else {
                    this.setSizeAndPreviousInUseOfInUseChunk(v, nb);
                    this.setSizeAndPreviousInUseOfFreeChunk(r, rsize);
                    this.replaceDesignatedVictim(r, rsize);
                }
                int mem = BestFitAllocator.chunkToMem(v);
                assert (this.checkMallocedChunk(mem, nb));
                return mem;
            }
            throw new AssertionError();
        }
        throw new AssertionError();
    }

    private int splitFromTree(int nb) {
        int leftbits;
        int v = -1;
        int rsize = Integer.MAX_VALUE & -nb;
        int t = -1;
        int index = BestFitAllocator.treeBinIndex(nb);
        t = this.treeBins[index];
        if (t != -1) {
            int sizebits = nb << BestFitAllocator.leftShiftForTreeIndex(index);
            int rst = -1;
            while (true) {
                int trem;
                if ((trem = this.chunkSize(t) - nb) >= 0 && trem < rsize) {
                    v = t;
                    rsize = trem;
                    if (rsize == 0) break;
                }
                int rt = this.child(t, 1);
                t = this.child(t, sizebits >>> 31);
                if (rt != -1 && rt != t) {
                    rst = rt;
                }
                if (t == -1) {
                    t = rst;
                    break;
                }
                sizebits <<= 1;
            }
        }
        if (t == -1 && v == -1 && (leftbits = BestFitAllocator.leftBits(1 << index) & this.treeMap) != 0) {
            t = this.treeBins[Integer.numberOfTrailingZeros(leftbits)];
        }
        while (t != -1) {
            int trem = this.chunkSize(t) - nb;
            if (trem >= 0 && trem < rsize) {
                rsize = trem;
                v = t;
            }
            t = this.leftmostChild(t);
        }
        int designatedVictimFit = this.designatedVictimSize - nb;
        if (v != -1 && (designatedVictimFit < 0 || rsize < designatedVictimFit)) {
            if (BestFitAllocator.okAddress(v)) {
                int r = v + nb;
                assert (this.chunkSize(v) == rsize + nb);
                if (BestFitAllocator.okNext(v, r)) {
                    this.unlinkLargeChunk(v);
                    if (rsize < 16) {
                        this.setInUseAndPreviousInUse(v, rsize + nb);
                    } else {
                        this.setSizeAndPreviousInUseOfInUseChunk(v, nb);
                        this.setSizeAndPreviousInUseOfFreeChunk(r, rsize);
                        this.insertChunk(r, rsize);
                    }
                    return BestFitAllocator.chunkToMem(v);
                }
            } else {
                throw new AssertionError();
            }
        }
        return -1;
    }

    private int splitFromDesignatedVictim(int nb) {
        int rsize = this.designatedVictimSize - nb;
        int p = this.designatedVictim;
        if (rsize >= 16) {
            int r = this.designatedVictim = p + nb;
            this.designatedVictimSize = rsize;
            this.setSizeAndPreviousInUseOfFreeChunk(r, rsize);
            this.setSizeAndPreviousInUseOfInUseChunk(p, nb);
        } else {
            int dvs = this.designatedVictimSize;
            this.designatedVictimSize = 0;
            this.designatedVictim = -1;
            this.setInUseAndPreviousInUse(p, dvs);
        }
        int mem = BestFitAllocator.chunkToMem(p);
        assert (this.checkMallocedChunk(mem, nb));
        return mem;
    }

    private int splitFromTop(int nb) {
        int rSize = this.topSize -= nb;
        int p = this.top;
        int r = this.top = p + nb;
        this.head(r, rSize | 1);
        this.setSizeAndPreviousInUseOfInUseChunk(p, nb);
        int mem = BestFitAllocator.chunkToMem(p);
        assert (this.checkTopChunk(this.top));
        assert (this.checkMallocedChunk(mem, nb));
        return mem;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dlfree(int mem) {
        int p = BestFitAllocator.memToChunk(mem);
        if (!BestFitAllocator.okAddress(p) || !this.isInUse(p)) throw new IllegalArgumentException("Address " + mem + " has not been allocated");
        assert (this.checkInUseChunk(p));
        int psize = this.chunkSize(p);
        this.occupied -= psize;
        int next = p + psize;
        if (!this.previousInUse(p)) {
            int previousSize = this.prevFoot(p);
            int previous = p - previousSize;
            psize += previousSize;
            p = previous;
            if (!BestFitAllocator.okAddress(previous)) throw new AssertionError();
            if (p != this.designatedVictim) {
                this.unlinkChunk(p, previousSize);
            } else if ((this.head(next) & 3) == 3) {
                this.designatedVictimSize = psize;
                this.setFreeWithPreviousInUse(p, psize, next);
                return;
            }
        }
        if (!BestFitAllocator.okNext(p, next) || !this.previousInUse(next)) throw new AssertionError((Object)("Problem with next chunk [" + p + "][" + next + ":previous-inuse=" + this.previousInUse(next) + "]"));
        if (!this.chunkInUse(next)) {
            if (next == this.top) {
                int tsize = this.topSize += psize;
                this.top = p;
                this.head(p, tsize | 1);
                if (p == this.designatedVictim) {
                    this.designatedVictim = -1;
                    this.designatedVictimSize = 0;
                }
                this.storage.release(p + TOP_FOOT_SIZE);
                return;
            }
            if (next == this.designatedVictim) {
                int dsize = this.designatedVictimSize += psize;
                this.designatedVictim = p;
                this.setSizeAndPreviousInUseOfFreeChunk(p, dsize);
                return;
            }
            int nsize = this.chunkSize(next);
            this.unlinkChunk(next, nsize);
            this.setSizeAndPreviousInUseOfFreeChunk(p, psize += nsize);
            if (p == this.designatedVictim) {
                this.designatedVictimSize = psize;
                return;
            }
        } else {
            this.setFreeWithPreviousInUse(p, psize, next);
        }
        if (BestFitAllocator.isSmall(psize)) {
            this.insertSmallChunk(p, psize);
            return;
        } else {
            this.insertLargeChunk(p, psize);
        }
    }

    private void insertChunk(int p, int s) {
        if (BestFitAllocator.isSmall(s)) {
            this.insertSmallChunk(p, s);
        } else {
            this.insertLargeChunk(p, s);
        }
    }

    private void insertSmallChunk(int p, int s) {
        int index = BestFitAllocator.smallBinIndex(s);
        int h = this.smallBins[index];
        if (!this.smallMapIsMarked(index)) {
            this.markSmallMap(index);
            this.smallBins[index] = p;
            this.forward(p, p);
            this.backward(p, p);
        } else if (BestFitAllocator.okAddress(h)) {
            int b = this.backward(h);
            this.forward(b, p);
            this.forward(p, h);
            this.backward(h, p);
            this.backward(p, b);
        } else {
            throw new AssertionError();
        }
        assert (this.checkFreeChunk(p));
    }

    private void insertLargeChunk(int x, int s) {
        block7: {
            int index = BestFitAllocator.treeBinIndex(s);
            int h = this.treeBins[index];
            this.index(x, index);
            this.child(x, 0, -1);
            this.child(x, 1, -1);
            if (!this.treeMapIsMarked(index)) {
                this.markTreeMap(index);
                this.treeBins[index] = x;
                this.parent(x, -1);
                this.forward(x, x);
                this.backward(x, x);
            } else {
                int t = h;
                int k = s << BestFitAllocator.leftShiftForTreeIndex(index);
                while (this.chunkSize(t) != s) {
                    int childIndex = k >>> 31 & 1;
                    int child = this.child(t, childIndex);
                    k <<= 1;
                    if (BestFitAllocator.okAddress(child)) {
                        t = child;
                        continue;
                    }
                    this.child(t, childIndex, x);
                    this.parent(x, t);
                    this.forward(x, x);
                    this.backward(x, x);
                    break block7;
                }
                int f = this.forward(t);
                if (BestFitAllocator.okAddress(t) && BestFitAllocator.okAddress(f)) {
                    this.backward(f, x);
                    this.forward(t, x);
                    this.forward(x, f);
                    this.backward(x, t);
                    this.parent(x, -1);
                } else {
                    throw new AssertionError();
                }
            }
        }
        assert (this.checkFreeChunk(x));
    }

    private void unlinkChunk(int p, int s) {
        if (BestFitAllocator.isSmall(s)) {
            this.unlinkSmallChunk(p, s);
        } else {
            this.unlinkLargeChunk(p);
        }
    }

    private void unlinkSmallChunk(int p, int s) {
        int f = this.forward(p);
        int b = this.backward(p);
        int index = BestFitAllocator.smallBinIndex(s);
        assert (this.chunkSize(p) == BestFitAllocator.smallBinIndexToSize(index));
        if (f == p) {
            assert (b == p);
            this.clearSmallMap(index);
            this.smallBins[index] = -1;
        } else if (BestFitAllocator.okAddress(this.smallBins[index])) {
            if (this.smallBins[index] == p) {
                this.smallBins[index] = f;
            }
            this.forward(b, f);
            this.backward(f, b);
        } else {
            throw new AssertionError();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void unlinkLargeChunk(int x) {
        int c1;
        int r;
        int xp;
        block13: {
            int rpIndex;
            block14: {
                block12: {
                    xp = this.parent(x);
                    r = -1;
                    if (this.backward(x) == x) break block12;
                    int f = this.forward(x);
                    r = this.backward(x);
                    if (!BestFitAllocator.okAddress(f)) throw new AssertionError();
                    this.backward(f, r);
                    this.forward(r, f);
                    break block13;
                }
                rpIndex = 1;
                r = this.child(x, 1);
                if (r != -1) break block14;
                rpIndex = 0;
                r = this.child(x, 0);
                if (r == -1) break block13;
            }
            int rp = x;
            while (true) {
                if (this.child(r, 1) != -1) {
                    rp = r;
                    rpIndex = 1;
                    r = this.child(r, 1);
                    continue;
                }
                if (this.child(r, 0) == -1) break;
                rp = r;
                rpIndex = 0;
                r = this.child(r, 0);
            }
            if (!BestFitAllocator.okAddress(rp)) throw new AssertionError();
            this.child(rp, rpIndex, -1);
        }
        int index = this.index(x);
        if (xp == -1 && this.treeBins[index] != x) return;
        int h = this.treeBins[index];
        if (x == h) {
            this.treeBins[index] = r;
            if (this.treeBins[index] == -1) {
                this.clearTreeMap(index);
            } else {
                this.parent(r, -1);
            }
        } else {
            if (!BestFitAllocator.okAddress(xp)) throw new AssertionError();
            if (this.child(xp, 0) == x) {
                this.child(xp, 0, r);
            } else {
                this.child(xp, 1, r);
            }
        }
        if (r == -1) return;
        if (!BestFitAllocator.okAddress(r)) throw new AssertionError();
        this.parent(r, xp);
        int c0 = this.child(x, 0);
        if (c0 != -1) {
            if (!BestFitAllocator.okAddress(c0)) throw new AssertionError();
            this.child(r, 0, c0);
            this.parent(c0, r);
        }
        if ((c1 = this.child(x, 1)) == -1) return;
        if (!BestFitAllocator.okAddress(c1)) throw new AssertionError();
        this.child(r, 1, c1);
        this.parent(c1, r);
    }

    private boolean chunkInUse(int p) {
        return (this.head(p) & 2) != 0;
    }

    private boolean previousInUse(int p) {
        return (this.head(p) & 1) != 0;
    }

    private boolean isInUse(int p) {
        return (this.head(p) & 3) != 1;
    }

    private int chunkSize(int p) {
        return this.head(p) & 0xFFFFFFF8;
    }

    private void clearPreviousInUse(int p) {
        this.head(p, this.head(p) & 0xFFFFFFFE);
    }

    private int nextChunk(int p) {
        return p + this.chunkSize(p);
    }

    private int prevChunk(int p) {
        return p - this.prevFoot(p);
    }

    private boolean nextPreviousInUse(int p) {
        return (this.head(this.nextChunk(p)) & 1) != 0;
    }

    private void setFoot(int p, int s) {
        this.prevFoot(p + s, s);
    }

    private void setSizeAndPreviousInUseOfFreeChunk(int p, int s) {
        this.head(p, s | 1);
        this.setFoot(p, s);
    }

    private void setFreeWithPreviousInUse(int p, int s, int n) {
        this.clearPreviousInUse(n);
        this.setSizeAndPreviousInUseOfFreeChunk(p, s);
    }

    private void setInUseAndPreviousInUse(int p, int s) {
        this.setSizeAndPreviousInUseOfInUseChunk(p, s);
        this.head(p + s, this.head(p + s) | 1);
    }

    private void setSizeAndPreviousInUseOfInUseChunk(int p, int s) {
        this.head(p, s | 1 | 2);
        this.setFoot(p, s);
        this.occupied += s;
    }

    private int prevFoot(int p) {
        return this.storage.readInt(p);
    }

    private void prevFoot(int p, int value) {
        this.storage.writeInt(p, value);
    }

    private int head(int p) {
        return this.storage.readInt(p + 4);
    }

    private void head(int p, int value) {
        this.storage.writeInt(p + 4, value);
    }

    private int forward(int p) {
        return this.storage.readInt(p + 8);
    }

    private void forward(int p, int value) {
        this.storage.writeInt(p + 8, value);
    }

    private int backward(int p) {
        return this.storage.readInt(p + 12);
    }

    private void backward(int p, int value) {
        this.storage.writeInt(p + 12, value);
    }

    private int child(int p, int index) {
        return this.storage.readInt(p + 16 + 4 * index);
    }

    private void child(int p, int index, int value) {
        this.storage.writeInt(p + 16 + 4 * index, value);
    }

    private int parent(int p) {
        return this.storage.readInt(p + 24);
    }

    private void parent(int p, int value) {
        this.storage.writeInt(p + 24, value);
    }

    private int index(int p) {
        return this.storage.readInt(p + 28);
    }

    private void index(int p, int value) {
        this.storage.writeInt(p + 28, value);
    }

    private int leftmostChild(int x) {
        int left = this.child(x, 0);
        return left != -1 ? left : this.child(x, 1);
    }

    private static int padRequest(int req) {
        return req + 8 + 7 & 0xFFFFFFF8;
    }

    private static int chunkToMem(int p) {
        return p + 8;
    }

    private static int memToChunk(int p) {
        return p - 8;
    }

    private static boolean okAddress(int a) {
        return a >= 0;
    }

    private static boolean okNext(int p, int n) {
        return p < n;
    }

    private static boolean isAligned(int a) {
        return (a & 7) == 0;
    }

    private static int alignOffset(int a) {
        return (a & 7) == 0 ? 0 : 8 - (a & 7) & 7;
    }

    private static boolean isSmall(int s) {
        return BestFitAllocator.smallBinIndex(s) < 32;
    }

    private static int smallBinIndex(int s) {
        return s >>> 3;
    }

    private static int smallBinIndexToSize(int i) {
        return i << 3;
    }

    private static int treeBinIndex(int s) {
        int x = s >>> 8;
        if (x == 0) {
            return 0;
        }
        if (x > 65535) {
            return 31;
        }
        int k = 31 - Integer.numberOfLeadingZeros(x);
        return (k << 1) + (s >>> k + 7 & 1);
    }

    private void markSmallMap(int i) {
        this.smallMap |= 1 << i;
    }

    private void clearSmallMap(int i) {
        this.smallMap &= ~(1 << i);
    }

    private boolean smallMapIsMarked(int i) {
        return (this.smallMap & 1 << i) != 0;
    }

    private void markTreeMap(int i) {
        this.treeMap |= 1 << i;
    }

    private void clearTreeMap(int i) {
        this.treeMap &= ~(1 << i);
    }

    private boolean treeMapIsMarked(int i) {
        return (this.treeMap & 1 << i) != 0;
    }

    private static int leftShiftForTreeIndex(int i) {
        return i == 31 ? 0 : 31 - ((i >>> 1) + 8 - 2);
    }

    private static int minSizeForTreeIndex(int i) {
        return 1 << (i >>> 1) + 8 | (i & 1) << (i >>> 1) + 8 - 1;
    }

    private static int leftBits(int i) {
        return i << 1 | -(i << 1);
    }

    public void validate() {
        int i;
        if (this.topSize < 0) {
            return;
        }
        this.traverseAndCheck();
        for (i = 0; i < this.smallBins.length; ++i) {
            this.checkSmallBin(i);
        }
        for (i = 0; i < this.treeBins.length; ++i) {
            this.checkTreeBin(i);
        }
    }

    public int validateMallocedPointer(int m) {
        int p = BestFitAllocator.memToChunk(m);
        this.checkMallocedChunk(m, this.chunkSize(p));
        if (this.findFreeChunk(p)) {
            throw new AssertionError();
        }
        return this.chunkSize(p);
    }

    private boolean checkAnyChunk(int p) {
        if (!BestFitAllocator.isAligned(BestFitAllocator.chunkToMem(p))) {
            throw new AssertionError((Object)("Chunk address [mem:" + p + "=>chunk:" + BestFitAllocator.chunkToMem(p) + "] is incorrectly aligned"));
        }
        if (!BestFitAllocator.okAddress(p)) {
            throw new AssertionError((Object)("Memory address " + p + " is invalid"));
        }
        return true;
    }

    private boolean checkTopChunk(int p) {
        int sz = this.head(p) & 0xFFFFFFFC;
        if (!BestFitAllocator.isAligned(BestFitAllocator.chunkToMem(p))) {
            throw new AssertionError((Object)("Chunk address [mem:" + p + "=>chunk:" + BestFitAllocator.chunkToMem(p) + "] of top chunk is incorrectly aligned"));
        }
        if (!BestFitAllocator.okAddress(p)) {
            throw new AssertionError((Object)("Memory address " + p + " of top chunk is invalid"));
        }
        if (sz != this.topSize) {
            throw new AssertionError((Object)("Marked size top chunk " + sz + " is not equals to the recorded top size " + this.topSize));
        }
        if (sz <= 0) {
            throw new AssertionError((Object)("Top chunk size " + sz + " is not positive"));
        }
        if (!this.previousInUse(p)) {
            throw new AssertionError((Object)"Chunk before top chunk is free - why has it not been merged in to the top chunk?");
        }
        return true;
    }

    private boolean checkInUseChunk(int p) {
        this.checkAnyChunk(p);
        if (!this.isInUse(p)) {
            throw new AssertionError((Object)("Chunk at " + p + " is not in use"));
        }
        if (!this.nextPreviousInUse(p)) {
            throw new AssertionError((Object)("Chunk after " + p + " does not see this chunk as in use"));
        }
        if (!this.previousInUse(p) && this.nextChunk(this.prevChunk(p)) != p) {
            throw new AssertionError((Object)("Previous chunk to " + p + " is marked free but has an incorrect next pointer"));
        }
        return true;
    }

    private boolean checkFreeChunk(int p) {
        int sz = this.chunkSize(p);
        int next = p + sz;
        this.checkAnyChunk(p);
        if (this.isInUse(p)) {
            throw new AssertionError((Object)("Free chunk " + p + " is not marked as free"));
        }
        if (this.nextPreviousInUse(p)) {
            throw new AssertionError((Object)("Next chunk after " + p + " has it marked as in use"));
        }
        if (p != this.designatedVictim && p != this.top) {
            if (sz < 16) {
                throw new AssertionError((Object)("Free chunk " + p + " is too small"));
            }
            if ((sz & 7) != 0) {
                throw new AssertionError((Object)("Chunk size " + sz + " of " + p + " is not correctly aligned"));
            }
            if (!BestFitAllocator.isAligned(BestFitAllocator.chunkToMem(p))) {
                throw new AssertionError((Object)("User pointer for chunk " + p + " is not correctly aligned"));
            }
            if (this.prevFoot(next) != sz) {
                throw new AssertionError((Object)("Next chunk after " + p + " has an incorrect previous size"));
            }
            if (!this.previousInUse(p)) {
                throw new AssertionError((Object)("Chunk before free chunk " + p + " is free - should have been merged"));
            }
            if (next != this.top && !this.isInUse(next)) {
                throw new AssertionError((Object)("Chunk after free chunk " + p + " is free - should have been merged"));
            }
            if (this.backward(this.forward(p)) != p) {
                throw new AssertionError((Object)("Free chunk " + p + " has invalid chain links"));
            }
            if (this.forward(this.backward(p)) != p) {
                throw new AssertionError((Object)("Free chunk " + p + " has invalid chain links"));
            }
        }
        return true;
    }

    private boolean checkMallocedChunk(int mem, int s) {
        int p = BestFitAllocator.memToChunk(mem);
        int sz = this.head(p) & 0xFFFFFFFC;
        this.checkInUseChunk(p);
        if (sz < 16) {
            throw new AssertionError((Object)("Allocated chunk " + p + " is too small"));
        }
        if ((sz & 7) != 0) {
            throw new AssertionError((Object)("Chunk size " + sz + " of " + p + " is not correctly aligned"));
        }
        if (sz < s) {
            throw new AssertionError((Object)("Allocated chunk " + p + " is smaller than requested [" + sz + "<" + s + "]"));
        }
        if (sz > s + 16) {
            throw new AssertionError((Object)("Allocated chunk " + p + " is too large (should have been split off) [" + sz + ">>" + s + "]"));
        }
        return true;
    }

    private void checkTree(int t) {
        int tsize;
        int index;
        int head = -1;
        int u = t;
        int tindex = this.index(t);
        if (tindex != (index = BestFitAllocator.treeBinIndex(tsize = this.chunkSize(t)))) {
            throw new AssertionError((Object)("Tree node " + u + " has incorrect index [" + this.index(u) + "!=" + tindex + "]"));
        }
        if (tsize < 256) {
            throw new AssertionError((Object)("Tree node " + u + " is too small to be in a tree [" + tsize + "<" + 256 + "]"));
        }
        if (tsize < BestFitAllocator.minSizeForTreeIndex(index)) {
            throw new AssertionError((Object)("Tree node " + u + " is too small to be in this tree [" + tsize + "<" + BestFitAllocator.minSizeForTreeIndex(index) + "]"));
        }
        if (index != 31 && tsize >= BestFitAllocator.minSizeForTreeIndex(index + 1)) {
            throw new AssertionError((Object)("Tree node " + u + " is too large to be in this tree [" + tsize + ">=" + BestFitAllocator.minSizeForTreeIndex(index + 1) + "]"));
        }
        do {
            this.checkAnyChunk(u);
            if (this.index(u) != tindex) {
                throw new AssertionError((Object)("Tree node " + u + " has incorrect index [" + this.index(u) + "!=" + tindex + "]"));
            }
            if (this.chunkSize(u) != tsize) {
                throw new AssertionError((Object)("Tree node " + u + " has an mismatching size [" + this.chunkSize(u) + "!=" + tsize + "]"));
            }
            if (this.isInUse(u)) {
                throw new AssertionError((Object)("Tree node " + u + " is in use"));
            }
            if (this.nextPreviousInUse(u)) {
                throw new AssertionError((Object)("Tree node " + u + " is marked as in use in the next chunk"));
            }
            if (this.backward(this.forward(u)) != u) {
                throw new AssertionError((Object)("Tree node " + u + " has incorrect chain links"));
            }
            if (this.forward(this.backward(u)) != u) {
                throw new AssertionError((Object)("Tree node " + u + " has incorrect chain links"));
            }
            if (this.parent(u) == -1 && u != this.treeBins[index]) {
                if (this.child(u, 0) != -1) {
                    throw new AssertionError((Object)("Tree node " + u + " is chained from the tree but has a child " + this.child(u, 0)));
                }
                if (this.child(u, 1) != -1) {
                    throw new AssertionError((Object)("Tree node " + u + " is chained from the tree but has a child" + this.child(u, 1)));
                }
                continue;
            }
            if (head != -1) {
                throw new AssertionError((Object)("Tree node " + u + " is the second node in this chain with a parent [first was " + head + "]"));
            }
            head = u;
            if (this.treeBins[index] == u) {
                if (this.parent(u) != -1) {
                    throw new AssertionError((Object)("Tree node " + u + " is the head of the tree but has a parent " + this.parent(u)));
                }
            } else {
                if (this.parent(u) == u) {
                    throw new AssertionError((Object)("Tree node " + u + " is its own parent"));
                }
                if (this.child(this.parent(u), 0) != u && this.child(this.parent(u), 1) != u) {
                    throw new AssertionError((Object)("Tree node " + u + " is not a child of its parent"));
                }
            }
            if (this.child(u, 0) != -1) {
                if (this.parent(this.child(u, 0)) != u) {
                    throw new AssertionError((Object)("Tree node " + u + " is not the parent of its left child"));
                }
                if (this.child(u, 0) == u) {
                    throw new AssertionError((Object)("Tree node " + u + " is its own left child"));
                }
                this.checkTree(this.child(u, 0));
            }
            if (this.child(u, 1) != -1) {
                if (this.parent(this.child(u, 1)) != u) {
                    throw new AssertionError((Object)("Tree node " + u + " is not the parent of its right child"));
                }
                if (this.child(u, 1) == u) {
                    throw new AssertionError((Object)("Tree node " + u + " is its own right child"));
                }
                this.checkTree(this.child(u, 1));
            }
            if (this.child(u, 0) != -1 && this.child(u, 1) != -1 && this.chunkSize(this.child(u, 0)) >= this.chunkSize(this.child(u, 1))) {
                throw new AssertionError((Object)("Tree node " + u + " has it's left child bigger than it's right child"));
            }
        } while ((u = this.forward(u)) != t);
        if (head == -1) {
            throw new AssertionError((Object)"This tree level has no nodes with a parent");
        }
    }

    private void checkTreeBin(int index) {
        boolean empty;
        int tb = this.treeBins[index];
        boolean bl = empty = (this.treeMap & 1 << index) == 0;
        if (tb == -1 && !empty) {
            throw new AssertionError((Object)("Tree " + index + " is marked as occupied but has an invalid head pointer"));
        }
        if (!empty) {
            this.checkTree(tb);
        }
    }

    private void checkSmallBin(int index) {
        boolean empty;
        int h = this.smallBins[index];
        boolean bl = empty = (this.smallMap & 1 << index) == 0;
        if (h == -1 && !empty) {
            throw new AssertionError((Object)("Small bin chain " + index + " is marked as occupied but has an invalid head pointer"));
        }
        if (!empty) {
            int p = h;
            do {
                int size = this.chunkSize(p);
                this.checkFreeChunk(p);
                if (BestFitAllocator.smallBinIndex(size) != index) {
                    throw new AssertionError((Object)("Chunk " + p + " is the wrong size to be in bin " + index));
                }
                if (this.backward(p) != p && this.chunkSize(this.backward(p)) != this.chunkSize(p)) {
                    throw new AssertionError((Object)("Chunk " + p + " is the linked to a chunk of the wrong size"));
                }
                this.checkInUseChunk(this.nextChunk(p));
            } while ((p = this.backward(p)) != h);
        }
    }

    private int traverseAndCheck() {
        int sum = 0;
        sum += this.topSize + TOP_FOOT_SIZE;
        int q = 0;
        int lastq = 0;
        if (!this.previousInUse(q)) {
            throw new AssertionError((Object)"Chunk before zeroth chunk is marked as free");
        }
        while (q != this.top) {
            sum += this.chunkSize(q);
            if (this.isInUse(q)) {
                if (this.findFreeChunk(q)) {
                    throw new AssertionError((Object)"Chunk marked as in-use appears in a free structure");
                }
                this.checkInUseChunk(q);
            } else {
                if (q != this.designatedVictim && !this.findFreeChunk(q)) {
                    throw new AssertionError((Object)"Chunk marked as free cannot be found in any free structure");
                }
                if (lastq != 0 && !this.isInUse(lastq)) {
                    throw new AssertionError((Object)"Chunk before free chunk is not in-use");
                }
                this.checkFreeChunk(q);
            }
            lastq = q;
            q = this.nextChunk(q);
        }
        return sum;
    }

    private boolean findFreeChunk(int x) {
        int size = this.chunkSize(x);
        if (BestFitAllocator.isSmall(size)) {
            int sidx = BestFitAllocator.smallBinIndex(size);
            int h = this.smallBins[sidx];
            if (this.smallMapIsMarked(sidx)) {
                int p = h;
                do {
                    if (p != x) continue;
                    return true;
                } while ((p = this.forward(p)) != h);
            }
        } else {
            int tidx = BestFitAllocator.treeBinIndex(size);
            if (this.treeMapIsMarked(tidx)) {
                int t = this.treeBins[tidx];
                int sizebits = size << BestFitAllocator.leftShiftForTreeIndex(tidx);
                while (t != -1 && this.chunkSize(t) != size) {
                    t = this.child(t, sizebits >>> 31 & 1);
                    sizebits <<= 1;
                }
                if (t != -1) {
                    int u = t;
                    do {
                        if (u != x) continue;
                        return true;
                    } while ((u = this.forward(u)) != t);
                }
            }
        }
        return false;
    }

    public int getLastUsedAddress() {
        if (this.top <= 0) {
            return -1;
        }
        return BestFitAllocator.chunkToMem(this.prevChunk(this.top));
    }
}

