/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.pinning.concurrent;

import com.terracottatech.offheapstore.Segment;
import com.terracottatech.offheapstore.concurrent.AbstractConcurrentOffHeapCache;
import com.terracottatech.offheapstore.concurrent.AbstractConcurrentOffHeapMap;
import com.terracottatech.offheapstore.exceptions.OversizeMappingException;
import com.terracottatech.offheapstore.pinning.AbstractPinnableOffHeapClockCache;
import com.terracottatech.offheapstore.pinning.PinnableCache;
import com.terracottatech.offheapstore.pinning.PinnableSegment;
import com.terracottatech.offheapstore.util.Factory;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public abstract class AbstractPinnableConcurrentOffHeapCache<K, V>
extends AbstractConcurrentOffHeapCache<K, V>
implements PinnableCache<K, V> {
    private Set<K> pinnedKeySet;

    public AbstractPinnableConcurrentOffHeapCache(Factory<? extends PinnableSegment<K, V>> segmentFactory, boolean latencyMonitoring) {
        super(segmentFactory, latencyMonitoring);
    }

    public AbstractPinnableConcurrentOffHeapCache(Factory<? extends PinnableSegment<K, V>> segmentFactory, int concurrency, boolean latencyMonitoring) {
        super(segmentFactory, concurrency, latencyMonitoring);
    }

    @Override
    public boolean isPinned(Object key) {
        return this.segmentFor(key).isPinned(key);
    }

    @Override
    public void setPinning(K key, boolean pinned) {
        while (true) {
            try {
                this.segmentFor(key).setPinning(key, pinned);
                return;
            }
            catch (OversizeMappingException e) {
                if (this.handleOversizeMappingException(key.hashCode())) continue;
                throw e;
            }
            break;
        }
    }

    public Set<K> pinnedKeySet() {
        AggregatePinnedKeySet pks = this.pinnedKeySet;
        return pks != null ? pks : (this.pinnedKeySet = new AggregatePinnedKeySet());
    }

    @Override
    public void unpinAll() {
        for (Segment s : this.segments) {
            ((PinnableSegment)s).unpinAll();
        }
    }

    @Override
    protected PinnableSegment<K, V> segmentFor(Object key) {
        return (PinnableSegment)super.segmentFor(key);
    }

    private class AggregatePinnedKeySet
    extends AbstractSet<K> {
        private AggregatePinnedKeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new AbstractConcurrentOffHeapMap.AggregateIterator<K>(){

                @Override
                protected Iterator<K> getNextIterator() {
                    return ((AbstractPinnableOffHeapClockCache)this.listIterator.next()).pinnedKeySet().iterator();
                }
            };
        }

        @Override
        public int size() {
            int size = 0;
            for (Segment segment : AbstractPinnableConcurrentOffHeapCache.this.segments) {
                size += ((AbstractPinnableOffHeapClockCache)segment).pinnedKeySet().size();
            }
            return size;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return AbstractPinnableConcurrentOffHeapCache.this.isPinned(o) && AbstractPinnableConcurrentOffHeapCache.this.containsKey(o);
        }
    }
}

