/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.disk.paging;

public class PowerOfTwoFileAllocator {
    private static final boolean DEBUG = Boolean.getBoolean(PowerOfTwoFileAllocator.class.getName() + ".DEBUG");
    private static final Region NULL_NODE = new Region();
    private Region root = NULL_NODE;
    private Region deletedNode;
    private Region lastNode;
    private Region deletedElement;
    private long occupied;

    public PowerOfTwoFileAllocator() {
        this(Long.MAX_VALUE);
    }

    public PowerOfTwoFileAllocator(long size) {
        this.root = new Region(0L, size);
    }

    public Long allocate(long size) {
        if (Long.bitCount(size) != 1) {
            throw new AssertionError((Object)("Size " + size + " is not a power of two"));
        }
        Region r = this.find(size);
        if (r == null) {
            return null;
        }
        this.mark(r);
        return r.start();
    }

    public void free(long address, long length) {
        if (length == 0L) {
            return;
        }
        Region r = new Region(address, address + length - 1L);
        this.free(r);
        this.freed(r);
    }

    public void mark(long address, long length) {
        if (length == 0L) {
            return;
        }
        this.mark(new Region(address, address + length - 1L));
    }

    public long occupied() {
        return this.occupied;
    }

    private void allocated(Region r) {
        this.occupied += r.size();
    }

    private void freed(Region r) {
        this.occupied -= r.size();
    }

    private void mark(Region r) {
        Region current = this.remove(this.find(r));
        Region newRange = current.remove(r);
        if (newRange != null) {
            this.insert(current);
            this.insert(newRange);
        } else if (!current.isNull()) {
            this.insert(current);
        }
        this.allocated(r);
    }

    private void free(Region r) {
        Region prev = this.find(new Region(r.start() - 1L));
        if (prev != null) {
            prev = this.remove(prev);
            prev.merge(r);
            Region next = this.remove(new Region(r.end() + 1L));
            if (next != null) {
                prev.merge(next);
            }
            this.insert(prev);
            return;
        }
        Region next = this.find(new Region(r.end() + 1L));
        if (next != null) {
            next = this.remove(next);
            next.merge(r);
            this.insert(next);
            return;
        }
        this.insert(r);
    }

    private void insert(Region x) {
        this.root = this.insert(x, this.root);
    }

    private Region remove(Region x) {
        this.deletedNode = NULL_NODE;
        this.root = this.remove(x, this.root);
        Region d = this.deletedElement;
        this.deletedElement = null;
        if (d == null) {
            return null;
        }
        return new Region(d);
    }

    private Region find(long size) {
        assert (Long.bitCount(size) == 1);
        Region current = this.root;
        if ((current.available() & size) == 0L) {
            return null;
        }
        while (true) {
            if (current.left != null && (current.left.available() & size) != 0L) {
                current = current.left;
                continue;
            }
            if ((current.availableHere() & size) != 0L) {
                long mask = size - 1L;
                long a = current.start() + mask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                return new Region(a, a + size - 1L);
            }
            if (current.right == null || (current.right.available() & size) == 0L) break;
            current = current.right;
        }
        throw new AssertionError();
    }

    private Region find(Region x) {
        Region current = this.root;
        while (current != NULL_NODE) {
            long res = x.orderRelativeTo(current);
            if (res < 0L) {
                current = current.left;
                continue;
            }
            if (res > 0L) {
                current = current.right;
                continue;
            }
            return current;
        }
        return null;
    }

    private Region insert(Region x, Region t) {
        if (t == NULL_NODE) {
            t = x;
        } else if (x.orderRelativeTo(t) < 0) {
            t.left(this.insert(x, t.left));
        } else if (x.orderRelativeTo(t) > 0) {
            t.right(this.insert(x, t.right));
        } else {
            throw new AssertionError((Object)("Cannot insert " + x + " into " + this));
        }
        t = PowerOfTwoFileAllocator.skew(t);
        t = PowerOfTwoFileAllocator.split(t);
        return t;
    }

    private Region remove(Region x, Region t) {
        if (t != NULL_NODE) {
            this.lastNode = t;
            if (x.orderRelativeTo(t) < 0) {
                t.left(this.remove(x, t.left));
            } else {
                this.deletedNode = t;
                t.right(this.remove(x, t.right));
            }
            if (t == this.lastNode) {
                if (this.deletedNode != NULL_NODE && x.orderRelativeTo(this.deletedNode) == 0) {
                    this.deletedNode.swap(t);
                    this.deletedElement = t;
                    t = t.right;
                }
            } else if (t.left.level < t.level - 1 || t.right.level < t.level - 1) {
                if (t.right.level > --t.level) {
                    t.right.level = t.level;
                }
                t = PowerOfTwoFileAllocator.skew(t);
                t.right(PowerOfTwoFileAllocator.skew(t.right));
                t.right.right(PowerOfTwoFileAllocator.skew(t.right.right));
                t = PowerOfTwoFileAllocator.split(t);
                t.right(PowerOfTwoFileAllocator.split(t.right));
            }
        }
        return t;
    }

    private static Region skew(Region t) {
        if (t.left.level == t.level) {
            t = PowerOfTwoFileAllocator.rotateWithLeftChild(t);
        }
        return t;
    }

    private static Region split(Region t) {
        if (t.right.right.level == t.level) {
            t = PowerOfTwoFileAllocator.rotateWithRightChild(t);
            t.level++;
        }
        return t;
    }

    private static Region rotateWithLeftChild(Region k2) {
        Region k1 = k2.left;
        k2.left(k1.right);
        k1.right(k2);
        return k1;
    }

    private static Region rotateWithRightChild(Region k1) {
        Region k2 = k1.right;
        k1.right(k2.left);
        k2.left(k1);
        return k2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        if (DEBUG) {
            sb.append("\nFree Regions = ").append(this.root.dump()).append("");
        }
        return sb.toString();
    }

    static class Region {
        private Region left;
        private Region right;
        private int level;
        private long start;
        private long end;
        private long availableBitSet;

        Region() {
            this.start = 1L;
            this.end = 0L;
            this.level = 0;
            this.left = this;
            this.right = this;
            this.availableBitSet = 0L;
        }

        Region(long value) {
            this(value, value);
        }

        Region(long start, long end) {
            this.start = start;
            this.end = end;
            this.left = NULL_NODE;
            this.right = NULL_NODE;
            this.level = 1;
            this.updateAvailable();
        }

        Region(Region r) {
            this(r.start(), r.end());
        }

        long available() {
            if (this.left == NULL_NODE && this.right == NULL_NODE) {
                return this.availableHere();
            }
            return this.availableBitSet;
        }

        private void updateAvailable() {
            this.availableBitSet = this.availableHere() | this.left.available() | this.right.available();
        }

        long availableHere() {
            long bits = 0L;
            for (int i = 0; i < 63; ++i) {
                long size = 1L << i;
                long mask = size - 1L;
                long a = this.start + mask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                if (this.end - a < size - 1L) continue;
                bits |= size;
            }
            return bits;
        }

        void left(Region l) {
            this.left = l;
            this.updateAvailable();
        }

        void right(Region r) {
            this.right = r;
            this.updateAvailable();
        }

        public String toString() {
            if (this == NULL_NODE) {
                return "EMPTY";
            }
            return "Range(" + this.start + "," + this.end + ")" + " available:" + Long.toBinaryString(this.availableHere());
        }

        private String dump() {
            String ds = "";
            if (this.left != NULL_NODE) {
                ds = "(" + this.left.dump();
                ds = ds + " <= " + String.valueOf(this);
            } else {
                ds = ds + "(" + String.valueOf(this);
            }
            ds = this.right != NULL_NODE ? ds + " => " + this.right.dump() + ")" : ds + ")";
            return ds;
        }

        public long size() {
            return this.isNull() ? 0L : this.end - this.start + 1L;
        }

        public boolean isNull() {
            return this.start > this.end;
        }

        public Region remove(Region r) {
            if (r.start < this.start || r.end > this.end) {
                throw new AssertionError((Object)("Ranges : Illegal value passed to remove : " + this + " remove called for : " + r));
            }
            if (this.start == r.start) {
                this.start = r.end + 1L;
                this.updateAvailable();
                return null;
            }
            if (this.end == r.end) {
                this.end = r.start - 1L;
                this.updateAvailable();
                return null;
            }
            Region newRegion = new Region(r.end + 1L, this.end);
            this.end = r.start - 1L;
            this.updateAvailable();
            return newRegion;
        }

        public void merge(Region r) {
            if (this.start == r.end + 1L) {
                this.start = r.start;
            } else if (this.end == r.start - 1L) {
                this.end = r.end;
            } else {
                throw new AssertionError((Object)("Ranges : Merge called on non contiguous values : [this]:" + this + " and " + r));
            }
            this.updateAvailable();
        }

        public int orderRelativeTo(Region other) {
            if (this.start < other.start) {
                return -1;
            }
            if (this.end > other.end) {
                return 1;
            }
            return 0;
        }

        private void swap(Region other) {
            Region r = other;
            long temp = this.start;
            this.start = r.start;
            r.start = temp;
            temp = this.end;
            this.end = r.end;
            r.end = temp;
            this.updateAvailable();
        }

        public long start() {
            return this.start;
        }

        public long end() {
            return this.end;
        }
    }
}

