/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.concurrent;

import com.terracottatech.offheapstore.Segment;
import com.terracottatech.offheapstore.concurrent.AbstractConcurrentOffHeapMap;
import com.terracottatech.offheapstore.exceptions.OversizeMappingException;
import com.terracottatech.offheapstore.util.Factory;
import java.util.concurrent.locks.Lock;

public abstract class AbstractConcurrentOffHeapCache<K, V>
extends AbstractConcurrentOffHeapMap<K, V> {
    public AbstractConcurrentOffHeapCache(Factory<? extends Segment<K, V>> segmentFactory, boolean latencyMonitoring) {
        super(segmentFactory, latencyMonitoring);
    }

    public AbstractConcurrentOffHeapCache(Factory<? extends Segment<K, V>> segmentFactory, int concurrency, boolean latencyMonitoring) {
        super(segmentFactory, concurrency, latencyMonitoring);
    }

    @Override
    public V put(K key, V value) {
        while (true) {
            try {
                return super.put(key, value);
            }
            catch (OversizeMappingException e) {
                if (this.handleOversizeMappingException(key.hashCode())) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public V fill(K key, V value) {
        try {
            return super.fill(key, value);
        }
        catch (OversizeMappingException e) {
            return null;
        }
    }

    @Override
    public V putIfAbsent(K key, V value) {
        while (true) {
            try {
                return super.putIfAbsent(key, value);
            }
            catch (OversizeMappingException e) {
                if (this.handleOversizeMappingException(key.hashCode())) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        while (true) {
            try {
                return super.replace(key, oldValue, newValue);
            }
            catch (OversizeMappingException e) {
                if (this.handleOversizeMappingException(key.hashCode())) continue;
                throw e;
            }
            break;
        }
    }

    @Override
    public V replace(K key, V value) {
        while (true) {
            try {
                return super.replace(key, value);
            }
            catch (OversizeMappingException e) {
                if (this.handleOversizeMappingException(key.hashCode())) continue;
                throw e;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean handleOversizeMappingException(int hash) {
        boolean evicted = false;
        Segment target = this.segmentFor(hash);
        for (Segment s : this.segments) {
            if (s == target) continue;
            Lock l = s.writeLock();
            l.lock();
            try {
                evicted |= s.shrink();
            }
            finally {
                l.unlock();
            }
        }
        return evicted;
    }
}

