/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.object;

import com.terracottatech.frs.object.ObjectManagerEntry;
import com.terracottatech.frs.object.ObjectManagerSegment;
import com.terracottatech.frs.object.ObjectManagerStripe;

public abstract class AbstractObjectManagerStripe<I, K, V>
implements ObjectManagerStripe<I, K, V> {
    @Override
    public Long getLowestLsn() {
        Long lowest = null;
        for (ObjectManagerSegment segment : this.getSegments()) {
            Long firstLsn = segment.getLowestLsn();
            if (firstLsn == null || lowest != null && firstLsn >= lowest) continue;
            lowest = firstLsn;
        }
        return lowest;
    }

    @Override
    public Long getLsn(K key) {
        int hash = this.extractHashCode(key);
        return this.getSegmentFor(hash, key).getLsn(hash, key);
    }

    @Override
    public void put(K key, V value, long lsn) {
        int hash = this.extractHashCode(key);
        this.getSegmentFor(hash, key).put(hash, key, value, lsn);
    }

    @Override
    public void remove(K key) {
        int hash = this.extractHashCode(key);
        this.getSegmentFor(hash, key).remove(hash, key);
    }

    @Override
    public void replayPut(K key, V value, long lsn) {
        int hash = this.extractHashCode(key);
        this.getSegmentFor(hash, key).replayPut(hash, key, value, lsn);
    }

    @Override
    public void updateLsn(ObjectManagerEntry<I, K, V> entry, long newLsn) {
        int hash = this.extractHashCode(entry.getKey());
        this.getSegmentFor(hash, entry.getKey()).updateLsn(hash, entry, newLsn);
    }

    @Override
    public void releaseCompactionEntry(ObjectManagerEntry<I, K, V> entry) {
        int hash = this.extractHashCode(entry.getKey());
        this.getSegmentFor(hash, entry.getKey()).releaseCompactionEntry(entry);
    }

    @Override
    public long size() {
        long total = 0L;
        for (ObjectManagerSegment s : this.getSegments()) {
            total += s.size();
        }
        return total;
    }

    @Override
    public long sizeInBytes() {
        long size = 0L;
        for (ObjectManagerSegment segment : this.getSegments()) {
            size += segment.sizeInBytes();
        }
        return size;
    }

    protected abstract ObjectManagerSegment<I, K, V> getSegmentFor(int var1, K var2);

    protected abstract int extractHashCode(K var1);
}

