/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.object;

import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.object.ObjectManagerEntry;
import com.terracottatech.frs.object.ObjectManagerSegment;
import com.terracottatech.frs.object.ObjectManagerStripe;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class AbstractObjectManager<I, K, V>
implements ObjectManager<I, K, V> {
    private final Object compactionMutex = new Object();
    private final ConcurrentLinkedQueue<ObjectManagerSegment<I, K, V>> compactionTargets = new ConcurrentLinkedQueue();
    private volatile long latestLowestLsn = -1L;

    @Override
    public long getLowestLsn() {
        return this.latestLowestLsn;
    }

    @Override
    public long getLsn(I id, K key) {
        Long l = this.getStripeFor(id).getLsn(key);
        return l == null ? -1L : l;
    }

    @Override
    public void put(I id, K key, V value, long lsn) {
        this.getStripeFor(id).put(key, value, lsn);
    }

    @Override
    public void delete(I id) {
        this.getStripeFor(id).delete();
    }

    @Override
    public void remove(I id, K key) {
        this.getStripeFor(id).remove(key);
    }

    @Override
    public void replayPut(I id, K key, V value, long lsn) {
        this.getStripeFor(id).replayPut(key, value, lsn);
    }

    @Override
    public void updateLsn(ObjectManagerEntry<I, K, V> entry, long newLsn) {
        this.getStripeFor(entry.getId()).updateLsn(entry, newLsn);
    }

    @Override
    public ObjectManagerEntry<I, K, V> acquireCompactionEntry(long ceilingLsn) {
        ObjectManagerSegment<I, K, V> stripe = this.getCompactionSource();
        if (stripe == null) {
            return null;
        }
        return stripe.acquireCompactionEntry(ceilingLsn);
    }

    @Override
    public void releaseCompactionEntry(ObjectManagerEntry<I, K, V> entry) {
        this.getStripeFor(entry.getId()).releaseCompactionEntry(entry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ObjectManagerSegment<I, K, V> getCompactionSource() {
        ObjectManagerSegment<I, K, V> source = this.compactionTargets.poll();
        if (source == null) {
            Object object = this.compactionMutex;
            synchronized (object) {
                if (this.compactionTargets.isEmpty()) {
                    for (ObjectManagerStripe<I, K, V> stripe : this.getStripes()) {
                        this.compactionTargets.addAll(stripe.getSegments());
                    }
                }
                return this.compactionTargets.poll();
            }
        }
        return source;
    }

    @Override
    public void updateLowestLsn() {
        long lowest = -1L;
        for (ObjectManagerStripe<I, K, V> stripe : this.getStripes()) {
            Long lowestInStripe = stripe.getLowestLsn();
            if (lowestInStripe == null || lowest >= 0L && lowestInStripe >= lowest) continue;
            lowest = lowestInStripe;
        }
        this.latestLowestLsn = lowest;
    }

    @Override
    public long size() {
        long size = 0L;
        for (ObjectManagerStripe<I, K, V> stripe : this.getStripes()) {
            size += stripe.size();
        }
        return size;
    }

    @Override
    public long sizeInBytes() {
        long size = 0L;
        for (ObjectManagerStripe<I, K, V> stripe : this.getStripes()) {
            size += stripe.sizeInBytes();
        }
        return size;
    }

    protected abstract ObjectManagerStripe<I, K, V> getStripeFor(I var1);

    protected abstract Collection<ObjectManagerStripe<I, K, V>> getStripes();
}

