/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.log;

import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.log.BufferListWrapper;
import com.terracottatech.frs.log.FormatException;
import com.terracottatech.frs.log.LogManager;
import com.terracottatech.frs.log.LogRecord;
import com.terracottatech.frs.log.LogRecordImpl;
import com.terracottatech.frs.log.LogRegionFactory;
import com.terracottatech.frs.log.Signature;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.Adler32;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogRegionPacker
implements LogRegionFactory<LogRecord> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogManager.class);
    static final int LOG_RECORD_HEADER_SIZE = 18;
    static final int LOG_REGION_HEADER_SIZE = 20;
    private int tuningMax = 10;
    private static final short REGION_VERSION = 2;
    private static final byte[] REGION_FORMAT = "NF".getBytes();
    private static final short LR_FORMAT = 2;
    private static final String BAD_CHECKSUM = "bad checksum";
    private final Signature cType;

    public LogRegionPacker(Signature sig) {
        this.cType = sig;
        assert (this.cType == Signature.NONE || this.cType == Signature.ADLER32);
    }

    @Override
    public Chunk pack(Iterable<LogRecord> payload) {
        return this.writeRecords(payload);
    }

    public static List<LogRecord> unpack(Signature type, Chunk data) throws FormatException {
        long headCheck = LogRegionPacker.readRegionHeader(data);
        LinkedList<LogRecord> queue = new LinkedList<LogRecord>();
        while (data.hasRemaining()) {
            queue.add(LogRegionPacker.readRecord(headCheck, data));
        }
        return queue;
    }

    public static List<LogRecord> unpackInReverse(Signature type, Chunk data) throws FormatException {
        long headCheck = LogRegionPacker.readRegionHeader(data);
        LinkedList<LogRecord> queue = new LinkedList<LogRecord>();
        while (data.hasRemaining()) {
            queue.push(LogRegionPacker.readRecord(headCheck, data));
        }
        return queue;
    }

    @Override
    public List<LogRecord> unpack(Chunk data) throws FormatException {
        long headCheck = LogRegionPacker.readRegionHeader(data);
        ArrayList<LogRecord> queue = new ArrayList<LogRecord>();
        while (data.hasRemaining()) {
            queue.add(LogRegionPacker.readRecord(headCheck, data));
        }
        return queue;
    }

    protected Chunk writeRecords(Iterable<LogRecord> records) {
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>(this.tuningMax);
        int count = 0;
        ByteBuffer headers = ByteBuffer.allocate(18452);
        headers.limit(20);
        ByteBuffer regionHeader = headers.slice();
        headers.position(headers.limit()).limit(headers.capacity());
        buffers.add(regionHeader);
        for (LogRecord record : records) {
            if (headers.remaining() < 18) {
                headers = ByteBuffer.allocate(18432);
            }
            headers.limit(headers.position() + 18);
            ByteBuffer rhead = headers.slice();
            headers.position(headers.limit()).limit(headers.capacity());
            buffers.add(rhead);
            ByteBuffer[] payload = record.getPayload();
            long len = 0L;
            for (ByteBuffer bb : payload) {
                len += (long)bb.remaining();
                buffers.add(bb);
                ++count;
            }
            this.formRecordHeader(len, record.getLsn(), rhead);
            rhead.flip();
        }
        this.formRegionHeader(this.doChecksum() ? LogRegionPacker.checksum(buffers.subList(1, buffers.size())) : 0L, regionHeader);
        this.tuningMax += (int)Math.round((double)(count - this.tuningMax) * 0.1);
        return new BufferListWrapper(buffers);
    }

    protected boolean doChecksum() {
        return this.cType == Signature.ADLER32;
    }

    private static long readRegionHeader(Chunk data) throws FormatException {
        long value;
        short region = data.getShort();
        long check = data.getLong();
        long check2 = data.getLong();
        byte[] rf = new byte[2];
        data.get(rf);
        if (check != check2) {
            throw new FormatException("log region has mismatched checksums");
        }
        if (region != 2) {
            throw new FormatException("log region has an unrecognized version code");
        }
        if (check != 0L && check != (value = LogRegionPacker.checksum(Arrays.asList(data.getBuffers())))) {
            throw new FormatException("Adler32 checksum is not correct", check, value, data.length());
        }
        return 0L;
    }

    protected int formRegionHeader(long checksum, ByteBuffer header) {
        header.clear();
        header.putShort((short)2);
        header.putLong(checksum);
        header.putLong(checksum);
        header.put(REGION_FORMAT);
        header.flip();
        return header.remaining();
    }

    protected int formRecordHeader(long length, long lsn, ByteBuffer header) {
        header.putShort((short)2);
        header.putLong(lsn);
        header.putLong(length);
        return header.remaining();
    }

    protected static long checksum(Iterable<ByteBuffer> bufs) {
        Adler32 checksum = new Adler32();
        byte[] temp = null;
        for (ByteBuffer buf : bufs) {
            if (buf.hasArray()) {
                checksum.update(buf.array(), buf.arrayOffset() + buf.position(), buf.limit() - buf.position());
                continue;
            }
            if (temp == null) {
                temp = new byte[8192];
            }
            buf.mark();
            while (buf.hasRemaining()) {
                int fetch = buf.remaining() > temp.length ? temp.length : buf.remaining();
                buf.get(temp, 0, fetch);
                checksum.update(temp, 0, fetch);
            }
            buf.reset();
        }
        return checksum.getValue();
    }

    protected static byte[] md5(Iterable<ByteBuffer> bufs) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            for (ByteBuffer buf : bufs) {
                if (buf.hasArray()) {
                    md5.update(buf.array(), buf.arrayOffset() + buf.position(), buf.limit() - buf.position());
                    continue;
                }
                buf.mark();
                md5.update(buf);
                buf.reset();
            }
            return md5.digest();
        }
        catch (NoSuchAlgorithmException no) {
            LOGGER.error("MD5 checksumming selected but the package is not available", (Throwable)no);
            return new byte[16];
        }
    }

    private static LogRecord readRecord(long lowestLsn, Chunk buffer) throws FormatException {
        short format = buffer.getShort();
        long lsn = buffer.getLong();
        long len = buffer.getLong();
        if (format != 2) {
            throw new FormatException("log record has an unrecognized version code");
        }
        ByteBuffer[] payload = buffer.getBuffers(len);
        LogRecordImpl record = new LogRecordImpl(lowestLsn, payload, null);
        record.updateLsn(lsn);
        return record;
    }
}

