/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.log;

import com.terracottatech.frs.log.LSNEventListener;
import com.terracottatech.frs.log.LogRecord;
import java.nio.ByteBuffer;

public class LogRecordImpl
implements LogRecord {
    private long lowestLsn;
    private long lsn;
    private final ByteBuffer[] payload;
    private final LSNEventListener listener;

    public LogRecordImpl(long lowestLsn, ByteBuffer[] buffers, LSNEventListener listener) {
        this.lowestLsn = lowestLsn;
        this.payload = buffers;
        this.listener = listener;
    }

    @Override
    public long getLowestLsn() {
        return this.lowestLsn;
    }

    @Override
    public void setLowestLsn(long lsn) {
        this.lowestLsn = lsn;
    }

    @Override
    public long getLsn() {
        return this.lsn;
    }

    @Override
    public ByteBuffer[] getPayload() {
        ByteBuffer[] bufs = new ByteBuffer[this.payload.length];
        for (int x = 0; x < this.payload.length; ++x) {
            bufs[x] = this.payload[x].asReadOnlyBuffer();
        }
        return bufs;
    }

    @Override
    public void updateLsn(long lsn) {
        this.lsn = lsn;
        if (this.listener != null) {
            this.listener.record(lsn);
        }
    }

    public String toString() {
        return "LogRecordImpl{lowestLsn=" + this.lowestLsn + ", lsn=" + this.lsn + '}';
    }
}

