/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.io.nio;

import com.terracottatech.frs.io.BufferSource;
import com.terracottatech.frs.io.Chunk;
import com.terracottatech.frs.io.Direction;
import com.terracottatech.frs.io.FileBuffer;
import com.terracottatech.frs.io.IOManager;
import com.terracottatech.frs.io.WrappingChunk;
import com.terracottatech.frs.io.nio.HeaderException;
import com.terracottatech.frs.io.nio.IntegrityReadbackStrategy;
import com.terracottatech.frs.io.nio.MappedReadbackStrategy;
import com.terracottatech.frs.io.nio.NIOSegmentList;
import com.terracottatech.frs.io.nio.NIOStreamImpl;
import com.terracottatech.frs.io.nio.ReadbackStrategy;
import com.terracottatech.frs.io.nio.SegmentHeaders;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NIOSegmentImpl {
    static final int FILE_HEADER_SIZE = 42;
    private static final String LOCKED_FILE_ACCESS = "could not obtain file lock";
    private static final short IMPL_NUMBER = 2;
    private final NIOStreamImpl parent;
    private final int segNum;
    private final File src;
    private FileBuffer buffer;
    private ByteBuffer memoryBuffer;
    private BufferSource bufferSource;
    private ReadbackStrategy strategy;
    private boolean forWriting = false;
    private List<Long> writeJumpList;
    private long lowestMarker;
    private long minMarker;
    private long maxMarker;
    private UUID streamId;
    private static final Logger LOGGER = LoggerFactory.getLogger(IOManager.class);

    NIOSegmentImpl(NIOStreamImpl p, File file) {
        this.parent = p;
        this.src = file;
        this.segNum = NIOSegmentList.convertSegmentNumber(file);
    }

    File getFile() {
        return this.src;
    }

    private FileBuffer createFileBuffer(FileChannel segment, int bufferSize, BufferSource source) throws IOException {
        assert (this.memoryBuffer == null);
        this.bufferSource = source;
        this.memoryBuffer = source.getBuffer(bufferSize);
        if (this.memoryBuffer == null) {
            LOGGER.warn("direct memory unavailable. Allocating on heap.  Fix configuration for more direct memory. request: " + bufferSize);
            this.memoryBuffer = ByteBuffer.allocate(0x100000);
        }
        FileBuffer created = this.parent != null && this.parent.getBufferBuilder() != null ? this.parent.getBufferBuilder().createBuffer(segment, this.memoryBuffer) : new FileBuffer(segment, this.memoryBuffer);
        return created;
    }

    NIOSegmentImpl openForHeader(BufferSource reader) throws IOException, HeaderException {
        long fileSize = 0L;
        FileChannel segment = new FileInputStream(this.src).getChannel();
        fileSize = segment.size();
        if (fileSize < 42L) {
            segment.close();
            throw new HeaderException("bad header", this);
        }
        this.buffer = this.createFileBuffer(segment, 42, reader);
        this.buffer.read(1);
        this.readFileHeader(this.buffer);
        return this;
    }

    NIOSegmentImpl openForReading(BufferSource reader) throws IOException, HeaderException {
        long fileSize = 0L;
        FileChannel segment = new FileInputStream(this.src).getChannel();
        fileSize = segment.size();
        if (fileSize < 42L) {
            throw new HeaderException("bad header", this);
        }
        if (this.buffer != null) {
            this.buffer.close();
            this.buffer = null;
        }
        MappedByteBuffer buf = segment.map(FileChannel.MapMode.READ_ONLY, 0L, (int)this.src.length());
        buf.load();
        this.readFileHeader(new WrappingChunk(buf));
        this.strategy = new MappedReadbackStrategy(buf, Direction.REVERSE);
        return this;
    }

    String getStrategyDebug() {
        if (this.strategy == null) {
            return "";
        }
        return this.strategy.getClass().getName();
    }

    private void readFileHeader(Chunk readBuffer) throws IOException, HeaderException {
        if (readBuffer.remaining() < 42L) {
            throw new IOException("file buffering size too small");
        }
        byte[] code = new byte[4];
        if (readBuffer.get(code) != 4) {
            throw new HeaderException("empty file", this);
        }
        if (!SegmentHeaders.LOG_FILE.validate(code)) {
            throw new HeaderException("file header is corrupted " + new String(code), this);
        }
        short impl = readBuffer.getShort();
        int checkSeg = readBuffer.getInt();
        if (this.segNum != checkSeg) {
            throw new HeaderException("the filename does not match the internal file structure", this);
        }
        if (impl != 2) {
            throw new HeaderException("unknown implementation number", this);
        }
        this.streamId = new UUID(readBuffer.getLong(), readBuffer.getLong());
        this.lowestMarker = readBuffer.getLong();
        this.minMarker = readBuffer.getLong();
    }

    NIOSegmentImpl openForWriting(BufferSource pool) throws IOException {
        if (this.src.length() > 0L) {
            throw new IOException("bad access");
        }
        FileChannel segment = new FileOutputStream(this.src).getChannel();
        this.forWriting = true;
        while (this.buffer == null) {
            this.buffer = this.createFileBuffer(segment, 524288, pool);
        }
        this.writeJumpList = new ArrayList<Long>();
        return this;
    }

    void insertFileHeader(long lowestMarker, long marker) throws IOException {
        this.lowestMarker = lowestMarker;
        this.minMarker = marker;
        if (lowestMarker < 99L || marker < 99L) {
            throw new AssertionError((Object)"bad markers");
        }
        this.streamId = this.parent.getStreamId();
        this.buffer.clear();
        this.buffer.put(SegmentHeaders.LOG_FILE.getBytes());
        this.buffer.putShort((short)2);
        this.buffer.putInt(this.segNum);
        this.buffer.putLong(this.streamId.getMostSignificantBits());
        this.buffer.putLong(this.streamId.getLeastSignificantBits());
        this.buffer.putLong(this.lowestMarker);
        this.buffer.putLong(this.minMarker);
        this.buffer.write(1);
    }

    private long piggybackBufferOptimization(ByteBuffer used) throws IOException {
        long amt = used.remaining();
        int estart = used.limit();
        int position = used.position() - 12;
        used.position(position);
        used.limit(estart + 16 + 4);
        used.putInt(position, SegmentHeaders.CHUNK_START.getIntValue());
        used.putLong(position + 4, amt);
        used.putLong(estart, amt);
        used.putLong(estart + 8, this.maxMarker);
        used.putInt(estart + 16, SegmentHeaders.FILE_CHUNK.getIntValue());
        amt = this.buffer.writeFully(used);
        this.writeJumpList.add(this.buffer.offset());
        return amt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long append(Chunk c, long maxMarker) throws IOException {
        int writeCount = 0;
        this.buffer.clear();
        this.maxMarker = maxMarker;
        ByteBuffer[] raw = c.getBuffers();
        if (raw.length == 1 && !raw[0].isReadOnly() && raw[0].isDirect() && raw[0].position() > 12 && raw[0].capacity() - raw[0].limit() > 20) {
            return this.piggybackBufferOptimization(raw[0]);
        }
        this.buffer.clear();
        this.buffer.partition(12);
        long amt = c.remaining();
        this.buffer.put(SegmentHeaders.CHUNK_START.getBytes());
        this.buffer.putLong(amt);
        this.buffer.insert(raw, 1, false);
        this.buffer.putLong(amt);
        this.buffer.putLong(maxMarker);
        this.buffer.put(SegmentHeaders.FILE_CHUNK.getBytes());
        writeCount = raw.length + 2;
        try {
            long l = this.buffer.write(writeCount);
            return l;
        }
        finally {
            this.writeJumpList.add(this.buffer.offset());
        }
    }

    void prepareForClose() throws IOException {
        if (this.buffer != null) {
            this.buffer.clear();
            this.buffer.put(SegmentHeaders.CLOSE_FILE.getBytes());
            this.writeJumpList(this.buffer);
            this.buffer.write(1);
        }
    }

    long close() throws IOException {
        long totalWrite = 0L;
        if (this.bufferSource != null) {
            this.bufferSource.returnBuffer(this.memoryBuffer);
            this.bufferSource = null;
            this.memoryBuffer = null;
        }
        if (this.buffer == null || !this.buffer.isOpen()) {
            return 0L;
        }
        if (this.forWriting) {
            totalWrite = this.buffer.getTotal();
            this.buffer.sync();
        }
        this.buffer.close();
        this.buffer = null;
        return totalWrite;
    }

    private void writeJumpList(FileBuffer target) throws IOException {
        target.clear();
        target.put(SegmentHeaders.CLOSE_FILE.getBytes());
        for (long jump : this.writeJumpList) {
            if (target.remaining() < 14L) {
                target.write(1);
                target.clear();
            }
            target.putLong(jump);
        }
        if (this.writeJumpList.size() < Short.MAX_VALUE) {
            target.putShort((short)this.writeJumpList.size());
        } else {
            target.putShort((short)-1);
        }
        target.put(SegmentHeaders.JUMP_LIST.getBytes());
    }

    public long fsync() throws IOException {
        long pos = this.buffer.offset();
        this.buffer.sync();
        return pos;
    }

    public int getSegmentId() {
        return this.segNum;
    }

    UUID getStreamId() {
        return this.streamId;
    }

    long getBaseMarker() {
        return this.minMarker;
    }

    long getMinimumMarker() {
        return this.lowestMarker;
    }

    long getMaximumMarker() {
        return this.maxMarker;
    }

    public boolean isClosed() {
        return this.buffer == null;
    }

    public boolean wasProperlyClosed() throws IOException {
        if (this.strategy != null && this.strategy.isConsistent()) {
            return true;
        }
        if (this.buffer.size() < 46L) {
            return false;
        }
        this.buffer.clear();
        this.buffer.position(this.buffer.size() - (long)this.buffer.capacity()).read(1);
        int fileEnd = this.buffer.getInt(this.buffer.remaining() - 4L);
        if (SegmentHeaders.CLOSE_FILE.validate(fileEnd)) {
            return true;
        }
        return SegmentHeaders.JUMP_LIST.validate(fileEnd);
    }

    public Chunk next(Direction dir) throws IOException {
        if (this.strategy.hasMore(dir)) {
            return this.strategy.iterate(dir);
        }
        throw new IOException("segment bounds");
    }

    public boolean hasMore(Direction dir) throws IOException {
        return this.strategy.hasMore(dir);
    }

    public long length() throws IOException {
        return this.src.length();
    }

    public long position() throws IOException {
        return this.buffer == null ? 0L : this.buffer.position();
    }

    public void limit(long pos) throws IOException {
        this.buffer.clear();
        this.buffer.position(pos - 4L);
        this.buffer.partition(4);
        this.buffer.read(1);
        byte[] code = new byte[4];
        this.buffer.get(code);
        if (!SegmentHeaders.FILE_CHUNK.validate(code)) {
            throw new IOException("bad truncation " + new String(code));
        }
        FileChannel fc = new FileOutputStream(this.src, true).getChannel();
        fc.truncate(pos);
        fc.position(pos);
        ByteBuffer close = ByteBuffer.allocate(4096);
        FileBuffer target = this.parent.getBufferBuilder() != null ? this.parent.getBufferBuilder().createBuffer(fc, close) : new FileBuffer(fc, close);
        target.put(SegmentHeaders.CLOSE_FILE.getBytes());
        this.writeJumpList(target);
        target.write(1);
        fc.force(true);
        fc.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean last() throws IOException {
        IntegrityReadbackStrategy find = new IntegrityReadbackStrategy(this.buffer);
        int count = 0;
        try {
            while (find.hasMore(Direction.FORWARD)) {
                try {
                    find.iterate(Direction.FORWARD);
                    ++count;
                }
                catch (IOException ioe) {
                    // empty catch block
                    break;
                }
            }
        }
        finally {
            this.buffer.clear();
            this.maxMarker = find.getLastValidMarker();
            this.buffer.position(find.getLastValidPosition());
            this.writeJumpList = find.getJumpList();
        }
        if (count == 0) {
            return false;
        }
        if (!find.wasClosed()) {
            this.limit(this.position());
        }
        return true;
    }
}

