/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.compaction;

import com.terracottatech.frs.compaction.CompactionPolicy;
import com.terracottatech.frs.config.Configuration;
import com.terracottatech.frs.config.FrsProperty;
import com.terracottatech.frs.io.IOManager;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.object.ObjectManagerEntry;

public class SizeBasedCompactionPolicy
implements CompactionPolicy {
    private final IOManager ioManager;
    private final ObjectManager<?, ?, ?> objectManager;
    private final double sizeThreshold;
    private final double compactionPercentage;
    private boolean isCompacting;
    private long entriesToCompact;

    public SizeBasedCompactionPolicy(IOManager ioManager, ObjectManager<?, ?, ?> objectManager, Configuration configuration) {
        this.ioManager = ioManager;
        this.objectManager = objectManager;
        this.sizeThreshold = configuration.getDouble(FrsProperty.COMPACTOR_SIZEBASED_THRESHOLD);
        this.compactionPercentage = configuration.getDouble(FrsProperty.COMPACTOR_SIZEBASED_AMOUNT);
    }

    @Override
    public boolean shouldCompact() {
        try {
            double ratio = (double)this.objectManager.sizeInBytes() / (double)this.ioManager.getStatistics().getLiveSize();
            return ratio <= this.sizeThreshold;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get data size.", e);
        }
    }

    @Override
    public void startedCompacting() {
        assert (!this.isCompacting);
        this.isCompacting = true;
        this.entriesToCompact = (long)((double)this.objectManager.size() * this.compactionPercentage);
    }

    @Override
    public boolean compacted(ObjectManagerEntry<?, ?, ?> entry) {
        assert (this.isCompacting);
        return this.entriesToCompact-- > 0L;
    }

    @Override
    public void stoppedCompacting() {
        assert (this.isCompacting);
        this.isCompacting = false;
    }
}

