/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.compaction;

import com.terracottatech.frs.compaction.CompactionPolicy;
import com.terracottatech.frs.config.Configuration;
import com.terracottatech.frs.config.FrsProperty;
import com.terracottatech.frs.log.LogManager;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.object.ObjectManagerEntry;

public class LSNGapCompactionPolicy
implements CompactionPolicy {
    private final ObjectManager<?, ?, ?> objectManager;
    private final LogManager logManager;
    private final double minLoad;
    private final double maxLoad;
    private long compactingCurrentLsn;
    private long compactingLiveSize;
    private long compactedCount;
    private boolean isCompacting = false;

    public LSNGapCompactionPolicy(ObjectManager<?, ?, ?> objectManager, LogManager logManager, Configuration configuration) {
        this.objectManager = objectManager;
        this.logManager = logManager;
        this.minLoad = configuration.getDouble(FrsProperty.COMPACTOR_LSNGAP_MIN_LOAD);
        this.maxLoad = configuration.getDouble(FrsProperty.COMPACTOR_LSNGAP_MAX_LOAD);
    }

    protected double calculateRatio(long liveEntries, long totalEntries) {
        return (double)liveEntries / (double)totalEntries;
    }

    @Override
    public boolean shouldCompact() {
        assert (!this.isCompacting);
        double ratio = this.calculateRatio(this.objectManager.size(), this.logManager.currentLsn() - this.objectManager.getLowestLsn());
        return ratio <= this.minLoad;
    }

    @Override
    public void startedCompacting() {
        assert (!this.isCompacting);
        this.compactingCurrentLsn = this.logManager.currentLsn();
        this.compactedCount = 0L;
        this.compactingLiveSize = this.objectManager.size();
        this.isCompacting = true;
    }

    @Override
    public boolean compacted(ObjectManagerEntry<?, ?, ?> entry) {
        assert (this.isCompacting);
        ++this.compactedCount;
        double ratio = this.calculateRatio(this.compactingLiveSize, this.compactingCurrentLsn + this.compactedCount - entry.getLsn());
        return ratio <= this.maxLoad;
    }

    @Override
    public void stoppedCompacting() {
        assert (this.isCompacting);
        this.isCompacting = false;
    }
}

