/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.compaction;

import com.terracottatech.frs.RestartStoreException;
import com.terracottatech.frs.TransactionException;
import com.terracottatech.frs.action.ActionManager;
import com.terracottatech.frs.action.NullAction;
import com.terracottatech.frs.compaction.CompactionAction;
import com.terracottatech.frs.compaction.CompactionPolicy;
import com.terracottatech.frs.compaction.Compactor;
import com.terracottatech.frs.compaction.LSNGapCompactionPolicy;
import com.terracottatech.frs.compaction.NoCompactionPolicy;
import com.terracottatech.frs.compaction.SizeBasedCompactionPolicy;
import com.terracottatech.frs.config.Configuration;
import com.terracottatech.frs.config.FrsProperty;
import com.terracottatech.frs.io.IOManager;
import com.terracottatech.frs.log.LogManager;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.object.ObjectManagerEntry;
import com.terracottatech.frs.transaction.TransactionManager;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactorImpl
implements Compactor {
    private static final Logger LOGGER = LoggerFactory.getLogger(Compactor.class);
    private final ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager;
    private final TransactionManager transactionManager;
    private final ActionManager actionManager;
    private final LogManager logManager;
    private final Semaphore compactionCondition = new Semaphore(0);
    private final AtomicBoolean alive = new AtomicBoolean();
    private final CompactionPolicy policy;
    private final long runIntervalSeconds;
    private final long compactActionThrottle;
    private final int startThreshold;
    private CompactorThread compactorThread;

    CompactorImpl(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, TransactionManager transactionManager, ActionManager actionManager, LogManager logManager, CompactionPolicy policy, long runIntervalSeconds, long compactActionThrottle, int startThreshold) {
        this.objectManager = objectManager;
        this.transactionManager = transactionManager;
        this.actionManager = actionManager;
        this.logManager = logManager;
        this.policy = policy;
        this.runIntervalSeconds = runIntervalSeconds;
        this.compactActionThrottle = compactActionThrottle;
        this.startThreshold = startThreshold;
    }

    public CompactorImpl(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, TransactionManager transactionManager, LogManager logManager, IOManager ioManager, Configuration configuration, ActionManager actionManager) throws RestartStoreException {
        this(objectManager, transactionManager, actionManager, logManager, CompactorImpl.getPolicy(configuration, objectManager, logManager, ioManager), configuration.getLong(FrsProperty.COMPACTOR_RUN_INTERVAL), configuration.getLong(FrsProperty.COMPACTOR_THROTTLE_AMOUNT), configuration.getInt(FrsProperty.COMPACTOR_START_THRESHOLD));
    }

    private static CompactionPolicy getPolicy(Configuration configuration, ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, LogManager logManager, IOManager ioManager) throws RestartStoreException {
        String policy = configuration.getString(FrsProperty.COMPACTOR_POLICY);
        if ("LSNGapCompactionPolicy".equals(policy)) {
            return new LSNGapCompactionPolicy(objectManager, logManager, configuration);
        }
        if ("SizeBasedCompactionPolicy".equals(policy)) {
            return new SizeBasedCompactionPolicy(ioManager, objectManager, configuration);
        }
        if ("NoCompactionPolicy".equals(policy)) {
            LOGGER.warn("Compactor policy is set to 'NoCompactionPolicy'. No compaction will be done.");
            return new NoCompactionPolicy();
        }
        throw new RestartStoreException("Unknown compaction policy " + policy);
    }

    @Override
    public void startup() {
        if (this.alive.compareAndSet(false, true)) {
            this.compactorThread = new CompactorThread();
            this.compactorThread.start();
        }
    }

    @Override
    public void shutdown() throws InterruptedException {
        if (this.alive.compareAndSet(true, false)) {
            this.compactorThread.interrupt();
            this.compactorThread.join();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compact() throws TransactionException, InterruptedException, ExecutionException {
        this.compactionCondition.drainPermits();
        this.policy.startedCompacting();
        long ceilingLsn = this.transactionManager.getLowestOpenTransactionLsn();
        long liveSize = this.objectManager.size();
        long compactedCount = 0L;
        int acquireRetries = 0;
        while (compactedCount < liveSize) {
            ObjectManagerEntry<ByteBuffer, ByteBuffer, ByteBuffer> compactionEntry = this.objectManager.acquireCompactionEntry(ceilingLsn);
            if (compactionEntry != null) {
                acquireRetries = 0;
                ++compactedCount;
                try {
                    CompactionAction compactionAction = new CompactionAction(this.objectManager, compactionEntry);
                    Future<Void> written = this.actionManager.happened(compactionAction);
                    compactionAction.updateObjectManager();
                    if (compactedCount % this.compactActionThrottle == 0L) {
                        written.get();
                    }
                    if (this.policy.compacted(compactionEntry)) continue;
                    break;
                }
                finally {
                    this.objectManager.releaseCompactionEntry(compactionEntry);
                    continue;
                }
            }
            if (++acquireRetries < 10) continue;
            acquireRetries = 0;
            ++compactedCount;
        }
        this.objectManager.updateLowestLsn();
        this.policy.stoppedCompacting();
    }

    @Override
    public void generatedGarbage() {
        this.compactionCondition.release();
    }

    @Override
    public void compactNow() {
        this.compactionCondition.release(this.startThreshold);
    }

    private class CompactorThread
    extends Thread {
        CompactorThread() {
            this.setDaemon(true);
            this.setName("CompactorThread");
        }

        @Override
        public void run() {
            while (CompactorImpl.this.alive.get()) {
                try {
                    CompactorImpl.this.compactionCondition.tryAcquire(CompactorImpl.this.startThreshold, CompactorImpl.this.runIntervalSeconds, TimeUnit.SECONDS);
                    if (!CompactorImpl.this.alive.get()) {
                        return;
                    }
                    CompactorImpl.this.objectManager.updateLowestLsn();
                    if (CompactorImpl.this.policy.shouldCompact()) {
                        CompactorImpl.this.compact();
                    }
                    CompactorImpl.this.actionManager.happened(new NullAction()).get();
                    CompactorImpl.this.logManager.updateLowestLsn(CompactorImpl.this.objectManager.getLowestLsn());
                    CompactorImpl.this.actionManager.happened(new NullAction()).get();
                }
                catch (InterruptedException e) {
                    LOGGER.info("Compactor thread interrupted, shutting down.");
                    return;
                }
                catch (Exception e) {
                    LOGGER.error("Error performing compaction.", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

