/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.compaction;

import com.terracottatech.frs.PutAction;
import com.terracottatech.frs.action.Action;
import com.terracottatech.frs.action.ActionCodec;
import com.terracottatech.frs.action.ActionFactory;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.object.ObjectManagerEntry;
import java.nio.ByteBuffer;

class CompactionAction
extends PutAction {
    public static final ActionFactory<ByteBuffer, ByteBuffer, ByteBuffer> FACTORY = new ActionFactory<ByteBuffer, ByteBuffer, ByteBuffer>(){

        @Override
        public Action create(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, ActionCodec codec, ByteBuffer[] buffers) {
            return PutAction.FACTORY.create(objectManager, codec, buffers);
        }
    };
    private final ObjectManagerEntry<ByteBuffer, ByteBuffer, ByteBuffer> entry;
    private final ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager;
    private Long lsn;

    CompactionAction(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, ObjectManagerEntry<ByteBuffer, ByteBuffer, ByteBuffer> entry) {
        super(objectManager, null, entry.getId(), entry.getKey(), entry.getValue(), entry.getLsn());
        this.objectManager = objectManager;
        this.entry = entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void record(long lsn) {
        CompactionAction compactionAction = this;
        synchronized (compactionAction) {
            this.lsn = lsn;
            this.notifyAll();
        }
    }

    synchronized void updateObjectManager() throws InterruptedException {
        while (this.lsn == null) {
            this.wait();
        }
        this.objectManager.updateLsn(this.entry, this.lsn);
    }

    @Override
    public void replay(long lsn) {
        throw new UnsupportedOperationException("Compaction actions can't be replayed.");
    }
}

