/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs.action;

import com.terracottatech.frs.action.Action;
import com.terracottatech.frs.action.ActionCodec;
import com.terracottatech.frs.action.ActionManager;
import com.terracottatech.frs.log.LogManager;
import com.terracottatech.frs.log.LogRecord;
import com.terracottatech.frs.log.LogRecordFactory;
import com.terracottatech.frs.object.ObjectManager;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;

public class ActionManagerImpl
implements ActionManager {
    private final LogManager logManager;
    private final ObjectManager<?, ?, ?> objectManager;
    private final ActionCodec actionCodec;
    private final LogRecordFactory logRecordFactory;

    public ActionManagerImpl(LogManager logManager, ObjectManager<?, ?, ?> objectManager, ActionCodec actionCodec, LogRecordFactory logRecordFactory) {
        this.logManager = logManager;
        this.objectManager = objectManager;
        this.actionCodec = actionCodec;
        this.logRecordFactory = logRecordFactory;
    }

    private LogRecord wrapAction(Action action) {
        long lowestLsn = this.objectManager.getLowestLsn();
        ByteBuffer[] payload = this.actionCodec.encode(action);
        return this.logRecordFactory.createLogRecord(lowestLsn, payload, action);
    }

    @Override
    public Future<Void> syncHappened(Action action) {
        return this.logManager.appendAndSync(this.wrapAction(action));
    }

    @Override
    public Future<Void> happened(Action action) {
        return this.logManager.append(this.wrapAction(action));
    }

    @Override
    public Action extract(LogRecord record) {
        return this.actionCodec.decode(record.getPayload());
    }
}

