/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.frs;

import com.terracottatech.frs.DeleteAction;
import com.terracottatech.frs.PutAction;
import com.terracottatech.frs.RemoveAction;
import com.terracottatech.frs.RestartStore;
import com.terracottatech.frs.RestartStoreException;
import com.terracottatech.frs.Transaction;
import com.terracottatech.frs.TransactionException;
import com.terracottatech.frs.action.Action;
import com.terracottatech.frs.action.ActionManager;
import com.terracottatech.frs.compaction.Compactor;
import com.terracottatech.frs.compaction.CompactorImpl;
import com.terracottatech.frs.config.Configuration;
import com.terracottatech.frs.io.IOManager;
import com.terracottatech.frs.log.LogManager;
import com.terracottatech.frs.object.ObjectManager;
import com.terracottatech.frs.recovery.RecoveryException;
import com.terracottatech.frs.recovery.RecoveryListener;
import com.terracottatech.frs.recovery.RecoveryManagerImpl;
import com.terracottatech.frs.transaction.TransactionHandle;
import com.terracottatech.frs.transaction.TransactionManager;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class RestartStoreImpl
implements RestartStore<ByteBuffer, ByteBuffer, ByteBuffer>,
RecoveryListener {
    private final ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager;
    private final TransactionManager transactionManager;
    private final Compactor compactor;
    private final LogManager logManager;
    private final ActionManager actionManager;
    private final Configuration configuration;
    private volatile State state = State.INIT;

    RestartStoreImpl(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, TransactionManager transactionManager, LogManager logManager, ActionManager actionManager, Compactor compactor, Configuration configuration) {
        this.transactionManager = transactionManager;
        this.objectManager = objectManager;
        this.logManager = logManager;
        this.actionManager = actionManager;
        this.compactor = compactor;
        this.configuration = configuration;
    }

    public RestartStoreImpl(ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer> objectManager, TransactionManager transactionManager, LogManager logManager, ActionManager actionManager, IOManager ioManager, Configuration configuration) throws RestartStoreException {
        this(objectManager, transactionManager, logManager, actionManager, new CompactorImpl(objectManager, transactionManager, logManager, ioManager, configuration, actionManager), configuration);
    }

    @Override
    public synchronized Future<Void> startup() throws InterruptedException, RecoveryException {
        if (this.state != State.INIT && this.state != State.SHUTDOWN) {
            throw new IllegalStateException("Can't startup from state " + (Object)((Object)this.state));
        }
        this.state = State.RECOVERING;
        RecoveryManagerImpl recoveryManager = new RecoveryManagerImpl(this.logManager, this.actionManager, this.configuration);
        return recoveryManager.recover(this);
    }

    @Override
    public synchronized void recovered() {
        if (this.state == State.RECOVERING) {
            this.compactor.startup();
            this.state = State.RUNNING;
        }
    }

    @Override
    public synchronized void shutdown() throws InterruptedException {
        if (this.state != State.SHUTDOWN) {
            this.state = State.SHUTDOWN;
            this.compactor.shutdown();
            this.logManager.shutdown();
        }
    }

    @Override
    public Transaction<ByteBuffer, ByteBuffer, ByteBuffer> beginTransaction(boolean synchronous) {
        this.checkReadyState();
        return new TransactionImpl(synchronous);
    }

    @Override
    public Transaction<ByteBuffer, ByteBuffer, ByteBuffer> beginAutoCommitTransaction(boolean synchronous) {
        this.checkReadyState();
        return new AutoCommitTransaction(synchronous);
    }

    private void checkReadyState() {
        if (this.state != State.RUNNING && this.state != State.RECOVERING) {
            throw new IllegalStateException("RestartStore is not ready for mutations. Current state " + (Object)((Object)this.state));
        }
    }

    private boolean isRecovering() {
        return this.state == State.RECOVERING;
    }

    private class TransactionImpl
    implements Transaction<ByteBuffer, ByteBuffer, ByteBuffer> {
        private final boolean synchronous;
        private final TransactionHandle handle;
        private boolean committed = false;

        TransactionImpl(boolean synchronous) {
            this.handle = RestartStoreImpl.this.transactionManager.begin();
            this.synchronous = synchronous;
        }

        @Override
        public synchronized Transaction<ByteBuffer, ByteBuffer, ByteBuffer> put(ByteBuffer id, ByteBuffer key, ByteBuffer value) {
            RestartStoreImpl.this.checkReadyState();
            this.checkCommitted();
            RestartStoreImpl.this.transactionManager.happened(this.handle, new PutAction((ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer>)RestartStoreImpl.this.objectManager, RestartStoreImpl.this.compactor, id, key, value, RestartStoreImpl.this.isRecovering()));
            return this;
        }

        @Override
        public synchronized Transaction<ByteBuffer, ByteBuffer, ByteBuffer> delete(ByteBuffer id) {
            RestartStoreImpl.this.checkReadyState();
            this.checkCommitted();
            RestartStoreImpl.this.transactionManager.happened(this.handle, new DeleteAction(RestartStoreImpl.this.objectManager, RestartStoreImpl.this.compactor, id, RestartStoreImpl.this.isRecovering()));
            return this;
        }

        @Override
        public synchronized Transaction<ByteBuffer, ByteBuffer, ByteBuffer> remove(ByteBuffer id, ByteBuffer key) {
            RestartStoreImpl.this.checkReadyState();
            this.checkCommitted();
            RestartStoreImpl.this.transactionManager.happened(this.handle, new RemoveAction(RestartStoreImpl.this.objectManager, RestartStoreImpl.this.compactor, id, key, RestartStoreImpl.this.isRecovering()));
            return this;
        }

        @Override
        public synchronized void commit() throws TransactionException {
            RestartStoreImpl.this.checkReadyState();
            this.checkCommitted();
            RestartStoreImpl.this.transactionManager.commit(this.handle, this.synchronous);
            this.committed = true;
        }

        private void checkCommitted() {
            if (this.committed) {
                throw new IllegalStateException("Transaction is already committed.");
            }
        }
    }

    private class AutoCommitTransaction
    implements Transaction<ByteBuffer, ByteBuffer, ByteBuffer> {
        private final boolean synchronous;

        private AutoCommitTransaction(boolean synchronous) {
            this.synchronous = synchronous;
        }

        private void happened(Action action) throws TransactionException {
            if (this.synchronous) {
                boolean interrupted = false;
                Future<Void> written = RestartStoreImpl.this.actionManager.syncHappened(action);
                while (true) {
                    try {
                        written.get();
                    }
                    catch (ExecutionException e) {
                        throw new TransactionException(e);
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                        continue;
                    }
                    break;
                }
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            } else {
                RestartStoreImpl.this.actionManager.happened(action);
            }
        }

        @Override
        public Transaction<ByteBuffer, ByteBuffer, ByteBuffer> put(ByteBuffer id, ByteBuffer key, ByteBuffer value) throws TransactionException {
            RestartStoreImpl.this.checkReadyState();
            this.happened(new PutAction((ObjectManager<ByteBuffer, ByteBuffer, ByteBuffer>)RestartStoreImpl.this.objectManager, RestartStoreImpl.this.compactor, id, key, value, RestartStoreImpl.this.isRecovering()));
            return this;
        }

        @Override
        public Transaction<ByteBuffer, ByteBuffer, ByteBuffer> delete(ByteBuffer id) throws TransactionException {
            RestartStoreImpl.this.checkReadyState();
            this.happened(new DeleteAction(RestartStoreImpl.this.objectManager, RestartStoreImpl.this.compactor, id, RestartStoreImpl.this.isRecovering()));
            return this;
        }

        @Override
        public Transaction<ByteBuffer, ByteBuffer, ByteBuffer> remove(ByteBuffer id, ByteBuffer key) throws TransactionException {
            RestartStoreImpl.this.checkReadyState();
            this.happened(new RemoveAction(RestartStoreImpl.this.objectManager, RestartStoreImpl.this.compactor, id, key, RestartStoreImpl.this.isRecovering()));
            return this;
        }

        @Override
        public void commit() throws TransactionException {
        }
    }

    private static enum State {
        INIT,
        RECOVERING,
        RUNNING,
        SHUTDOWN;

    }
}

