/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.portability;

import com.terracottatech.offheapstore.storage.portability.Portability;
import com.terracottatech.offheapstore.storage.portability.SerializablePortability;
import com.terracottatech.offheapstore.util.ByteBufferInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.store.offheap.portability.AbstractEhcachePortability;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhcacheKeyPortability
extends AbstractEhcachePortability
implements Portability<Serializable> {
    public EhcacheKeyPortability() {
        super(new SerializablePortability());
    }

    protected EhcacheKeyPortability(SerializablePortability delegate) {
        super(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuffer encode(Serializable object) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(bout);
        try {
            try {
                this.writeObjects(dout, object);
            }
            finally {
                dout.close();
            }
        }
        catch (IOException e) {
            throw new CacheException("Failure while encoding key " + object, e);
        }
        return ByteBuffer.wrap(bout.toByteArray());
    }

    @Override
    public Serializable decode(ByteBuffer buffer) {
        try {
            return this.readObjects(new DataInputStream(new ByteBufferInputStream(buffer)), 1)[0];
        }
        catch (ClassNotFoundException e) {
            throw new CacheException("Failure while decoding key " + buffer, e);
        }
        catch (IOException e) {
            throw new CacheException("Failure while decoding key " + buffer, e);
        }
    }

    @Override
    public boolean equals(Object object, ByteBuffer buffer) {
        return object.equals(this.decode(buffer));
    }
}

