/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.portability;

import com.terracottatech.offheapstore.storage.portability.SerializablePortability;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public abstract class AbstractEhcachePortability {
    private static final byte OBJECT_TYPE_INTEGER = 1;
    private static final byte OBJECT_TYPE_LONG = 2;
    private static final byte OBJECT_TYPE_STRING = 3;
    private static final byte OBJECT_TYPE_BYTE_ARRAY = 4;
    private static final byte OBJECT_TYPE_SERIALIZABLES = 5;
    protected final SerializablePortability serializablePortability;

    public AbstractEhcachePortability(SerializablePortability delegate) {
        this.serializablePortability = delegate;
    }

    protected void writeObjects(DataOutputStream output, Serializable ... objects) throws IOException {
        for (int i = 0; i < objects.length; ++i) {
            Serializable next;
            Serializable object = objects[i];
            if (object instanceof Integer) {
                output.writeByte(1);
                output.writeInt((Integer)object);
                continue;
            }
            if (object instanceof Long) {
                output.writeByte(2);
                output.writeLong((Long)object);
                continue;
            }
            if (object instanceof String) {
                output.writeByte(3);
                output.writeUTF((String)((Object)object));
                continue;
            }
            if (object instanceof byte[]) {
                output.writeByte(4);
                output.writeInt(((byte[])object).length);
                output.write((byte[])object);
                continue;
            }
            output.writeByte(5);
            int offset = i;
            while (!(i + 1 >= objects.length || (next = objects[i + 1]) instanceof Integer || next instanceof Long || next instanceof String || next instanceof byte[])) {
                ++i;
            }
            int count = i - offset + 1;
            output.writeByte(count);
            this.writeSerializables(output, objects, offset, count);
        }
    }

    protected Serializable[] readObjects(DataInputStream input, int count) throws IOException, ClassNotFoundException {
        Serializable[] objects = new Serializable[count];
        int i = 0;
        block7: while (i < objects.length) {
            byte type = input.readByte();
            switch (type) {
                case 1: {
                    objects[i++] = Integer.valueOf(input.readInt());
                    continue block7;
                }
                case 2: {
                    objects[i++] = Long.valueOf(input.readLong());
                    continue block7;
                }
                case 3: {
                    objects[i++] = input.readUTF();
                    continue block7;
                }
                case 4: {
                    byte[] result = new byte[input.readInt()];
                    input.readFully(result);
                    objects[i++] = result;
                    continue block7;
                }
                case 5: {
                    byte n = input.readByte();
                    this.readSerializables(input, objects, i, n);
                    i += n;
                    continue block7;
                }
            }
            throw new IOException("Unknown payload object type " + type);
        }
        return objects;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSerializables(DataOutputStream output, Serializable[] objects, int offset, int count) throws IOException {
        ObjectOutputStream oout = this.serializablePortability.getObjectOutputStream(output);
        try {
            for (int i = offset; i < offset + count; ++i) {
                oout.writeObject(objects[i]);
            }
        }
        finally {
            oout.flush();
        }
    }

    private void readSerializables(DataInputStream input, Serializable[] objects, int offset, int count) throws IOException, ClassNotFoundException {
        ObjectInputStream oin = this.serializablePortability.getObjectInputStream(input);
        for (int i = offset; i < offset + count; ++i) {
            objects[i] = (Serializable)oin.readObject();
        }
    }
}

