/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.factories;

import com.terracottatech.offheapstore.ReadWriteLockedOffHeapClockCache;
import com.terracottatech.offheapstore.concurrent.SegmentFactory;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.storage.StorageEngine;
import com.terracottatech.offheapstore.storage.StorageEngineFactory;
import java.io.Serializable;
import java.util.concurrent.locks.Lock;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.ElementValueComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhcacheSegmentFactory
implements SegmentFactory<Serializable, Element> {
    private final RegisteredEventListeners evictionListener;
    private final StorageEngineFactory<? super Serializable, ? super Element> storageEngineFactory;
    private final PageSource tableSource;
    private final int tableSize;

    public EhcacheSegmentFactory(RegisteredEventListeners evictionListener, PageSource source, StorageEngineFactory<? super Serializable, ? super Element> storageEngineFactory, int initialTableSize) {
        this.evictionListener = evictionListener;
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = source;
        this.tableSize = initialTableSize;
    }

    public EhcacheSegment newInstance() {
        StorageEngine<? super Serializable, ? super Element> storageEngine = this.storageEngineFactory.newInstance();
        try {
            return new EhcacheSegment(this.evictionListener, this.tableSource, storageEngine, this.tableSize);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EhcacheSegment
    extends ReadWriteLockedOffHeapClockCache<Serializable, Element> {
        private final RegisteredEventListeners evictionListener;

        EhcacheSegment(RegisteredEventListeners evictionListener, PageSource source, StorageEngine<? super Serializable, ? super Element> storageEngine, int tableSize) {
            super(source, storageEngine, tableSize);
            this.evictionListener = evictionListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void evict(int index, boolean shrink) {
            try {
                if (this.evictionListener.hasCacheEventListeners()) {
                    Element e = (Element)this.getAtTableOffset(index);
                    if (e.isExpired()) {
                        this.evictionListener.notifyElementExpiry(e, false);
                    } else {
                        this.evictionListener.notifyElementEvicted(e, false);
                    }
                }
            }
            finally {
                super.evict(index, shrink);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object key, Element value, ElementValueComparator comparator) {
            Lock l = this.getWriteLock();
            l.lock();
            try {
                if (key == null) {
                    throw new NullPointerException();
                }
                if (value == null) {
                    boolean bl = false;
                    return bl;
                }
                Element existing = (Element)super.get(key);
                if (comparator.equals(value, existing)) {
                    super.remove(key);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean replace(Serializable key, Element oldValue, Element newValue, ElementValueComparator comparator) {
            Lock l = this.getWriteLock();
            l.lock();
            try {
                Element existing = (Element)super.get(key);
                if (comparator.equals(oldValue, existing)) {
                    super.put(key, newValue);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                l.unlock();
            }
        }
    }
}

