/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap.factories;

import com.terracottatech.offheapstore.concurrent.SegmentFactory;
import com.terracottatech.offheapstore.disk.paging.MappedPageSource;
import com.terracottatech.offheapstore.disk.persistent.PersistentReadWriteLockedOffHeapClockCache;
import com.terracottatech.offheapstore.disk.persistent.PersistentStorageEngine;
import com.terracottatech.offheapstore.disk.persistent.PersistentStorageEngineFactory;
import com.terracottatech.offheapstore.exceptions.OversizeMappingException;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.ElementValueComparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhcachePersistentSegmentFactory
implements SegmentFactory<Serializable, Element> {
    private final RegisteredEventListeners evictionListener;
    private final PersistentStorageEngineFactory<? super Serializable, ? super Element> storageEngineFactory;
    private final MappedPageSource tableSource;
    private final int tableSize;
    private final boolean bootstrap;
    private final AtomicLong size = new AtomicLong();
    private final long capacity;

    public EhcachePersistentSegmentFactory(RegisteredEventListeners evictionListener, MappedPageSource source, PersistentStorageEngineFactory<? super Serializable, ? super Element> storageEngineFactory, int initialTableSize, long capacity, boolean bootstrap) {
        this.evictionListener = evictionListener;
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = source;
        this.tableSize = initialTableSize;
        this.bootstrap = bootstrap;
        this.capacity = capacity;
    }

    public EhcachePersistentSegment newInstance() {
        PersistentStorageEngine<? super Serializable, ? super Element> storageEngine = this.storageEngineFactory.newInstance();
        try {
            if (this.capacity > 0L) {
                return new EhcachePersistentSegment(this.evictionListener, this.tableSource, storageEngine, this.tableSize, this.size, this.capacity, this.bootstrap);
            }
            return new EhcachePersistentSegment(this.evictionListener, this.tableSource, storageEngine, this.tableSize, this.bootstrap);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EhcachePersistentSegment
    extends PersistentReadWriteLockedOffHeapClockCache<Serializable, Element> {
        private final RegisteredEventListeners evictionListener;
        private final AtomicLong globalSize;
        private final long globalCapacity;

        EhcachePersistentSegment(RegisteredEventListeners evictionListener, MappedPageSource source, PersistentStorageEngine<? super Serializable, ? super Element> storageEngine, int tableSize, AtomicLong size, long capacity, boolean bootstrap) {
            super(source, storageEngine, tableSize, bootstrap);
            this.evictionListener = evictionListener;
            this.globalSize = size;
            this.globalCapacity = capacity;
        }

        EhcachePersistentSegment(RegisteredEventListeners evictionListener, MappedPageSource source, PersistentStorageEngine<? super Serializable, ? super Element> storageEngine, int tableSize, boolean bootstrap) {
            this(evictionListener, source, storageEngine, tableSize, new AtomicLong(), Long.MAX_VALUE, bootstrap);
        }

        @Override
        protected void added(int position) {
            super.added(position);
            long currentSize = this.globalSize.incrementAndGet();
            long evict = Math.min(currentSize - this.globalCapacity, 2L);
            for (long i = 0L; i < evict; ++i) {
                try {
                    this.storageEngineFailure(position, null);
                    continue;
                }
                catch (OversizeMappingException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }

        @Override
        protected void removed(int position) {
            super.removed(position);
            this.globalSize.decrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void evict(int index, boolean shrink) {
            try {
                if (this.evictionListener.hasCacheEventListeners()) {
                    Element e = (Element)this.getAtTableOffset(index);
                    if (e.isExpired()) {
                        this.evictionListener.notifyElementExpiry(e, false);
                    } else {
                        this.evictionListener.notifyElementEvicted(e, false);
                    }
                }
            }
            finally {
                super.evict(index, shrink);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean remove(Object key, Element value, ElementValueComparator comparator) {
            Lock l = this.getWriteLock();
            l.lock();
            try {
                if (key == null) {
                    throw new NullPointerException();
                }
                if (value == null) {
                    boolean bl = false;
                    return bl;
                }
                Element existing = (Element)super.get(key);
                if (comparator.equals(value, existing)) {
                    super.remove(key);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                l.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean replace(Serializable key, Element oldValue, Element newValue, ElementValueComparator comparator) {
            Lock l = this.getWriteLock();
            l.lock();
            try {
                Element existing = (Element)super.get(key);
                if (comparator.equals(oldValue, existing)) {
                    super.put(key, newValue);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                l.unlock();
            }
        }
    }
}

