/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap;

import com.terracottatech.offheapstore.exceptions.OversizeMappingException;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.compound.ReadWriteCopyStrategy;
import net.sf.ehcache.store.offheap.FrontEndCacheTier;
import net.sf.ehcache.store.offheap.OffHeapStore;
import net.sf.ehcache.store.offheap.configuration.AdvancedConfigPropertyParser;
import net.sf.ehcache.writer.CacheWriterManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OnHeapFrontedOffHeapStore
extends FrontEndCacheTier<MemoryStore, OffHeapStore> {
    private final boolean copyOnRead;
    private final boolean copyOnWrite;
    private final ReadWriteCopyStrategy<Element> copyStrategy;
    private final boolean alwaysPutOnHeap;
    private final boolean handleOversize;

    public OnHeapFrontedOffHeapStore(CacheConfiguration cacheConfiguration, MemoryStore cache, OffHeapStore authority, boolean handleOversize) {
        super(cache, authority);
        this.alwaysPutOnHeap = AdvancedConfigPropertyParser.getAdvancedBooleanConfigProperty("alwaysPutOnHeap", cacheConfiguration.getName(), false);
        this.handleOversize = handleOversize;
        this.copyOnRead = cacheConfiguration.isCopyOnRead();
        this.copyOnWrite = cacheConfiguration.isCopyOnWrite();
        this.copyStrategy = cacheConfiguration.getCopyStrategy();
    }

    @Override
    protected Element copyElementForReadIfNeeded(Element element) {
        if (this.copyOnRead && this.copyOnWrite) {
            return this.copyStrategy.copyForRead(element);
        }
        if (this.copyOnRead) {
            return this.copyStrategy.copyForRead(this.copyStrategy.copyForWrite(element));
        }
        return element;
    }

    @Override
    protected Element copyElementForWriteIfNeeded(Element element) {
        if (this.copyOnRead && this.copyOnWrite) {
            return this.copyStrategy.copyForWrite(element);
        }
        if (this.copyOnWrite) {
            return this.copyStrategy.copyForRead(this.copyStrategy.copyForWrite(element));
        }
        return element;
    }

    @Override
    protected boolean isCacheFull() {
        return !this.alwaysPutOnHeap && ((MemoryStore)this.cache).isFull();
    }

    @Override
    protected void readLock(Object key) {
        ((OffHeapStore)this.authority).getLock(key).readLock().lock();
    }

    @Override
    protected void readUnlock(Object key) {
        ((OffHeapStore)this.authority).getLock(key).readLock().unlock();
    }

    @Override
    protected void writeLock(Object key) {
        ((OffHeapStore)this.authority).getLock(key).writeLock().lock();
    }

    @Override
    protected void writeUnlock(Object key) {
        ((OffHeapStore)this.authority).getLock(key).writeLock().unlock();
    }

    @Override
    protected void readLock() {
        ((OffHeapStore)this.authority).readLock();
    }

    @Override
    protected void readUnlock() {
        ((OffHeapStore)this.authority).readUnlock();
    }

    @Override
    protected void writeLock() {
        ((OffHeapStore)this.authority).writeLock();
    }

    @Override
    protected void writeUnlock() {
        ((OffHeapStore)this.authority).writeUnlock();
    }

    @Override
    public Status getStatus() {
        return ((OffHeapStore)this.authority).getStatus();
    }

    @Override
    public Policy getInMemoryEvictionPolicy() {
        return ((MemoryStore)this.cache).getInMemoryEvictionPolicy();
    }

    @Override
    public void setInMemoryEvictionPolicy(Policy policy) {
        ((MemoryStore)this.cache).setInMemoryEvictionPolicy(policy);
    }

    @Override
    public Object getInternalContext() {
        return ((OffHeapStore)this.authority).getInternalContext();
    }

    @Override
    public Object getMBean() {
        return ((OffHeapStore)this.authority).getMBean();
    }

    @Override
    public boolean put(Element e) {
        while (true) {
            try {
                return super.put(e);
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(ex, e);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean putWithWriter(Element e, CacheWriterManager writer) {
        while (true) {
            try {
                return super.putWithWriter(e, writer);
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(ex, e);
                continue;
            }
            break;
        }
    }

    @Override
    public Element putIfAbsent(Element e) throws NullPointerException {
        while (true) {
            try {
                return super.putIfAbsent(e);
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(ex, e);
                continue;
            }
            break;
        }
    }

    @Override
    public boolean replace(Element old, Element e, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        while (true) {
            try {
                return super.replace(old, e, comparator);
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(ex, e);
                continue;
            }
            break;
        }
    }

    @Override
    public Element replace(Element e) throws NullPointerException {
        while (true) {
            try {
                return super.replace(e);
            }
            catch (OversizeMappingException ex) {
                this.handleOversizeMappingException(ex, e);
                continue;
            }
            break;
        }
    }

    private void handleOversizeMappingException(OversizeMappingException ex, Element e) {
        if (!this.handleOversize) {
            throw ex;
        }
        ((OffHeapStore)this.authority).handleOversizeMappingException(e);
    }

    public void handleOversizeMappingException(Element e) {
        ((OffHeapStore)this.authority).handleOversizeMappingException(e);
    }
}

