/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap;

import com.terracottatech.offheapstore.statistics.jmx.ConcurrentMapStatisticsManager;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.CacheEntry;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.Status;
import net.sf.ehcache.concurrent.CacheLockProvider;
import net.sf.ehcache.concurrent.ReadWriteLockSync;
import net.sf.ehcache.concurrent.Sync;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.AbstractStore;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.MemoryStore;
import net.sf.ehcache.store.Policy;
import net.sf.ehcache.store.Store;
import net.sf.ehcache.store.offheap.DiskBackedOffHeapStore;
import net.sf.ehcache.store.offheap.EhcacheConcurrentOffHeapClockCache;
import net.sf.ehcache.store.offheap.FrontEndCacheTier;
import net.sf.ehcache.store.offheap.OnHeapFrontedOffHeapStore;
import net.sf.ehcache.store.offheap.TransactionalBackedStore;
import net.sf.ehcache.store.offheap.configuration.HeuristicConfiguration;
import net.sf.ehcache.store.offheap.disk.OffHeapDiskStore;
import net.sf.ehcache.store.offheap.disk.persistent.OffHeapPersistentDiskStore;
import net.sf.ehcache.store.offheap.util.SetAsList;
import net.sf.ehcache.writer.CacheWriterManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.license.LicenseException;
import org.terracotta.license.ehcache.LicenseManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OffHeapStore
extends AbstractStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(OffHeapStore.class);
    private static final int MINIMUM_RECOMMENDED_IN_MEMORY = 100;
    private final String cacheName;
    private final EhcacheConcurrentOffHeapClockCache map;
    private final AtomicReference<Status> status = new AtomicReference<Status>(Status.STATUS_UNINITIALISED);
    private final boolean notify;
    private CacheLockProvider lockProvider;
    private RegisteredEventListeners eventService;

    public static Store create(Ehcache cache, String diskStorePath) {
        try {
            LicenseManager.verifyOffHeapUsage(cache.getCacheManager());
        }
        catch (LicenseException e) {
            throw new CacheException(e.getMessage());
        }
        CacheConfiguration config = cache.getCacheConfiguration();
        if (config.getMaxElementsInMemory() < 100) {
            LOGGER.warn("The " + config.getName() + " cache is configured for off-heap and has a maxElementsInMemory of " + config.getMaxElementsInMemory() + ".  It is recommended to set maxElementsInMemory to at least " + 100 + " elements when using an off-heap store, otherwise performance " + "will be seriously degraded.");
        }
        FrontEndCacheTier store = config.isOverflowToDisk() ? new DiskBackedOffHeapStore(new OnHeapFrontedOffHeapStore(config, MemoryStore.createSilent(cache, null), new OffHeapStore(cache, false), false), new OffHeapDiskStore(cache, diskStorePath)) : (config.isDiskPersistent() ? new DiskBackedOffHeapStore(new OnHeapFrontedOffHeapStore(config, MemoryStore.createSilent(cache, null), new OffHeapStore(cache, false), false), OffHeapPersistentDiskStore.create(cache, diskStorePath)) : new OnHeapFrontedOffHeapStore(config, MemoryStore.createSilent(cache, null), new OffHeapStore(cache), true));
        if (config.getTransactionalMode().isTransactional()) {
            return new TransactionalBackedStore(store);
        }
        return store;
    }

    public OffHeapStore(Ehcache cache) {
        this(cache, true);
    }

    public OffHeapStore(Ehcache cache, boolean notify) {
        CacheConfiguration config = cache.getCacheConfiguration();
        this.cacheName = cache.getName();
        this.map = EhcacheConcurrentOffHeapClockCache.create(cache.getCacheEventNotificationService(), new HeuristicConfiguration(cache.getName(), config.getMaxMemoryOffHeapInBytes()), (int)config.getTimeToLiveSeconds(), (int)config.getTimeToIdleSeconds());
        this.eventService = cache.getCacheEventNotificationService();
        if (!this.status.compareAndSet(Status.STATUS_UNINITIALISED, Status.STATUS_ALIVE)) {
            throw new AssertionError();
        }
        this.notify = notify;
    }

    @Override
    public boolean put(Element element) throws CacheException {
        if (element == null) {
            return false;
        }
        if (!element.isSerializable()) {
            throw this.handleNotSerializableException(element);
        }
        return this.map.put(element.getKey(), element) == null;
    }

    @Override
    public boolean putWithWriter(Element element, CacheWriterManager writerManager) {
        boolean result = this.put(element);
        if (writerManager != null) {
            writerManager.put(element);
        }
        return result;
    }

    @Override
    public Element get(Object key) {
        if (key == null) {
            return null;
        }
        return (Element)this.map.get(key);
    }

    @Override
    public Element getQuiet(Object key) {
        return this.get(key);
    }

    @Override
    public List<?> getKeys() {
        return new SetAsList(this.map.keySet());
    }

    @Override
    public Element remove(Object key) {
        if (key == null) {
            return null;
        }
        return (Element)this.map.remove(key);
    }

    @Override
    public Element removeWithWriter(Object key, CacheWriterManager writerManager) throws CacheException {
        Element removed = this.remove(key);
        if (writerManager != null) {
            writerManager.remove(new CacheEntry(key, removed));
        }
        return removed;
    }

    @Override
    public void removeAll() throws CacheException {
        this.map.clear();
    }

    @Override
    public Element putIfAbsent(Element element) throws NullPointerException {
        if (!element.isSerializable()) {
            throw this.handleNotSerializableException(element);
        }
        return this.map.putIfAbsent(element.getKey(), element);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Element removeElement(Element element, ElementValueComparator comparator) throws NullPointerException {
        if (!element.isSerializable()) {
            throw this.handleNotSerializableException(element);
        }
        Object key = element.getObjectKey();
        ReentrantReadWriteLock.WriteLock l = this.map.getLock(key).writeLock();
        l.lock();
        try {
            Element value = (Element)this.map.get(key);
            if (this.map.remove(key, element, comparator)) {
                Element element2 = value;
                return element2;
            }
            Element element3 = null;
            return element3;
        }
        finally {
            l.unlock();
        }
    }

    @Override
    public boolean replace(Element old, Element element, ElementValueComparator comparator) throws NullPointerException, IllegalArgumentException {
        if (!element.isSerializable()) {
            throw this.handleNotSerializableException(element);
        }
        return this.map.replace(element.getKey(), old, element, comparator);
    }

    @Override
    public Element replace(Element element) throws NullPointerException {
        if (!element.isSerializable()) {
            throw this.handleNotSerializableException(element);
        }
        return this.map.replace(element.getKey(), element);
    }

    @Override
    public void dispose() {
        if (this.status.compareAndSet(Status.STATUS_ALIVE, Status.STATUS_SHUTDOWN)) {
            this.map.destroy();
        }
    }

    @Override
    public int getSize() {
        return this.map.size();
    }

    @Override
    public int getInMemorySize() {
        return 0;
    }

    @Override
    public int getOffHeapSize() {
        return this.getSize();
    }

    @Override
    public int getOnDiskSize() {
        return 0;
    }

    @Override
    public int getTerracottaClusteredSize() {
        return 0;
    }

    @Override
    public long getInMemorySizeInBytes() {
        return 0L;
    }

    @Override
    public long getOffHeapSizeInBytes() {
        return this.map.getOccupiedMemory();
    }

    @Override
    public long getOnDiskSizeInBytes() {
        return 0L;
    }

    @Override
    public Status getStatus() {
        return this.status.get();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsKeyOnDisk(Object key) {
        return false;
    }

    @Override
    public boolean containsKeyOffHeap(Object key) {
        return this.containsKey(key);
    }

    @Override
    public boolean containsKeyInMemory(Object key) {
        return false;
    }

    @Override
    public void expireElements() {
        for (Serializable key : this.map.keySet()) {
            Element value = this.get(key);
            if (value == null || !value.isExpired() || !this.map.remove(key, value) || !this.notify) continue;
            this.eventService.notifyElementExpiry(value, false);
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public boolean bufferFull() {
        return false;
    }

    @Override
    public Policy getInMemoryEvictionPolicy() {
        return null;
    }

    @Override
    public void setInMemoryEvictionPolicy(Policy policy) {
    }

    @Override
    public Object getInternalContext() {
        CacheLockProvider lp = this.lockProvider;
        return lp == null ? (this.lockProvider = new LockProvider()) : lp;
    }

    public ReadWriteLock getLock(Object key) {
        return this.map.getLock(key);
    }

    public void readLock() {
        for (ReentrantReadWriteLock l : this.map.getOrderedLocks()) {
            l.readLock().lock();
        }
    }

    public void readUnlock() {
        for (ReentrantReadWriteLock l : this.map.getOrderedLocks()) {
            l.readLock().unlock();
        }
    }

    public void writeLock() {
        for (ReentrantReadWriteLock l : this.map.getOrderedLocks()) {
            l.writeLock().lock();
        }
    }

    public void writeUnlock() {
        for (ReentrantReadWriteLock l : this.map.getOrderedLocks()) {
            l.writeLock().unlock();
        }
    }

    @Override
    public Object getMBean() {
        return new ConcurrentMapStatisticsManager(this.map);
    }

    public void handleOversizeMappingException(Element e) {
        if (!this.map.handleOversizeMappingException(e.getKey())) {
            throw new CacheException("The element '" + e + "' is too large to be stored" + " in this offheap store.");
        }
    }

    private RuntimeException handleNotSerializableException(Element e) {
        return new CacheException("The element '" + e + "' is not serializable and" + " cannot be put into the offheap cache " + this.cacheName);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LockProvider
    implements CacheLockProvider {
        LockProvider() {
        }

        @Override
        public Sync[] getAndWriteLockAllSyncForKeys(Object ... keys) {
            Map<ReentrantReadWriteLock, AtomicInteger> segs = this.getSegmentsFor(keys);
            ArrayList<ReadWriteLockSync> ordered = new ArrayList<ReadWriteLockSync>();
            for (ReentrantReadWriteLock s : OffHeapStore.this.map.getOrderedLocks()) {
                if (!segs.containsKey(s)) continue;
                AtomicInteger counter = segs.get(s);
                while (counter.getAndDecrement() > 0) {
                    s.writeLock().lock();
                }
                ordered.add(new ReadWriteLockSync(s));
            }
            return ordered.toArray(new Sync[ordered.size()]);
        }

        @Override
        public Sync[] getAndWriteLockAllSyncForKeys(long timeout, Object ... keys) throws TimeoutException {
            Map<ReentrantReadWriteLock, AtomicInteger> segs = this.getSegmentsFor(keys);
            ArrayList<ReentrantReadWriteLock.WriteLock> acquiredLocks = new ArrayList<ReentrantReadWriteLock.WriteLock>();
            ReentrantReadWriteLock.WriteLock unheldLock = null;
            ArrayList<ReadWriteLockSync> ordered = new ArrayList<ReadWriteLockSync>();
            for (ReentrantReadWriteLock s : OffHeapStore.this.map.getOrderedLocks()) {
                boolean lockHeld;
                if (!segs.containsKey(s)) continue;
                try {
                    ReentrantReadWriteLock.WriteLock writeLock = s.writeLock();
                    lockHeld = writeLock.tryLock(timeout, TimeUnit.MILLISECONDS);
                    if (lockHeld) {
                        AtomicInteger counter = segs.get(s);
                        while (counter.decrementAndGet() > 0) {
                            writeLock.lock();
                            acquiredLocks.add(writeLock);
                        }
                        acquiredLocks.add(writeLock);
                    } else {
                        unheldLock = writeLock;
                    }
                }
                catch (InterruptedException e) {
                    lockHeld = false;
                }
                if (!lockHeld) {
                    for (int i = acquiredLocks.size() - 1; i >= 0; --i) {
                        Lock writeLock = (Lock)acquiredLocks.get(i);
                        writeLock.unlock();
                    }
                    throw new TimeoutException("could not acquire all locks in " + timeout + " ms - did not get " + unheldLock);
                }
                ordered.add(new ReadWriteLockSync(s));
            }
            return ordered.toArray(new Sync[ordered.size()]);
        }

        @Override
        public Sync getSyncForKey(Object key) {
            return new ReadWriteLockSync(OffHeapStore.this.map.getLock(key));
        }

        @Override
        public void unlockWriteLockForAllKeys(Object ... keys) {
            for (Map.Entry<ReentrantReadWriteLock, AtomicInteger> entry : this.getSegmentsFor(keys).entrySet()) {
                while (entry.getValue().getAndDecrement() > 0) {
                    entry.getKey().writeLock().unlock();
                }
            }
        }

        private Map<ReentrantReadWriteLock, AtomicInteger> getSegmentsFor(Object ... keys) {
            HashMap<ReentrantReadWriteLock, AtomicInteger> segs = new HashMap<ReentrantReadWriteLock, AtomicInteger>();
            for (Object k : keys) {
                ReentrantReadWriteLock key = OffHeapStore.this.map.getLock(k);
                if (segs.containsKey(key)) {
                    ((AtomicInteger)segs.get(key)).getAndIncrement();
                    continue;
                }
                segs.put(key, new AtomicInteger(1));
            }
            return segs;
        }
    }
}

