/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.store.offheap;

import com.terracottatech.offheapstore.Segment;
import com.terracottatech.offheapstore.buffersource.OffHeapBufferSource;
import com.terracottatech.offheapstore.concurrent.AbstractConcurrentOffHeapMap;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.paging.UpfrontAllocatingPageSource;
import com.terracottatech.offheapstore.storage.StorageEngineFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.Element;
import net.sf.ehcache.event.RegisteredEventListeners;
import net.sf.ehcache.store.ElementValueComparator;
import net.sf.ehcache.store.offheap.configuration.Configuration;
import net.sf.ehcache.store.offheap.factories.EhcacheSegmentFactory;
import net.sf.ehcache.store.offheap.factories.EhcacheStorageEngineFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhcacheConcurrentOffHeapClockCache
extends AbstractConcurrentOffHeapMap<Serializable, Element> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EhcacheConcurrentOffHeapClockCache.class);
    private List<ReentrantReadWriteLock> locks;

    public static EhcacheConcurrentOffHeapClockCache create(RegisteredEventListeners evictionListener, Configuration config, int defaultTTL, int defaultTTI) {
        LOGGER.info("Creating Off-Heap Area Using Config\n {}", (Object)config);
        UpfrontAllocatingPageSource source = new UpfrontAllocatingPageSource(new OffHeapBufferSource(), config.getMaximumSize(), config.getMaximumChunkSize(), config.getMinimumChunkSize());
        EhcacheStorageEngineFactory storageEngineFactory = new EhcacheStorageEngineFactory(source, config.getSegmentDataPageSize(), defaultTTL, defaultTTI);
        return new EhcacheConcurrentOffHeapClockCache(evictionListener, source, storageEngineFactory, config.getInitialSegmentTableSize(), config.getConcurrency());
    }

    private EhcacheConcurrentOffHeapClockCache(RegisteredEventListeners evictionListener, PageSource source, StorageEngineFactory<Serializable, ? super Element> storageEngineFactory, int initialTableSize, int ssize) {
        super(new EhcacheSegmentFactory(evictionListener, source, storageEngineFactory, initialTableSize), ssize, false);
    }

    public ReentrantReadWriteLock getLock(Object key) {
        return this.segmentFor(key).getLock();
    }

    public List<ReentrantReadWriteLock> getOrderedLocks() {
        List<ReentrantReadWriteLock> l = this.locks;
        return l == null ? (this.locks = this.generateLockList()) : l;
    }

    private List<ReentrantReadWriteLock> generateLockList() {
        ArrayList<ReentrantReadWriteLock> l = new ArrayList<ReentrantReadWriteLock>(this.segments.length);
        for (Segment c : this.segments) {
            l.add(c.getLock());
        }
        return Collections.unmodifiableList(l);
    }

    public boolean remove(Object key, Element element, ElementValueComparator comparator) {
        EhcacheSegmentFactory.EhcacheSegment segment = (EhcacheSegmentFactory.EhcacheSegment)this.segmentFor(key);
        return segment.remove(key, element, comparator);
    }

    public boolean replace(Serializable key, Element oldValue, Element newValue, ElementValueComparator comparator) {
        EhcacheSegmentFactory.EhcacheSegment segment = (EhcacheSegmentFactory.EhcacheSegment)this.segmentFor(key);
        return segment.replace(key, oldValue, newValue, comparator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handleOversizeMappingException(Serializable key) {
        boolean evicted = false;
        Segment target = this.segmentFor(key);
        for (Segment s : this.segments) {
            if (s == target) continue;
            Lock l = s.getWriteLock();
            l.lock();
            try {
                evicted |= s.shrink();
            }
            finally {
                l.unlock();
            }
        }
        return evicted;
    }
}

