/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DebuggingUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebuggingUtils.class);
    private static final String[] BASE_10_SUFFIXES = new String[]{"", "k", "M", "G", "T", "P", "E"};
    private static final String[] BASE_2_SUFFIXES = new String[]{"", "K", "M", "G", "T", "P", "E"};
    private static final long[] BASE_10_DIVISORS = new long[BASE_10_SUFFIXES.length];

    public static String toBase2SuffixedString(long n) {
        if (n > 0L && Long.bitCount(n) == 1) {
            int i = Long.numberOfTrailingZeros(Math.abs(n)) / 10;
            return (n >> i * 10) + BASE_2_SUFFIXES[i];
        }
        int i = (63 - Long.numberOfLeadingZeros(n)) / 10;
        long factor = 1 << i * 10;
        long leading = n / factor;
        long decimalFactor = factor / 10L;
        if (decimalFactor == 0L) {
            return leading + BASE_2_SUFFIXES[i];
        }
        long decimal = (n - leading * factor) / (factor / 10L);
        return leading + "." + decimal + BASE_2_SUFFIXES[i];
    }

    public static String toBase10SuffixedString(long n) {
        for (int i = 0; i < BASE_10_SUFFIXES.length; ++i) {
            long d = n / 1000L / BASE_10_DIVISORS[i];
            if (d != 0L) continue;
            return n / BASE_10_DIVISORS[i] + BASE_10_SUFFIXES[i];
        }
        throw new AssertionError();
    }

    public static void commitSuicide(String msg) {
        try {
            System.exit(-1);
        }
        catch (SecurityException ex) {
            LOGGER.info("SecurityException prevented system exit", (Throwable)ex);
        }
        Thread t = new Thread(){

            public void run() {
                try {
                    while (true) {
                        Thread.sleep(5000L);
                        LOGGER.error("VM is in an unreliable state - please abort it!");
                    }
                }
                catch (InterruptedException e) {
                    LOGGER.info("JVM Instability logger terminated by interrupt");
                    return;
                }
            }
        };
        t.setDaemon(true);
        t.start();
        throw new Error(msg);
    }

    private DebuggingUtils() {
    }

    static {
        for (int i = 0; i < BASE_10_DIVISORS.length; ++i) {
            long n = 1L;
            for (int j = 0; j < i; ++j) {
                n *= 1000L;
            }
            DebuggingUtils.BASE_10_DIVISORS[i] = n;
        }
    }
}

