/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage.allocator;

import com.terracottatech.offheapstore.storage.allocator.Region;
import com.terracottatech.offheapstore.util.AATreeSet;
import com.terracottatech.offheapstore.util.DebuggingUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PowerOfTwoAllocator
extends AATreeSet<Region> {
    private static final boolean DEBUG = Boolean.getBoolean(PowerOfTwoAllocator.class.getName() + ".DEBUG");
    private final int size;
    private int occupied;

    public PowerOfTwoAllocator(int size) {
        this.add(new Region(0, size - 1));
        this.size = size;
    }

    public int allocate(int size) {
        if (Integer.bitCount(size) != 1) {
            throw new AssertionError((Object)("Size " + size + " is not a power of two"));
        }
        Region r = this.findRegion(size);
        if (r == null) {
            return -1;
        }
        Region current = this.removeAndReturn(r.start());
        Region newRange = current.remove(r);
        if (newRange != null) {
            this.insert(current);
            this.insert(newRange);
        } else if (!current.isNull()) {
            this.insert(current);
        }
        assert (this.validateFreeSpace());
        return r.start();
    }

    public void free(int address, int length) {
        if (length == 0) {
            return;
        }
        this.free(new Region(address, address + length - 1));
    }

    public void tryFree(int address, int length) {
        if (length == 0) {
            return;
        }
        this.tryFree(new Region(address, address + length - 1));
    }

    public int find(int size) {
        if (Integer.bitCount(size) != 1) {
            throw new AssertionError((Object)("Size " + size + " is not a power of two"));
        }
        Region r = this.findRegion(size);
        if (r == null) {
            return -1;
        }
        return r.start();
    }

    public void claim(int address, int size) {
        Region r;
        Region current = this.removeAndReturn(address);
        Region newRange = current.remove(r = new Region(address, address + size - 1));
        if (newRange != null) {
            this.insert(current);
            this.insert(newRange);
        } else if (!current.isNull()) {
            this.insert(current);
        }
        assert (this.validateFreeSpace());
    }

    public int occupied() {
        return this.occupied;
    }

    @Override
    public Region removeAndReturn(Object o) {
        Region r = (Region)super.removeAndReturn(o);
        if (r != null) {
            this.occupied += r.size();
            return new Region(r);
        }
        return null;
    }

    @Override
    public Region find(Object o) {
        Region r = (Region)super.find(o);
        if (r != null) {
            return new Region(r);
        }
        return null;
    }

    private void free(Region r) {
        Region prev = this.removeAndReturn(r.start() - 1);
        if (prev != null) {
            prev.merge(r);
            Region next = this.removeAndReturn(r.end() + 1);
            if (next != null) {
                prev.merge(next);
            }
            this.insert(prev);
            assert (this.validateFreeSpace());
            return;
        }
        Region next = this.removeAndReturn(r.end() + 1);
        if (next != null) {
            next.merge(r);
            this.insert(next);
            assert (this.validateFreeSpace());
            return;
        }
        this.insert(r);
        assert (this.validateFreeSpace());
    }

    private void tryFree(Region r) {
        Region prev = this.removeAndReturn(r.start() - 1);
        if (prev != null) {
            if (prev.tryMerge(r)) {
                Region next = this.removeAndReturn(r.end() + 1);
                if (next != null) {
                    prev.merge(next);
                }
                this.insert(prev);
                assert (this.validateFreeSpace());
                return;
            }
            this.insert(prev);
            assert (this.validateFreeSpace());
            return;
        }
        Region next = this.removeAndReturn(r.end() + 1);
        if (next != null) {
            next.tryMerge(r);
            this.insert(next);
            assert (this.validateFreeSpace());
            return;
        }
        this.tryInsert(r);
        assert (this.validateFreeSpace());
    }

    private void insert(Region x) {
        if (!this.tryInsert(x)) {
            throw new AssertionError();
        }
    }

    private boolean tryInsert(Region x) {
        int size = x.size();
        if (this.add(x)) {
            this.occupied -= size;
            return true;
        }
        return false;
    }

    private Region findRegion(int size) {
        assert (Integer.bitCount(size) == 1);
        AATreeSet.Node currentNode = this.getRoot();
        Region currentRegion = (Region)currentNode.getPayload();
        if (currentRegion == null || (currentRegion.available() & size) == 0) {
            return null;
        }
        while (true) {
            Region left;
            if ((left = (Region)currentNode.getLeft().getPayload()) != null && (left.available() & size) != 0) {
                currentNode = currentNode.getLeft();
                currentRegion = (Region)currentNode.getPayload();
                continue;
            }
            if ((currentRegion.availableHere() & size) != 0) {
                int mask = size - 1;
                int a = currentRegion.start() + mask & ~mask;
                return new Region(a, a + size - 1);
            }
            Region right = (Region)currentNode.getRight().getPayload();
            if (right == null || (right.available() & size) == 0) break;
            currentNode = currentNode.getRight();
            currentRegion = (Region)currentNode.getPayload();
        }
        throw new AssertionError();
    }

    @Override
    public String toString() {
        Region rootRegion = (Region)this.getRoot().getPayload();
        StringBuilder sb = new StringBuilder("PowerOfTwoAllocator: Occupied ");
        sb.append(DebuggingUtils.toBase2SuffixedString(this.occupied())).append("B");
        sb.append(" [Largest Available Area ").append(DebuggingUtils.toBase2SuffixedString(Integer.highestOneBit(rootRegion == null ? 0 : rootRegion.available()))).append("B]");
        if (DEBUG) {
            sb.append("\nFree Regions = ").append(super.toString()).append("");
        }
        return sb.toString();
    }

    private boolean validateFreeSpace() {
        Region rootRegion = (Region)this.getRoot().getPayload();
        if (this.occupied() != this.size - (rootRegion == null ? 0 : rootRegion.treeSize())) {
            throw new AssertionError((Object)("Occupied:" + this.occupied() + " Size-TreeSize:" + (this.size - rootRegion.treeSize())));
        }
        return true;
    }
}

