/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage;

import com.terracottatech.offheapstore.AbstractLockedOffHeapHashMap;
import com.terracottatech.offheapstore.OffHeapHashMap;
import com.terracottatech.offheapstore.paging.OffHeapStorageArea;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.storage.PortabilityBasedStorageEngine;
import com.terracottatech.offheapstore.storage.StorageEngine;
import com.terracottatech.offheapstore.storage.StorageEngineFactory;
import com.terracottatech.offheapstore.storage.portability.Portability;
import com.terracottatech.offheapstore.util.DebuggingUtils;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OffHeapBufferStorageEngine<K, V>
extends PortabilityBasedStorageEngine<K, V>
implements OffHeapStorageArea.Owner {
    private static final int KEY_HASH_OFFSET = 0;
    private static final int KEY_LENGTH_OFFSET = 4;
    private static final int VALUE_LENGTH_OFFSET = 8;
    private static final int DATA_OFFSET = 12;
    private static final int HEADER_SIZE = 12;
    private volatile OffHeapHashMap<?, ?> owner;
    private final OffHeapStorageArea storageArea;

    public static <K, V> StorageEngineFactory<K, V> createFactory(final PageSource source, final int pageSize, final Portability<? super K> keyPortability, final Portability<? super V> valuePortability, final boolean thief, final boolean victim) {
        return new StorageEngineFactory<K, V>(){

            @Override
            public StorageEngine<K, V> newInstance() {
                return new OffHeapBufferStorageEngine(source, pageSize, keyPortability, valuePortability, thief, victim);
            }
        };
    }

    public OffHeapBufferStorageEngine(PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability) {
        this(source, pageSize, keyPortability, valuePortability, false, false);
    }

    public OffHeapBufferStorageEngine(PageSource source, int pageSize, Portability<? super K> keyPortability, Portability<? super V> valuePortability, boolean thief, boolean victim) {
        super(keyPortability, valuePortability);
        this.storageArea = new OffHeapStorageArea(this, source, pageSize, thief, victim);
    }

    @Override
    public void clear() {
        this.storageArea.clear();
    }

    @Override
    protected void free(long address) {
        this.storageArea.free((int)address);
    }

    @Override
    protected ByteBuffer readKeyBuffer(long address) {
        int length = this.storageArea.readInt((int)address + 4);
        return this.storageArea.readBuffer((int)address + 12, length);
    }

    @Override
    protected ByteBuffer readValueBuffer(long address) {
        int keyLength = this.storageArea.readInt((int)address + 4);
        int valueLength = this.storageArea.readInt((int)address + 8);
        return this.storageArea.readBuffer((int)address + 12 + keyLength, valueLength);
    }

    @Override
    protected Long writeMappingBuffers(ByteBuffer keyBuffer, ByteBuffer valueBuffer, int hash) {
        int valueLength;
        int keyLength = keyBuffer.remaining();
        int address = this.storageArea.allocate(keyLength + (valueLength = valueBuffer.remaining()) + 12);
        if (address >= 0) {
            this.storageArea.writeInt(address + 0, hash);
            this.storageArea.writeInt(address + 4, keyLength);
            this.storageArea.writeInt(address + 8, valueLength);
            this.storageArea.writeBuffer(address + 12, keyBuffer);
            this.storageArea.writeBuffer(address + 12 + keyLength, valueBuffer);
            return 0xFFFFFFFFL & (long)address;
        }
        return null;
    }

    @Override
    public long getAllocatedMemory() {
        return this.storageArea.getAllocatedMemory();
    }

    @Override
    public long getOccupiedMemory() {
        return this.storageArea.getOccupiedMemory();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("OffHeapBufferStorageEngine ");
        sb.append("allocated=").append(DebuggingUtils.toBase2SuffixedString(this.getAllocatedMemory())).append("B ");
        sb.append("occupied=").append(DebuggingUtils.toBase2SuffixedString(this.getOccupiedMemory())).append("B\n");
        sb.append("Storage Area: ").append(this.storageArea);
        return sb.toString();
    }

    @Override
    public void bind(OffHeapHashMap<?, ?> m) {
        if (this.owner != null) {
            throw new AssertionError();
        }
        this.owner = m;
    }

    @Override
    public void destroy() {
        this.storageArea.destroy();
    }

    @Override
    public boolean shrink() {
        return this.storageArea.shrink();
    }

    @Override
    public void removeAtAddress(int address) {
        int hash = this.storageArea.readInt(address + 0);
        int slot = this.owner.getSlotForHashAndEncoding(hash, 0xFFFFFFFFL & (long)address, -1L);
        this.owner.evict(slot, true);
    }

    @Override
    public void writeLock() {
        if (this.owner instanceof AbstractLockedOffHeapHashMap) {
            ((AbstractLockedOffHeapHashMap)this.owner).getWriteLock().lock();
        }
    }

    @Override
    public void writeUnlock() {
        if (this.owner instanceof AbstractLockedOffHeapHashMap) {
            ((AbstractLockedOffHeapHashMap)this.owner).getWriteLock().unlock();
        }
    }
}

