/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.storage;

import com.terracottatech.offheapstore.OffHeapHashMap;
import com.terracottatech.offheapstore.storage.HalfStorageEngine;
import com.terracottatech.offheapstore.storage.HalfStorageEngineFactory;
import com.terracottatech.offheapstore.storage.SplitStorageEngine;
import com.terracottatech.offheapstore.storage.StorageEngine;
import com.terracottatech.offheapstore.storage.StorageEngineFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongStorageEngine<V>
implements StorageEngine<Long, V> {
    private final HalfStorageEngine<V> valueStorage;

    public static <V> StorageEngineFactory<Long, V> createFactory(final HalfStorageEngineFactory<V> valueFactory) {
        return new StorageEngineFactory<Long, V>(){

            @Override
            public StorageEngine<Long, V> newInstance() {
                return new LongStorageEngine(valueFactory.newInstance());
            }
        };
    }

    public LongStorageEngine(HalfStorageEngine<V> valueStorage) {
        this.valueStorage = valueStorage;
    }

    @Override
    public Long writeMapping(Long key, V value, int hash) {
        Integer valueEncoding = this.valueStorage.write(value, hash);
        if (valueEncoding == null) {
            return null;
        }
        return SplitStorageEngine.encoding(key.intValue(), valueEncoding);
    }

    @Override
    public void freeMapping(long encoding) {
        this.valueStorage.free(SplitStorageEngine.valueEncoding(encoding));
    }

    @Override
    public V readValue(long encoding) {
        return this.valueStorage.read(SplitStorageEngine.valueEncoding(encoding));
    }

    @Override
    public boolean equalsValue(Object value, long encoding) {
        return this.valueStorage.equals(value, SplitStorageEngine.valueEncoding(encoding));
    }

    @Override
    public Long readKey(long encoding, int hashCode) {
        int keyEncoding = SplitStorageEngine.keyEncoding(encoding);
        return (long)(hashCode ^ keyEncoding) << 32 | (long)keyEncoding & 0xFFFFFFFFL;
    }

    @Override
    public boolean equalsKey(Object key, long encoding) {
        if (key instanceof Long) {
            return ((Long)key).intValue() == SplitStorageEngine.keyEncoding(encoding);
        }
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public long getAllocatedMemory() {
        return this.valueStorage.getAllocatedMemory();
    }

    @Override
    public long getOccupiedMemory() {
        return this.valueStorage.getOccupiedMemory();
    }

    public String toString() {
        return "LongStorageEngine : " + this.valueStorage;
    }

    @Override
    public void invalidateCache() {
        this.valueStorage.invalidateCache();
    }

    @Override
    public void bind(OffHeapHashMap<?, ?> owner) {
        this.valueStorage.bind(owner, 0xFFFFFFFFL);
    }

    @Override
    public void destroy() {
        this.valueStorage.destroy();
    }

    @Override
    public boolean shrink() {
        return this.valueStorage.shrink();
    }
}

