/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.statistics;

import com.terracottatech.offheapstore.Segment;
import com.terracottatech.offheapstore.statistics.DelegatingSegment;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LatencyMonitoringSegment<K, V>
extends DelegatingSegment<K, V> {
    private final LatencyMonitor getLatency = new LatencyMonitor();

    public LatencyMonitoringSegment(Segment<K, V> map) {
        super(map);
    }

    @Override
    public V get(Object key) {
        long start = System.nanoTime();
        Object value = super.get(key);
        this.getLatency.record(System.nanoTime() - start);
        return value;
    }

    @Override
    public long getAverageLatency() {
        return this.getLatency.getAverage();
    }

    @Override
    public long getMaximumLatency() {
        return this.getLatency.getMaximum();
    }

    @Override
    public long getMinimumLatency() {
        return this.getLatency.getMinimum();
    }

    @Override
    public long getSigmaLatency() {
        return (long)Math.sqrt(this.getLatency.getSigma());
    }

    @Override
    public long getLatencySampleSize() {
        return this.getLatency.getSampleSize();
    }

    static class LatencyMonitor {
        final AtomicLong n = new AtomicLong();
        final AtomicLong mean = new AtomicLong();
        final AtomicLong m2 = new AtomicLong();
        final AtomicLong maximum = new AtomicLong(Long.MIN_VALUE);
        final AtomicLong minimum = new AtomicLong(Long.MAX_VALUE);

        LatencyMonitor() {
        }

        long getAverage() {
            return this.mean.get();
        }

        long getMaximum() {
            return this.maximum.get();
        }

        long getMinimum() {
            return this.minimum.get();
        }

        long getSigma() {
            long ops = this.n.get();
            if (ops <= 1L) {
                return 0L;
            }
            return this.m2.get() / (ops - 1L);
        }

        long getSampleSize() {
            return this.n.get();
        }

        void record(long x) {
            long delta;
            long newMean;
            long currentMean;
            long currentN = this.n.incrementAndGet();
            while (!this.mean.compareAndSet(currentMean = this.mean.get(), newMean = currentMean + (delta = x - currentMean) / currentN)) {
            }
            this.m2.addAndGet(delta * (x - newMean));
            long max = this.maximum.get();
            while (x > max && !this.maximum.compareAndSet(max, x)) {
                max = this.maximum.get();
            }
            long min = this.minimum.get();
            while (x < min && !this.minimum.compareAndSet(min, x)) {
                min = this.minimum.get();
            }
        }
    }
}

