/*
 * Decompiled with CFR 0.152.
 */
package com.terracottatech.offheapstore.disk.paging;

import com.terracottatech.offheapstore.disk.paging.MappedPage;
import com.terracottatech.offheapstore.disk.paging.PowerOfTwoFileAllocator;
import com.terracottatech.offheapstore.paging.OffHeapStorageArea;
import com.terracottatech.offheapstore.paging.Page;
import com.terracottatech.offheapstore.paging.PageSource;
import com.terracottatech.offheapstore.util.DebuggingUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedPageSource
implements PageSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappedPageSource.class);
    private static final ExecutorService ASYNC_FLUSH_EXECUTOR = Executors.newSingleThreadExecutor(new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "MappedByteBufferSource Async Flush Thread");
            t.setDaemon(true);
            return t;
        }
    });
    private final File file;
    private final RandomAccessFile raf;
    private final FileChannel channel;
    private final PowerOfTwoFileAllocator allocator;
    private final IdentityHashMap<MappedPage, Long> pages = new IdentityHashMap();
    private final Map<Long, AllocatedRegion> allocated = new HashMap<Long, AllocatedRegion>();

    public MappedPageSource(File file) throws IOException {
        this(file, true);
    }

    public MappedPageSource(File file, boolean truncate) throws IOException {
        if (!file.createNewFile() && file.isDirectory()) {
            throw new IOException("File already exists and is a directory");
        }
        this.file = file;
        this.raf = new RandomAccessFile(file, "rw");
        this.channel = this.raf.getChannel();
        if (truncate) {
            try {
                this.channel.truncate(0L);
            }
            catch (IOException e) {
                LOGGER.info("Exception prevented truncation of disk store file", (Throwable)e);
            }
        }
        this.allocator = new PowerOfTwoFileAllocator();
    }

    public synchronized long allocateRegion(long size) {
        long address = this.allocator.allocate(size);
        this.allocated.put(address, new AllocatedRegion(address, size));
        long max = address + size;
        try {
            if (max > this.channel.size()) {
                ByteBuffer one = ByteBuffer.allocate(1);
                while (one.hasRemaining()) {
                    this.channel.write(one, max - 1L);
                }
            }
        }
        catch (IOException e) {
            LOGGER.warn("IOException while attempting to extend file " + this.file.getAbsolutePath(), (Throwable)e);
        }
        return address;
    }

    public synchronized void freeRegion(long address) {
        AllocatedRegion r = this.allocated.remove(address);
        if (r == null) {
            throw new AssertionError();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Freeing a {}B region from {} &{}", new Object[]{DebuggingUtils.toBase2SuffixedString(r.size), this.file.getName(), r.address});
        }
        this.allocator.free(r.address, r.size);
    }

    public synchronized long claimRegion(long address, long size) throws IOException {
        this.allocator.mark(address, size);
        this.allocated.put(address, new AllocatedRegion(address, size));
        return address;
    }

    public FileChannel getReadableChannel() {
        try {
            return new RandomAccessFile(this.file, "r").getChannel();
        }
        catch (FileNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    public FileChannel getWritableChannel() {
        try {
            return new RandomAccessFile(this.file, "rw").getChannel();
        }
        catch (FileNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    public File getFile() {
        return this.file;
    }

    public synchronized MappedPage allocate(int size, boolean thief, boolean victim, OffHeapStorageArea owner) {
        long address = this.allocateRegion(size);
        try {
            MappedByteBuffer buffer = this.channel.map(FileChannel.MapMode.READ_WRITE, address, size);
            MappedPage page = new MappedPage(buffer);
            this.pages.put(page, address);
            return page;
        }
        catch (IOException e) {
            this.freeRegion(address);
            LOGGER.warn("Mapping a new file section failed", (Throwable)e);
            return null;
        }
    }

    public synchronized void free(final Page page) {
        final Long a = this.pages.remove(page);
        if (a == null) {
            throw new AssertionError();
        }
        ASYNC_FLUSH_EXECUTOR.execute(new Runnable(){

            public void run() {
                ((MappedByteBuffer)page.asByteBuffer()).force();
                MappedPageSource.this.freeRegion(a);
            }
        });
    }

    public synchronized MappedPage claimPage(long address, long size) throws IOException {
        this.claimRegion(address, size);
        MappedByteBuffer buffer = this.channel.map(FileChannel.MapMode.READ_WRITE, address, size);
        MappedPage page = new MappedPage(buffer);
        this.pages.put(page, address);
        return page;
    }

    public long getAddress(Page underlying) {
        return this.pages.get(underlying);
    }

    public synchronized void flush() throws IOException {
        if (this.channel.isOpen()) {
            this.channel.force(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws IOException {
        try {
            this.channel.close();
        }
        finally {
            this.raf.close();
        }
    }

    static class AllocatedRegion {
        final long address;
        final long size;

        public AllocatedRegion(long address, long size) {
            this.address = address;
            this.size = size;
        }
    }
}

